/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class JSONResourcePermissionsFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws JSONException {
        if (!absolutePath.endsWith("resource-permissions.json")) {
            return content;
        }
        JSONArrayImpl jsonArray = new JSONArrayImpl(content);
        List<Object> objects = JSONUtil.toObjectList(jsonArray);
        Collections.sort(objects, new ResourceNameComparator());
        jsonArray = new JSONArrayImpl();
        for (Object object : objects) {
            jsonArray.put(object);
        }
        return JSONUtil.toString(jsonArray);
    }

    private class ResourceNameComparator
    implements Comparator<Object> {
        private ResourceNameComparator() {
        }

        @Override
        public int compare(Object object1, Object object2) {
            JSONObject jsonObject2;
            String resourceName2;
            JSONObject jsonObject1 = (JSONObject)object1;
            String resourceName1 = jsonObject1.getString("resourceName");
            if (!resourceName1.equals(resourceName2 = (jsonObject2 = (JSONObject)object2).getString("resourceName"))) {
                return resourceName1.compareTo(resourceName2);
            }
            String roleName1 = jsonObject1.getString("roleName");
            String roleName2 = jsonObject2.getString("roleName");
            return roleName1.compareTo(roleName2);
        }
    }
}

