/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.List;

public class JSPIllegalTagsCheck
extends BaseFileCheck {
    private static final String _ILLEGAL_TAG_NAMES_KEY = "illegalTagNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String lowerCaseFileName = StringUtil.lowerCase(fileName);
        List<String> illegalTagNames = this.getAttributeValues(_ILLEGAL_TAG_NAMES_KEY, absolutePath);
        if (lowerCaseFileName.endsWith(".jsp") || lowerCaseFileName.endsWith(".jspf") || lowerCaseFileName.endsWith(".jspx")) {
            for (String illegalTagName : illegalTagNames) {
                int nextCharPosition;
                int x = -1;
                while ((x = content.indexOf('<' + illegalTagName, x + 1)) != -1 && (nextCharPosition = x + illegalTagName.length() + 1) < content.length()) {
                    char nextChar = content.charAt(nextCharPosition);
                    if (nextChar != '>' && nextChar != '\n' && nextChar != ' ') continue;
                    this.addMessage(fileName, StringBundler.concat("Do not use <", illegalTagName, "> tag (use ", "<aui:", illegalTagName, "> instead), see ", "LPD-18227"), this.getLineNumber(content, x));
                }
            }
        } else if (lowerCaseFileName.endsWith(".ftl")) {
            this._checkAttribute("${nonceAttribute}", content, fileName, illegalTagNames);
        } else if (lowerCaseFileName.endsWith(".vm")) {
            this._checkAttribute("$nonceAttribute", content, fileName, illegalTagNames);
        }
        return content;
    }

    private void _checkAttribute(String attribute, String content, String fileName, List<String> illegalTagNames) {
        for (String illegalTagName : illegalTagNames) {
            int x = -1;
            while ((x = content.indexOf('<' + illegalTagName, x + 1)) != -1) {
                String tagSubstring;
                int y = content.indexOf(62, x + 1);
                if (y == -1) {
                    y = content.length() - 1;
                }
                if ((tagSubstring = content.substring(x, y)).contains(attribute)) continue;
                this.addMessage(fileName, StringBundler.concat("Tag <", illegalTagName, "> is missing attribute '", attribute, "', see LPD-18227"), this.getLineNumber(content, x));
            }
        }
    }
}

