/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleUtilCheck
extends BaseFileCheck {
    private static final String _LOCALE_UTIL_FILE_NAME = "portal-kernel/src/com/liferay/portal/kernel/util/LocaleUtil.java";
    private static final Pattern _localePattern = Pattern.compile("\\WLocale\\.(\\w+)\\W");
    private List<String> _localeUtilTermNames;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException, ParseException {
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            return content;
        }
        Matcher matcher = _localePattern.matcher(content);
        while (matcher.find()) {
            List<String> localeUtilTermNames = this._getLocaleUtilTermNames(absolutePath);
            if (!localeUtilTermNames.contains(matcher.group(1))) continue;
            this.addMessage(fileName, "Use 'LocaleUtil." + matcher.group(1) + "'", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }

    private synchronized List<String> _getLocaleUtilTermNames(String absolutePath) throws IOException, ParseException {
        if (this._localeUtilTermNames != null) {
            return this._localeUtilTermNames;
        }
        this._localeUtilTermNames = new ArrayList<String>();
        String localeUtilClassContent = this.getPortalContent(_LOCALE_UTIL_FILE_NAME, absolutePath);
        if (localeUtilClassContent == null) {
            return this._localeUtilTermNames;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(_LOCALE_UTIL_FILE_NAME, localeUtilClassContent);
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if (!javaTerm.isPublic()) continue;
            this._localeUtilTermNames.add(javaTerm.getName());
        }
        return this._localeUtilTermNames;
    }
}

