/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;

public class JavaUnsafeCastingCheck
extends BaseFileCheck {
    private static final String[] _UNSAFE_CLASS_NAMES = new String[]{"LiferayPortletRequest", "LiferayPortletResponse"};

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        for (String unsafeClassName : _UNSAFE_CLASS_NAMES) {
            int pos = -1;
            while ((pos = content.indexOf("(" + unsafeClassName + ")", pos + 1)) != -1) {
                String message = "Unsafe casting for '" + unsafeClassName + "'";
                this.addMessage(fileName, message, this.getLineNumber(content, pos));
            }
        }
        return content;
    }
}

