/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.JavaSourceTabCalculator;
import com.liferay.source.formatter.util.FileUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.java"};
    private static final int _MAX_LINE_LENGTH = 80;
    private static Pattern _annotationPattern = Pattern.compile("(\t*)@(.+)\\(\n([\\s\\S]*?)\\)\n");
    private boolean _addMissingDeprecationReleaseVersion;
    private boolean _allowUseServiceUtilInServiceImpl;
    private Map<String, Tuple> _bndInheritRequiredTupleMap = new HashMap<String, Tuple>();
    private Pattern _catchExceptionPattern = Pattern.compile("\n(\t+)catch \\((.+Exception) (.+)\\) \\{\n");
    private List<String> _checkJavaFieldTypesExcludes;
    private List<String> _checkTabsExcludes;
    private boolean _checkUnprocessedExceptions;
    private final Pattern _classPattern = Pattern.compile("(\n(\t*)(private|protected|public) ((abstract|static) )*(class|enum|interface) ([\\s\\S]*?) \\{)\n(\\s*)(\\S)");
    private Pattern _combinedLinesPattern1 = Pattern.compile("\n(\t*).+(=|\\]) (\\{)\n");
    private Pattern _combinedLinesPattern2 = Pattern.compile("\n(\t*)@.+(\\()\n");
    private Pattern _componentAnnotationPattern = Pattern.compile("@Component(\n|\\([\\s\\S]*?\\)\n)");
    private List<String> _diamondOperatorExcludes;
    private Pattern _diamondOperatorPattern = Pattern.compile("(return|=)\n?(\t+| )new ([A-Za-z]+)(\\s*)<(.+)>\\(\n*\t*.*\\);\n");
    private Pattern _fetchByPrimaryKeysMethodPattern = Pattern.compile("@Override\n\tpublic Map<(.+)> fetchByPrimaryKeys\\(");
    private List<String> _fitOnSingleLineExcludes;
    private List<String> _hibernateSQLQueryExcludes;
    private Pattern _incorrectCloseCurlyBracePattern1 = Pattern.compile("\n(.+)\n\n(\t+)}\n");
    private Pattern _incorrectCloseCurlyBracePattern2 = Pattern.compile("(\t| )@?(class |enum |interface |new )");
    private Pattern _incorrectLineBreakPattern1 = Pattern.compile("\t(catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private Pattern _incorrectLineBreakPattern2 = Pattern.compile("\\{\n\n\t*\\}");
    private Pattern _incorrectLineBreakPattern3 = Pattern.compile(", new .*\\(.*\\) \\{\n");
    private Pattern _incorrectLineBreakPattern4 = Pattern.compile("\n(\t*)(.*\\) \\{)([\t ]*\\}\n)");
    private Pattern[] _javaSerializationVulnerabilityPatterns = new Pattern[]{Pattern.compile(".*(new [a-z\\.\\s]*ObjectInputStream).*", 32), Pattern.compile(".*(extends [a-z\\.\\s]*ObjectInputStream).*", 32)};
    private List<String> _javaTermAccessLevelModifierExcludes;
    private List<String> _javaTermSortExcludes;
    private List<String> _lineLengthExcludes;
    private Pattern _logLevelPattern = Pattern.compile("\n(\t+)_log.(debug|info|trace|warn)\\(");
    private Pattern _logPattern = Pattern.compile("\n\tprivate static final Log _log = LogFactoryUtil.getLog\\(\n*\t*(.+)\\.class\\)");
    private Pattern _lowerCaseNumberOrPeriodPattern = Pattern.compile("[a-z0-9.]");
    private Pattern _missingEmptyLinePattern1 = Pattern.compile("(\t| = |return )new .*\\(.*\\) \\{\n\t+[^{\t]");
    private Pattern _missingEmptyLinePattern2 = Pattern.compile("(\n\t*)(public|private|protected) [^;]+? \\{");
    private Map<String, String> _moduleFileContentsMap = new HashMap<String, String>();
    private Map<String, String> _moduleFileNamesMap;
    private Pattern _processCallablePattern = Pattern.compile("implements ProcessCallable\\b");
    private List<String> _proxyExcludes;
    private Pattern _redundantCommaPattern = Pattern.compile(",\n\t+\\}");
    private Pattern _redundantEmptyLines1 = Pattern.compile("\n\npublic ((abstract|static) )*(class|enum|interface) ");
    private Pattern _redundantEmptyLines2 = Pattern.compile(" \\* @author .*\n \\*\\/\n\n");
    private Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");
    private Pattern _referenceMethodPattern = Pattern.compile("\n\t@Reference([\\s\\S]*?)\\s+((protected|public) void (\\w+?))\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
    private List<String> _secureDeserializationExcludes;
    private List<String> _secureRandomExcludes;
    private List<String> _secureXmlExcludes;
    private Pattern _serviceUtilImportPattern = Pattern.compile("\nimport ([A-Za-z1-9\\.]*)\\.([A-Za-z1-9]*ServiceUtil);");
    private Pattern _stagedModelTypesPattern = Pattern.compile("StagedModelType\\(([a-zA-Z.]*(class|getClassName[\\(\\)]*))\\)");
    private List<String> _staticLogVariableExcludes;
    private List<String> _testAnnotationsExcludes;
    private Pattern _throwsSystemExceptionPattern = Pattern.compile("(\n\t+.*)throws(.*) SystemException(.*)( \\{|;\n)");
    private List<String> _upgradeServiceUtilExcludes;

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    protected static String checkAnnotationParameterProperties(String content, String annotation) {
        int x = annotation.indexOf("property = {");
        if (x == -1) {
            return null;
        }
        int y = x;
        while (ToolsUtil.isInsideQuotes(annotation, y = annotation.indexOf(125, y + 1))) {
        }
        String parameterProperties = annotation.substring(x + 12, y);
        parameterProperties = StringUtil.replace(parameterProperties, "\n", " ");
        String[] parameterPropertiesArray = StringUtil.split(parameterProperties, ", ");
        String previousPropertyName = null;
        String previousPropertyNameAndValue = null;
        for (String parameterProperty : parameterPropertiesArray) {
            x = parameterProperty.indexOf(34);
            y = parameterProperty.indexOf(61, x);
            int z = x;
            while ((z = parameterProperty.indexOf(34, z + 1)) != -1 && ToolsUtil.isInsideQuotes(parameterProperty, z)) {
            }
            if (x == -1 || y == -1 || z == -1) {
                return null;
            }
            String propertyName = parameterProperty.substring(x + 1, y);
            String propertyNameAndValue = parameterProperty.substring(x + 1, z);
            if (Validator.isNotNull(previousPropertyName) && previousPropertyName.compareToIgnoreCase(propertyName) > 0) {
                content = StringUtil.replaceFirst(content, previousPropertyNameAndValue, propertyNameAndValue);
                content = StringUtil.replaceLast(content, propertyNameAndValue, previousPropertyNameAndValue);
                return content;
            }
            previousPropertyName = propertyName;
            previousPropertyNameAndValue = propertyNameAndValue;
        }
        return null;
    }

    protected String applyDiamondOperator(String content) {
        Matcher matcher = this._diamondOperatorPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String whitespace = matcher.group(4);
            String parameterType = matcher.group(5);
            String replacement = StringUtil.replaceFirst(match, whitespace + "<" + parameterType + ">", "<>");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }

    protected void checkAnnotationParameters(String fileName, String javaTermName, String annotation) {
        block5: {
            String parameterName;
            int x = annotation.indexOf(40);
            String annotationParameters = JavaSourceProcessor.stripQuotes(annotation.substring(x + 1), '\"');
            x = -1;
            int y = -1;
            String previousParameterName = "";
            while (true) {
                if ((x = annotationParameters.indexOf(61, x + 1)) == -1) {
                    return;
                }
                if (Validator.isNotNull(previousParameterName) && (y = annotationParameters.lastIndexOf(44, x)) == -1) {
                    return;
                }
                parameterName = StringUtil.trim(annotationParameters.substring(y + 1, x));
                if (parameterName.startsWith("{")) break block5;
                if (!Validator.isNull(previousParameterName) && previousParameterName.compareToIgnoreCase(parameterName) > 0) break;
                previousParameterName = parameterName;
            }
            x = annotation.indexOf(64);
            y = annotation.indexOf(40);
            if (x == -1 || x > y) {
                return;
            }
            StringBundler sb = new StringBundler(8);
            sb.append("sort: ");
            if (Validator.isNotNull(javaTermName)) {
                sb.append(javaTermName);
                sb.append("#");
            }
            String annotationName = annotation.substring(x, y);
            sb.append(annotationName);
            sb.append("#");
            sb.append(parameterName);
            sb.append(" ");
            sb.append(fileName);
            this.processErrorMessage(fileName, sb.toString());
            return;
        }
    }

    protected void checkBndInheritAnnotationOption() {
        for (Map.Entry<String, Tuple> entry : this._bndInheritRequiredTupleMap.entrySet()) {
            String bndFileLocation = entry.getKey();
            Tuple bndInheritTuple = entry.getValue();
            String bndContent = (String)bndInheritTuple.getObject(0);
            boolean bndInheritRequired = (Boolean)bndInheritTuple.getObject(1);
            if (bndContent.contains("-dsannotations-options: inherit")) {
                if (bndInheritRequired) continue;
                this.printError(bndFileLocation, "Redundant '-dsannotations-options: inherit': " + bndFileLocation + "bnd.bnd");
                continue;
            }
            if (!bndInheritRequired) continue;
            this.printError(bndFileLocation, "Add '-dsannotations-options: inherit': " + bndFileLocation + "bnd.bnd");
        }
    }

    protected void checkDeserializationSecurity(String fileName, String content, boolean isRunOutsidePortalExclusion) {
        for (Pattern vulnerabilityPattern : this._javaSerializationVulnerabilityPatterns) {
            Matcher matcher = vulnerabilityPattern.matcher(content);
            if (!matcher.matches()) continue;
            StringBundler sb = new StringBundler(5);
            if (isRunOutsidePortalExclusion) {
                sb.append("Possible Java Serialization Remote Code Execution ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use ProtectedObjectInputStream instead of ");
            }
            sb.append(matcher.group(1));
            sb.append(": ");
            sb.append(fileName);
            this.processErrorMessage(fileName, sb.toString());
        }
    }

    protected void checkFinderCacheInterfaceMethod(String fileName, String content) {
        if (!fileName.endsWith("FinderImpl.java") || !content.contains("public static final FinderPath")) {
            return;
        }
        Matcher matcher = this._fetchByPrimaryKeysMethodPattern.matcher(content);
        if (!matcher.find()) {
            this.processErrorMessage(fileName, "LPS-49552: Missing override of BasePersistenceImpl.fetchByPrimaryKeys(Set<Serializable>): " + fileName);
        }
    }

    protected void checkLogLevel(String content, String fileName) {
        if (fileName.contains("Log")) {
            return;
        }
        Matcher matcher = this._logLevelPattern.matcher(content);
        while (matcher.find()) {
            String s;
            char c;
            int pos = matcher.start();
            while ((c = content.charAt((pos = content.lastIndexOf("\n\t", pos - 1)) + 2)) == '\t') {
            }
            String codeBlock = content.substring(pos, matcher.start());
            if (codeBlock.contains(s = "_log.is" + StringUtil.upperCaseFirstLetter(matcher.group(2)) + "Enabled()")) continue;
            int lineCount = this.getLineCount(content, matcher.start(1));
            this.processErrorMessage(fileName, "Use " + s + ": " + fileName + " " + lineCount);
        }
    }

    protected void checkRegexPattern(String regexPattern, String fileName, int lineCount) {
        int i = regexPattern.indexOf("Pattern.compile(");
        if (i == -1) {
            return;
        }
        regexPattern = regexPattern.substring(i + 16);
        i = (regexPattern = JavaSourceProcessor.stripQuotes(regexPattern, '\"')).indexOf(44);
        regexPattern = i != -1 ? regexPattern.substring(0, i) : StringUtil.replaceLast(regexPattern, ");", "");
        if (Validator.isNull(regexPattern = StringUtil.replace(regexPattern, "+", ""))) {
            this.processErrorMessage(fileName, "create pattern as global var: " + fileName + " " + lineCount);
        }
    }

    protected void checkSystemEventAnnotations(String content, String fileName) throws Exception {
        if (!portalSource || !fileName.endsWith("PortletDataHandler.java")) {
            return;
        }
        int pos = content.indexOf("setDeletionSystemEventStagedModelTypes");
        if (pos == -1) {
            return;
        }
        String deletionSystemEventStagedModelTypes = content.substring(pos, content.indexOf(");", pos));
        Matcher matcher = this._stagedModelTypesPattern.matcher(deletionSystemEventStagedModelTypes);
        while (matcher.find()) {
            String stagedModelTypeClassName = matcher.group(1);
            pos = stagedModelTypeClassName.indexOf(".class");
            if (pos == -1) {
                pos = stagedModelTypeClassName.indexOf("Constants");
            }
            if (pos == -1) {
                return;
            }
            String className = stagedModelTypeClassName.substring(0, pos);
            Pattern packageNamePattern = Pattern.compile("import (com\\.liferay\\.[a-zA-Z\\.]*)\\.model\\." + className + ";");
            Matcher packageNameMatcher = packageNamePattern.matcher(content);
            if (!packageNameMatcher.find()) {
                return;
            }
            StringBundler sb = new StringBundler(5);
            sb.append(fileName.substring(0, fileName.indexOf("/src/") + 5));
            sb.append(StringUtil.replace(packageNameMatcher.group(1), ".", "/"));
            sb.append("/service/impl/");
            sb.append(className);
            sb.append("LocalServiceImpl.java");
            String localServiceImplFileName = sb.toString();
            String localServiceImplContent = FileUtil.read(new File(localServiceImplFileName));
            if (localServiceImplContent == null) {
                return;
            }
            if (localServiceImplContent.contains("@SystemEvent")) continue;
            this.processErrorMessage(fileName, "Missing deletion system event: " + localServiceImplFileName);
        }
    }

    protected void checkXMLSecurity(String fileName, String content, boolean isRunOutsidePortalExclusion) {
        String[] xmlVulnerabitilies;
        for (String xmlVulnerabitily : xmlVulnerabitilies = new String[]{"DocumentBuilderFactory.newInstance", "new javax.xml.parsers.SAXParser", "new org.apache.xerces.parsers.SAXParser", "new org.dom4j.io.SAXReader", "new SAXParser", "new SAXReader", "SAXParserFactory.newInstance", "saxParserFactory.newInstance", "SAXParserFactory.newSAXParser", "saxParserFactory.newSAXParser", "XMLInputFactory.newFactory", "xmlInputFactory.newFactory", "XMLInputFactory.newInstance", "xmlInputFactory.newInstance"}) {
            if (!content.contains(xmlVulnerabitily)) continue;
            StringBundler sb = new StringBundler(5);
            if (isRunOutsidePortalExclusion) {
                sb.append("Possible XXE or Quadratic Blowup security ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use SecureXMLBuilderUtil.newDocumentBuilderFactory");
                sb.append(" instead of ");
            }
            sb.append(xmlVulnerabitily);
            sb.append(": ");
            sb.append(fileName);
            this.processErrorMessage(fileName, sb.toString());
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String componentAnnotation;
        boolean isRunOutsidePortalExclusion;
        String logClassName;
        Matcher matcher;
        if (this.hasGeneratedTag(content)) {
            return content;
        }
        String className = file.getName();
        int pos = className.lastIndexOf(46);
        className = className.substring(0, pos);
        String packagePath = ToolsUtil.getPackagePath(file);
        if (!content.contains("package " + packagePath + ";")) {
            this.processErrorMessage(fileName, "Incorrect package path: " + fileName);
        }
        if (packagePath.endsWith(".model") && content.contains("extends " + className + "Model")) {
            return content;
        }
        String newContent = this.trimContent(content, false);
        if (newContent.contains("$\n */")) {
            this.processErrorMessage(fileName, "*: " + fileName);
            newContent = StringUtil.replace(newContent, "$\n */", "$\n *\n */");
        }
        if ((newContent = this.fixCopyright(newContent, absolutePath, fileName)).contains(className + ".java.html")) {
            this.processErrorMessage(fileName, "Java2HTML: " + fileName);
        }
        if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
            newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
            this.processErrorMessage(fileName, "UTF-8: " + fileName);
        }
        if (!newContent.contains(" * @author ")) {
            this.processErrorMessage(fileName, "Missing author: " + fileName);
        }
        newContent = this.fixDataAccessConnection(className, newContent);
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = StringUtil.replace(newContent, new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil"}, new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil"});
        newContent = StringUtil.replace(newContent, " final static ", " static final ");
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        newContent = JavaImportsFormatter.stripJavaImports(newContent, packagePath, className);
        newContent = StringUtil.replace(newContent, new String[]{";\n/**", "\t/*\n\t *", ";;\n", "\n/**\n *\n *"}, new String[]{";\n\n/**", "\t/**\n\t *", ";\n", "\n/**\n *"});
        newContent = this.fixMissingEmptyLines(newContent);
        newContent = this.fixRedundantEmptyLines(newContent);
        while (true) {
            String matchingLine;
            if ((matcher = this._incorrectLineBreakPattern1.matcher(newContent)).find()) {
                newContent = StringUtil.replaceFirst(newContent, "\n", "", matcher.start());
                continue;
            }
            matcher = this._incorrectLineBreakPattern2.matcher(newContent);
            if (matcher.find()) {
                newContent = StringUtil.replaceFirst(newContent, "\n", "", matcher.start());
                continue;
            }
            matcher = this._incorrectLineBreakPattern4.matcher(newContent);
            if (matcher.find() && !(matchingLine = matcher.group(2)).startsWith("//") && !matchingLine.startsWith("*")) {
                newContent = StringUtil.replaceFirst(newContent, matcher.group(3), "\n" + matcher.group(1) + "}\n", matcher.start(3) - 1);
                continue;
            }
            matcher = this._redundantCommaPattern.matcher(newContent);
            if (!matcher.find()) break;
            newContent = StringUtil.replaceFirst(newContent, ",", "", matcher.start());
        }
        matcher = this._incorrectLineBreakPattern3.matcher(newContent);
        while (matcher.find()) {
            int openParenthesesCount;
            String match = matcher.group();
            int closeParenthesesCount = StringUtil.count(match, ")");
            if (closeParenthesesCount != (openParenthesesCount = StringUtil.count(match, "("))) continue;
            int lineCount = this.getLineCount(newContent, matcher.start());
            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
        }
        matcher = this._logPattern.matcher(newContent = this.formatAnnotations(fileName, "", newContent, ""));
        if (matcher.find() && !(logClassName = matcher.group(1)).equals(className)) {
            newContent = StringUtil.replaceLast(newContent, logClassName + ".class)", className + ".class)");
        }
        if (!JavaSourceProcessor.isExcludedPath(this._staticLogVariableExcludes, absolutePath)) {
            newContent = StringUtil.replace(newContent, "private Log _log", "private static final Log _log");
        }
        if (newContent.contains("*/\npackage ")) {
            this.processErrorMessage(fileName, "package: " + fileName);
        }
        if (portalSource && !this._allowUseServiceUtilInServiceImpl && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
            this.processErrorMessage(fileName, "ServiceUtil: " + fileName);
        }
        if (portalSource && !JavaSourceProcessor.isExcludedPath(this._upgradeServiceUtilExcludes, absolutePath) && fileName.contains("/portal/upgrade/") && !fileName.contains("/test/") && !fileName.contains("/testIntegration/") && newContent.contains("ServiceUtil.")) {
            this.processErrorMessage(fileName, "ServiceUtil: " + fileName);
        }
        if (!(isRunOutsidePortalExclusion = JavaSourceProcessor.isExcludedPath(this.getRunOutsidePortalExcludes(), absolutePath)) && !JavaSourceProcessor.isExcludedPath(this._proxyExcludes, absolutePath) && newContent.contains("import java.lang.reflect.Proxy;")) {
            this.processErrorMessage(fileName, "Proxy: " + fileName);
        }
        if (newContent.contains("import edu.emory.mathcs.backport.java")) {
            this.processErrorMessage(fileName, "edu.emory.mathcs.backport.java: " + fileName);
        }
        if (newContent.contains("import jodd.util.StringPool")) {
            this.processErrorMessage(fileName, "jodd.util.StringPool: " + fileName);
        }
        if (newContent.contains("com.liferay.portal.kernel.util.UnmodifiableList")) {
            this.processErrorMessage(fileName, "Use java.util.Collections.unmodifiableList instead of com.liferay.portal.kernel.util.UnmodifiableList: " + fileName);
        }
        int pos1 = -1;
        while ((pos1 = newContent.indexOf("\ttry {", pos1 + 1)) != -1) {
            int pos2 = newContent.indexOf("\ttry {", pos1 + 1);
            int pos3 = newContent.indexOf("\"select count(", pos1);
            if (pos2 != -1 && pos3 != -1 && pos2 < pos3) continue;
            int pos4 = newContent.indexOf("rs.getLong(1)", pos1);
            int pos5 = newContent.indexOf("\tfinally {", pos1);
            if (pos3 == -1 || pos4 == -1 || pos5 == -1) break;
            if (pos3 >= pos4 || pos4 >= pos5) continue;
            this.processErrorMessage(fileName, "Use getInt(1) for count: " + fileName);
        }
        matcher = this._processCallablePattern.matcher(content);
        if (matcher.find() && !content.contains("private static final long serialVersionUID")) {
            this.processErrorMessage(fileName, "Assign ProcessCallable implementation a serialVersionUID: " + fileName);
        }
        this.checkLanguageKeys(fileName, absolutePath, newContent, languageKeyPattern);
        newContent = StringUtil.replace(newContent, "\tfor (;;) {", "\twhile (true) {");
        newContent = this.formatExceptions(newContent, file, packagePath, fileName);
        if (!isRunOutsidePortalExclusion && !JavaSourceProcessor.isExcludedPath(this._secureRandomExcludes, absolutePath) && content.contains("java.security.SecureRandom") && !content.contains("javax.crypto.KeyGenerator")) {
            this.processErrorMessage(fileName, "Use SecureRandomUtil or com.liferay.portal.kernel.security.SecureRandom instead of java.security.SecureRandom: " + fileName);
        }
        this.checkLogLevel(newContent, fileName);
        this.checkSystemEventAnnotations(newContent, fileName);
        if (fileName.contains("/upgrade/") && newContent.contains("LocaleUtil.getDefault()")) {
            this.processErrorMessage(fileName, "Use UpgradeProcessUtil.getDefaultLanguageId(companyId) instead of LocaleUtil.getDefault(): " + fileName);
        }
        newContent = StringUtil.replace(newContent, " static interface ", " interface ");
        newContent = this.fixSystemExceptions(newContent);
        if (portalSource && (fileName.contains("/test/integration/") || fileName.contains("/testIntegration/java"))) {
            newContent = StringUtil.replace(newContent, "FinderCacheUtil.clearCache();", "");
        }
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, false, fileName);
        if (portalSource && fileName.contains("/portal-service/") && content.contains("import javax.servlet.jsp.")) {
            this.processErrorMessage(fileName, "Never import javax.servlet.jsp.* from portal-service " + fileName);
        }
        if (!JavaSourceProcessor.isExcludedPath(this._diamondOperatorExcludes, absolutePath)) {
            newContent = this.applyDiamondOperator(newContent);
        }
        this.checkFinderCacheInterfaceMethod(fileName, newContent);
        if (!(fileName.contains("/test/") || fileName.contains("/testIntegration/") || JavaSourceProcessor.isExcludedPath(this._secureXmlExcludes, absolutePath))) {
            this.checkXMLSecurity(fileName, content, isRunOutsidePortalExclusion);
        }
        if (!(fileName.contains("/test/") || fileName.contains("/testIntegration/") || JavaSourceProcessor.isExcludedPath(this._secureDeserializationExcludes, absolutePath))) {
            this.checkDeserializationSecurity(fileName, content, isRunOutsidePortalExclusion);
        }
        if (newContent.contains("org.testng.Assert")) {
            this.processErrorMessage(fileName, "Use org.junit.Assert instead of org.testng.Assert: " + fileName);
        }
        if (portalSource && this.isModulesFile(absolutePath)) {
            newContent = this.formatModulesFile(fileName, absolutePath, className, packagePath, newContent);
        }
        newContent = this.checkPrincipalException(newContent);
        if (fileName.endsWith("Upgrade.java") && newContent.contains("implements UpgradeStepRegistrator") && (matcher = this._componentAnnotationPattern.matcher(newContent)).find() && !(componentAnnotation = matcher.group()).contains("service =")) {
            this.processErrorMessage(fileName, "Missing service in @Component " + fileName);
        }
        if (newContent.contains(".supportsBatchUpdates()") && !fileName.endsWith("AutoBatchPreparedStatementUtil.java")) {
            this.processErrorMessage(fileName, "Use AutoBatchPreparedStatementUtil instead of DatabaseMetaData.supportsBatchUpdates: " + fileName);
        }
        newContent = this.getCombinedLinesContent(newContent, this._combinedLinesPattern1);
        newContent = this.getCombinedLinesContent(newContent, this._combinedLinesPattern2);
        newContent = this.formatClassLine(newContent);
        pos = (newContent = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(newContent, fileName)).indexOf("\npublic ");
        if (pos != -1) {
            String javaClassContent = newContent.substring(pos + 1);
            int javaClassLineCount = this.getLineCount(newContent, pos + 1);
            newContent = this.formatJavaTerms(className, packagePath, file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, this._checkJavaFieldTypesExcludes, this._javaTermAccessLevelModifierExcludes, this._javaTermSortExcludes, this._testAnnotationsExcludes);
        }
        newContent = this.formatJava(fileName, absolutePath, newContent);
        if (!JavaSourceProcessor.isExcludedPath(this._checkTabsExcludes, absolutePath)) {
            JavaSourceTabCalculator javaSourceTabCalculator = new JavaSourceTabCalculator();
            javaSourceTabCalculator.calculateTabs(fileName, newContent, this);
        }
        return StringUtil.replace(newContent, "\n\n\n", "\n\n");
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        Collection<String> fileNames = null;
        if (portalSource) {
            fileNames = this.getPortalJavaFiles();
            this._checkUnprocessedExceptions = GetterUtil.getBoolean(System.getProperty("source.formatter.check.unprocessed.exceptions"));
        } else {
            fileNames = this.getPluginJavaFiles();
        }
        this._addMissingDeprecationReleaseVersion = GetterUtil.getBoolean(this.getProperty("add.missing.deprecation.release.version"));
        this._allowUseServiceUtilInServiceImpl = GetterUtil.getBoolean(this.getProperty("allow.use.service.util.in.service.impl"));
        this._checkJavaFieldTypesExcludes = this.getPropertyList("check.java.field.types.excludes");
        this._checkTabsExcludes = this.getPropertyList("check.tabs.excludes");
        this._diamondOperatorExcludes = this.getPropertyList("diamond.operator.excludes");
        this._fitOnSingleLineExcludes = this.getPropertyList("fit.on.single.line.excludes");
        this._hibernateSQLQueryExcludes = this.getPropertyList("hibernate.sql.query.excludes");
        this._javaTermAccessLevelModifierExcludes = this.getPropertyList("javaterm.access.level.modifier.excludes");
        this._javaTermSortExcludes = this.getPropertyList("javaterm.sort.excludes");
        this._lineLengthExcludes = this.getPropertyList("line.length.excludes");
        this._proxyExcludes = this.getPropertyList("proxy.excludes");
        this._secureDeserializationExcludes = this.getPropertyList("secure.deserialization.excluded.files");
        this._secureRandomExcludes = this.getPropertyList("secure.random.excludes");
        this._secureXmlExcludes = this.getPropertyList("secure.xml.excludes");
        this._staticLogVariableExcludes = this.getPropertyList("static.log.excludes");
        this._testAnnotationsExcludes = this.getPropertyList("test.annotations.excludes");
        this._upgradeServiceUtilExcludes = this.getPropertyList("upgrade.service.util.excludes");
        return new ArrayList<String>(fileNames);
    }

    protected String fixDataAccessConnection(String className, String content) {
        int x = content.indexOf("package ");
        int y = content.indexOf(59, x);
        if (x == -1 || y == -1) {
            return content;
        }
        String packageName = content.substring(x + 8, y);
        if (!(packageName.startsWith("com.liferay.portal.kernel.upgrade") || packageName.startsWith("com.liferay.portal.kernel.verify") || packageName.startsWith("com.liferay.portal.upgrade") || packageName.startsWith("com.liferay.portal.verify"))) {
            return content;
        }
        content = StringUtil.replace(content, "DataAccess.getConnection", "DataAccess.getUpgradeOptimizedConnection");
        return content;
    }

    protected String fixIfClause(String ifClause, String line, int delta) {
        if (StringUtil.count(ifClause, line) > 1) {
            return ifClause;
        }
        String newLine = line;
        String whitespace = "";
        int whitespaceLength = Math.abs(delta);
        while (whitespaceLength > 0) {
            if (whitespaceLength >= 4) {
                whitespace = whitespace + "\t";
                whitespaceLength -= 4;
                continue;
            }
            whitespace = whitespace + " ";
            --whitespaceLength;
        }
        if (delta > 0) {
            if (!line.contains("\t" + whitespace)) {
                newLine = StringUtil.replaceLast(newLine, "\t", "    ");
            }
            newLine = StringUtil.replaceLast(newLine, "\t" + whitespace, "\t");
        } else {
            newLine = StringUtil.replaceLast(newLine, "\t", "\t" + whitespace);
        }
        newLine = StringUtil.replaceLast(newLine, "    ", "\t");
        return StringUtil.replace(ifClause, line, newLine);
    }

    protected String fixIncorrectEmptyLineBeforeCloseCurlyBrace(String content, String fileName) {
        Matcher matcher1 = this._incorrectCloseCurlyBracePattern1.matcher(content);
        while (matcher1.find()) {
            String lastLine = StringUtil.trimLeading(matcher1.group(1));
            if (lastLine.startsWith("// ")) continue;
            String tabs = matcher1.group(2);
            int tabCount = tabs.length();
            int pos = matcher1.start();
            while (content.charAt((pos = content.lastIndexOf("\n" + tabs, pos - 1)) + tabCount + 1) == '\t') {
            }
            String codeBlock = content.substring(pos + 1, matcher1.end());
            String firstLine = codeBlock.substring(0, codeBlock.indexOf(10));
            Matcher matcher2 = this._incorrectCloseCurlyBracePattern2.matcher(firstLine);
            if (matcher2.find()) continue;
            return StringUtil.replaceFirst(content, "\n\n" + tabs + "}\n", "\n" + tabs + "}\n", pos);
        }
        return content;
    }

    protected String fixMissingEmptyLines(String content) {
        String match;
        Matcher matcher = this._missingEmptyLinePattern1.matcher(content);
        while (matcher.find()) {
            int openParenthesesCount;
            match = matcher.group();
            int closeParenthesesCount = StringUtil.count(match, ")");
            if (closeParenthesesCount != (openParenthesesCount = StringUtil.count(match, "("))) continue;
            content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = this._missingEmptyLinePattern2.matcher(content);
        while (matcher.find()) {
            match = matcher.group();
            if (!match.contains("(")) continue;
            String whitespace = matcher.group(1);
            int x = content.indexOf(whitespace + "}" + "\n", matcher.end());
            int y = content.indexOf(whitespace + "}" + "\n\n", matcher.end());
            if (x == -1 || x == y) continue;
            content = StringUtil.replaceFirst(content, "\n", "\n\n", x + 1);
        }
        return content;
    }

    protected String fixRedundantEmptyLines(String content) {
        Matcher matcher = this._redundantEmptyLines1.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "", matcher.start());
        }
        matcher = this._redundantEmptyLines2.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "", matcher.end() - 1);
        }
        return content;
    }

    protected String fixSystemExceptions(String content) {
        if (!content.contains("SystemException")) {
            return content;
        }
        Matcher matcher = this._throwsSystemExceptionPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String replacement = null;
        String afterException = matcher.group(3);
        String beforeException = matcher.group(2);
        if (Validator.isNull(beforeException) && Validator.isNull(afterException)) {
            replacement = matcher.group(4);
            String beforeThrows = matcher.group(1);
            if (Validator.isNotNull(StringUtil.trim(beforeThrows))) {
                replacement = beforeThrows + replacement;
            }
        } else {
            replacement = Validator.isNull(beforeException) ? StringUtil.replaceFirst(match, "SystemException, ", "") : StringUtil.replaceFirst(match, ", SystemException", "");
        }
        if (match.equals(replacement)) {
            return content;
        }
        return this.fixSystemExceptions(StringUtil.replaceFirst(content, match, replacement));
    }

    protected String formatAnnotations(String fileName, String javaTermName, String content, String indent) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));
        String line = null;
        String annotation = "";
        String previousAnnotation = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.equals(indent + "}")) {
                return content;
            }
            if (StringUtil.count(line, "\t") == indent.length() && !line.startsWith(indent + ")")) {
                if (Validator.isNotNull(annotation) && annotation.contains("(")) {
                    int openParenthesesCount;
                    String match;
                    int closeParenthesesCount;
                    Matcher matcher = _annotationPattern.matcher(annotation);
                    if (matcher.find() && (closeParenthesesCount = StringUtil.count(match = matcher.group(), ")")) == (openParenthesesCount = StringUtil.count(match, "(")) && !match.endsWith("\n)\n") && !match.endsWith("\t)\n")) {
                        String tabs = matcher.group(1);
                        String replacement = StringUtil.replaceLast(match, ")", "\n" + tabs + ")");
                        return StringUtil.replace(content, match, replacement);
                    }
                    String newContent = JavaSourceProcessor.checkAnnotationParameterProperties(content, annotation);
                    if (newContent != null) {
                        return this.formatAnnotations(fileName, javaTermName, newContent, indent);
                    }
                    this.checkAnnotationParameters(fileName, javaTermName, annotation);
                }
                if (Validator.isNotNull(previousAnnotation) && previousAnnotation.compareToIgnoreCase(annotation) > 0) {
                    content = StringUtil.replaceFirst(content, previousAnnotation, annotation);
                    content = StringUtil.replaceLast(content, annotation, previousAnnotation);
                    return this.formatAnnotations(fileName, javaTermName, content, indent);
                }
                if (line.startsWith(indent + "@")) {
                    if (Validator.isNotNull(annotation)) {
                        previousAnnotation = annotation;
                    }
                    annotation = line + "\n";
                    continue;
                }
                annotation = "";
                previousAnnotation = "";
                continue;
            }
            if (Validator.isNull(annotation)) {
                return content;
            }
            annotation = annotation + line + "\n";
        }
        return content;
    }

    protected String formatClassLine(String content) {
        Matcher matcher = this._classPattern.matcher(content);
        while (matcher.find()) {
            String firstTrailingNonWhitespace = matcher.group(9);
            String match = matcher.group(1);
            String trailingWhitespace = matcher.group(8);
            if (!trailingWhitespace.contains("\n") && !firstTrailingNonWhitespace.equals("}")) {
                return StringUtil.replace(content, match, match + "\n");
            }
            String formattedClassLine = this.getFormattedClassLine(matcher.group(2), match);
            if (formattedClassLine == null) continue;
            content = StringUtil.replace(content, match, formattedClassLine);
        }
        return content;
    }

    protected String formatDuplicateReferenceMethods(String fileName, String content, String className, String packagePath) throws Exception {
        String moduleSuperClassContent = this.getModuleSuperClassContent(content, className, packagePath);
        if (Validator.isNull(moduleSuperClassContent) || !moduleSuperClassContent.contains("@Component") || !moduleSuperClassContent.contains("@Reference")) {
            this.setBNDInheritRequiredValue(fileName, false);
            return content;
        }
        boolean bndInheritRequired = false;
        Matcher matcher = this._referenceMethodPattern.matcher(moduleSuperClassContent);
        while (matcher.find()) {
            String referenceMethod = matcher.group();
            int pos = content.indexOf(referenceMethod);
            if (pos != -1) {
                String variableName;
                String referenceMethodContent = matcher.group(6);
                Matcher referenceMethodContentMatcher = this._referenceMethodContentPattern.matcher(referenceMethodContent);
                if (referenceMethodContentMatcher.find() && StringUtil.count(content, variableName = referenceMethodContentMatcher.group(1)) > 1) continue;
                int x = content.lastIndexOf("\n\n", pos);
                int y = pos + referenceMethod.length();
                String entireMethod = content.substring(x + 1, y);
                content = StringUtil.replace(content, entireMethod, "");
                bndInheritRequired = true;
                continue;
            }
            String referenceMethodModifierAndName = matcher.group(2);
            Pattern duplicateReferenceMethodPattern = Pattern.compile(referenceMethodModifierAndName + "\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)" + "\\s*?\n\t\\}\n");
            Matcher duplicateReferenceMethodMatcher = duplicateReferenceMethodPattern.matcher(content);
            if (!duplicateReferenceMethodMatcher.find()) {
                bndInheritRequired = true;
                continue;
            }
            String methodContent = duplicateReferenceMethodMatcher.group(2);
            String referenceMethodName = matcher.group(4);
            if (!methodContent.startsWith("super." + referenceMethodName)) continue;
            int x = content.lastIndexOf("\n\n", duplicateReferenceMethodMatcher.start());
            int y = duplicateReferenceMethodMatcher.end();
            String entireMethod = content.substring(x + 1, y);
            content = StringUtil.replace(content, entireMethod, "");
            bndInheritRequired = true;
        }
        this.setBNDInheritRequiredValue(fileName, bndInheritRequired);
        return content;
    }

    protected String formatExceptions(String content, File file, String packagePath, String fileName) throws IOException {
        List<String> importedExceptionClassNames = null;
        JavaDocBuilder javaDocBuilder = null;
        Matcher matcher = this._catchExceptionPattern.matcher(content);
        int skipVariableNameCheckEndPos = -1;
        block0: while (matcher.find()) {
            String packageName;
            Matcher exceptionVariableMatcher;
            String exceptionClassName = matcher.group(2);
            String exceptionVariableName = matcher.group(3);
            String tabs = matcher.group(1);
            String expectedExceptionVariableName = "e";
            if (!exceptionClassName.contains(" |")) {
                Matcher lowerCaseNumberOrPeriodMatcher = this._lowerCaseNumberOrPeriodPattern.matcher(exceptionClassName);
                expectedExceptionVariableName = StringUtil.toLowerCase(lowerCaseNumberOrPeriodMatcher.replaceAll(""));
            }
            Pattern exceptionVariablePattern = Pattern.compile("(\\W)" + exceptionVariableName + "(\\W)");
            int pos = content.indexOf("\n" + tabs + "}", matcher.end() - 1);
            String insideCatchCode = content.substring(matcher.end(), pos + 1);
            if (insideCatchCode.contains("catch (" + exceptionClassName)) {
                skipVariableNameCheckEndPos = pos;
            }
            if (skipVariableNameCheckEndPos < matcher.start() && !expectedExceptionVariableName.equals(exceptionVariableName)) {
                String catchExceptionCodeBlock = content.substring(matcher.start(), pos + 1);
                Matcher exceptionVariableMatcher2 = exceptionVariablePattern.matcher(catchExceptionCodeBlock);
                String catchExceptionReplacement = exceptionVariableMatcher2.replaceAll("$1" + expectedExceptionVariableName + "$2");
                return StringUtil.replaceFirst(content, catchExceptionCodeBlock, catchExceptionReplacement, matcher.start() - 1);
            }
            if (!this._checkUnprocessedExceptions || fileName.contains("/test/") || fileName.contains("/testIntegration/") || (exceptionVariableMatcher = exceptionVariablePattern.matcher(insideCatchCode)).find()) continue;
            if (javaDocBuilder == null) {
                javaDocBuilder = new JavaDocBuilder();
                javaDocBuilder.addSource(file);
            }
            if (importedExceptionClassNames == null) {
                importedExceptionClassNames = this.getImportedExceptionClassNames(javaDocBuilder);
            }
            String originalExceptionClassName = exceptionClassName;
            if (!exceptionClassName.contains(".")) {
                for (String exceptionClass : importedExceptionClassNames) {
                    if (!exceptionClass.endsWith("." + exceptionClassName)) continue;
                    exceptionClassName = exceptionClass;
                    break;
                }
            }
            if (!exceptionClassName.contains(".")) {
                exceptionClassName = packagePath + "." + exceptionClassName;
            }
            JavaClass exceptionClass = javaDocBuilder.getClassByName(exceptionClassName);
            while ((packageName = exceptionClass.getPackageName()).contains("com.liferay")) {
                exceptionClassName = exceptionClass.getName();
                if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                    int lineCount = this.getLineCount(content, matcher.start(2));
                    this.processErrorMessage(fileName, "Unprocessed " + originalExceptionClassName + ": " + fileName + " " + lineCount);
                    continue block0;
                }
                JavaClass exceptionSuperClass = exceptionClass.getSuperJavaClass();
                if (exceptionSuperClass == null) continue block0;
                exceptionClass = exceptionSuperClass;
            }
        }
        return content;
    }

    protected String formatIfClause(String ifClause) throws IOException {
        String strippedQuotesIfClause = JavaSourceProcessor.stripQuotes(ifClause, '\"');
        if (strippedQuotesIfClause.contains("!(") || strippedQuotesIfClause.contains("//")) {
            return ifClause;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(ifClause));
        String line = null;
        String previousLine = null;
        int previousLineLength = 0;
        int previousLineCloseParenthesesCount = 0;
        int previousLineLeadingWhitespace = 0;
        int previousLineOpenParenthesesCount = 0;
        int baseLeadingWhitespace = 0;
        int insideMethodCallExpectedWhitespace = 0;
        int level = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int expectedLeadingWhitespace;
            String originalLine = line;
            String trimmedLine = StringUtil.trimLeading(line);
            int x = this.getIncorrectLineBreakPos(line, previousLine);
            if (x != -1) {
                String leadingWhitespace = line.substring(0, line.indexOf(trimmedLine));
                return StringUtil.replace(ifClause, line, line.substring(0, x) + "\n" + leadingWhitespace + line.substring(x + 1));
            }
            line = StringUtil.replace(line, "\t", "    ");
            String strippedQuotesLine = JavaSourceProcessor.stripQuotes(trimmedLine, '\"');
            strippedQuotesLine = JavaSourceProcessor.stripQuotes(strippedQuotesLine, '\'');
            int closeParenthesesCount = StringUtil.count(strippedQuotesLine, ")");
            int openParenthesesCount = StringUtil.count(strippedQuotesLine, "(");
            if (previousLineLength > 0 && (line.endsWith("|") || line.endsWith("&&") || line.endsWith(") {")) && (previousLine.endsWith("|") || previousLine.endsWith("&&")) && previousLineLength + trimmedLine.length() < 80 && openParenthesesCount <= closeParenthesesCount && previousLineCloseParenthesesCount <= previousLineOpenParenthesesCount) {
                return StringUtil.replace(ifClause, previousLine + "\n" + originalLine, previousLine + " " + trimmedLine);
            }
            int leadingWhitespace = line.length() - trimmedLine.length();
            if (Validator.isNull(previousLine)) {
                baseLeadingWhitespace = line.indexOf(40) + 1;
            } else if (previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^")) {
                expectedLeadingWhitespace = baseLeadingWhitespace + level;
                if (leadingWhitespace != expectedLeadingWhitespace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhitespace - expectedLeadingWhitespace);
                }
            } else {
                expectedLeadingWhitespace = 0;
                if (previousLine.contains("\telse if (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 3;
                } else if (previousLine.contains("\tif (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 4;
                } else if (previousLine.contains("\twhile (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 5;
                }
                if (previousLine.endsWith(",") && insideMethodCallExpectedWhitespace > 0) {
                    if (previousLineCloseParenthesesCount > previousLineOpenParenthesesCount) {
                        insideMethodCallExpectedWhitespace -= 4;
                    }
                    expectedLeadingWhitespace = insideMethodCallExpectedWhitespace;
                } else {
                    if (expectedLeadingWhitespace == 0) {
                        expectedLeadingWhitespace = previousLineLeadingWhitespace + 4;
                    }
                    if (previousLine.endsWith("(")) {
                        insideMethodCallExpectedWhitespace = expectedLeadingWhitespace;
                    }
                }
                if (leadingWhitespace != expectedLeadingWhitespace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhitespace - expectedLeadingWhitespace);
                }
            }
            if (line.endsWith(") {")) {
                return ifClause;
            }
            level = level + openParenthesesCount - closeParenthesesCount;
            previousLine = originalLine;
            previousLineLength = line.length();
            previousLineCloseParenthesesCount = closeParenthesesCount;
            previousLineLeadingWhitespace = leadingWhitespace;
            previousLineOpenParenthesesCount = openParenthesesCount;
        }
        return ifClause;
    }

    protected String formatIfClause(String ifClause, String fileName, int lineCount) throws IOException {
        String ifClauseSingleLine = StringUtil.replace(ifClause, new String[]{"\t ", "\t", "(\n", "\n"}, new String[]{"\t", "", "(", " "});
        this.checkIfClauseParentheses(ifClauseSingleLine, fileName, lineCount);
        return this.formatIfClause(ifClause);
    }

    protected String formatJava(String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            String ifClause = "";
            String packageName = "";
            String regexPattern = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String indent;
                String trimmedLine;
                ++lineCount;
                if (line.startsWith("package ")) {
                    packageName = line.substring(8, line.length() - 1);
                }
                if (line.startsWith("import ")) {
                    String importPackageName;
                    int pos;
                    if (line.endsWith(".*;")) {
                        this.processErrorMessage(fileName, "import: " + fileName + " " + lineCount);
                    }
                    if ((pos = line.lastIndexOf(46)) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
                }
                if (!(trimmedLine = StringUtil.trimLeading(line)).startsWith("//") && !trimmedLine.startsWith("*")) {
                    if (!(!line.contains("\t ") || previousLine.endsWith("&&") || previousLine.endsWith("|") || previousLine.contains("\t((") || previousLine.contains("\t<") || previousLine.contains("\t ") || previousLine.contains("\tfor (") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                        line = StringUtil.replace(line, "\t ", "\t");
                    }
                    line = this.formatIncorrectSyntax(line, ",}", "}", false);
                    line = this.formatWhitespace(line, trimmedLine, true);
                }
                if (line.contains("\tfor (") && line.contains(":") && !line.contains(" :")) {
                    line = StringUtil.replace(line, ":", " :");
                }
                if (line.contains("PortalUtil.getClassNameId(") && fileName.endsWith("ServiceImpl.java")) {
                    this.processErrorMessage(fileName, "Use classNameLocalService.getClassNameId: " + fileName + " " + lineCount);
                }
                if (!JavaSourceProcessor.isExcludedPath(this._hibernateSQLQueryExcludes, absolutePath) && line.contains("= session.createSQLQuery(") && content.contains("com.liferay.portal.kernel.dao.orm.Session")) {
                    line = StringUtil.replace(line, "createSQLQuery", "createSynchronizedSQLQuery");
                }
                line = this.replacePrimitiveWrapperInstantiation(line);
                if (trimmedLine.startsWith("throw new IOException(") && line.contains("e.getMessage()")) {
                    line = StringUtil.replace(line, ".getMessage()", "");
                }
                if (trimmedLine.contains("StopWatch stopWatch = null;")) {
                    this.processErrorMessage(fileName, "Do not set stopwatch to null: " + fileName + " " + lineCount);
                }
                this.checkChaining(trimmedLine, fileName, lineCount);
                this.checkStringBundler(trimmedLine, fileName, lineCount);
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                line = this.formatEmptyArray(line);
                this.checkResourceUtil(line, fileName, lineCount);
                if (trimmedLine.startsWith("* @deprecated") && this._addMissingDeprecationReleaseVersion) {
                    if (!trimmedLine.startsWith("* @deprecated As of ")) {
                        line = StringUtil.replace(line, "* @deprecated", "* @deprecated As of " + this.getMainReleaseVersion());
                    } else {
                        String version = trimmedLine.substring(20);
                        version = StringUtil.split(version, " ")[0];
                        if (StringUtil.count(version = StringUtil.replace(version, ",", ""), ".") == 1) {
                            line = StringUtil.replaceFirst(line, version, version + ".0");
                        }
                    }
                }
                if (trimmedLine.startsWith("* @see ") && StringUtil.count(trimmedLine, "@") > 1) {
                    this.processErrorMessage(fileName, "Do not use @see with another annotation: " + fileName + " " + lineCount);
                }
                this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount);
                if (trimmedLine.startsWith("=")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.startsWith("},") && !trimmedLine.equals("},")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (line.contains("ActionForm form")) {
                    this.processErrorMessage(fileName, "Rename form to actionForm: " + fileName + " " + lineCount);
                }
                if (line.contains("ActionMapping mapping")) {
                    this.processErrorMessage(fileName, "Rename mapping to ActionMapping: " + fileName + " " + lineCount);
                }
                if (fileName.contains("/upgrade/") && line.contains("rs.getDate(")) {
                    this.processErrorMessage(fileName, "Use rs.getTimeStamp: " + fileName + " " + lineCount);
                }
                if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                    line = StringUtil.replaceLast(line, "{", " {");
                }
                line = this.sortExceptions(line);
                if (trimmedLine.startsWith("Pattern ") || Validator.isNotNull(regexPattern)) {
                    regexPattern = regexPattern + trimmedLine;
                    if (trimmedLine.endsWith(");")) {
                        this.checkRegexPattern(regexPattern, fileName, lineCount);
                        regexPattern = "";
                    }
                }
                int lineLeadingTabCount = JavaSourceProcessor.getLeadingTabCount(line);
                int previousLineLeadingTabCount = JavaSourceProcessor.getLeadingTabCount(previousLine);
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*")) {
                    int y;
                    int x;
                    int openParenthesisCount;
                    int closeParenthesisCount;
                    int openCurlyBraceCount;
                    int closeCurlyBraceCount;
                    int closeParenthesisCount2;
                    String strippedQuotesLine = JavaSourceProcessor.stripQuotes(trimmedLine, '\"');
                    strippedQuotesLine = JavaSourceProcessor.stripQuotes(strippedQuotesLine, '\'');
                    if (line.endsWith("(")) {
                        int pos;
                        if (line.contains(" && ") || line.contains(" || ")) {
                            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                        if ((pos = strippedQuotesLine.indexOf(" + ")) != -1) {
                            String linePart = strippedQuotesLine.substring(0, pos);
                            int closeBracketCount = StringUtil.count(linePart, "]");
                            closeParenthesisCount2 = StringUtil.count(linePart, ")");
                            int openBracketCount = StringUtil.count(linePart, "[");
                            int openParenthesisCount2 = StringUtil.count(linePart, "(");
                            if (openBracketCount == closeBracketCount && openParenthesisCount2 == closeParenthesisCount2) {
                                this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                        }
                    }
                    indent = "";
                    if (!trimmedLine.startsWith("}") && strippedQuotesLine.contains("}") && (closeCurlyBraceCount = StringUtil.count(strippedQuotesLine, "}")) > (openCurlyBraceCount = StringUtil.count(strippedQuotesLine, "{")) && lineLeadingTabCount > 0) {
                        for (int i = 0; i < lineLeadingTabCount - 1; ++i) {
                            indent = indent + "\t";
                        }
                        int x2 = line.lastIndexOf(125);
                        String openBracketCount = StringUtil.replace(content, "\n" + line + "\n", "\n" + line.substring(0, x2) + "\n" + indent + line.substring(x2) + "\n");
                        return openBracketCount;
                    }
                    if (!(!Validator.isNull(ifClause) || previousLine.endsWith(")") || previousLine.endsWith(") {") || previousLine.endsWith(") +") || previousLine.contains("\tthrows ") || previousLine.contains(" throws ") || previousLineLeadingTabCount != lineLeadingTabCount - 1)) {
                        int x3 = -1;
                        while ((x3 = previousLine.indexOf(", ", x3 + 1)) != -1) {
                            if (ToolsUtil.isInsideQuotes(previousLine, x3)) continue;
                            String linePart = previousLine.substring(0, x3);
                            linePart = BaseSourceProcessor.stripQuotes(linePart, '\"');
                            int closeParenthesesCount = StringUtil.count(linePart, ")");
                            int greaterThanCount = StringUtil.count(linePart, ">");
                            int lessThanCount = StringUtil.count(linePart, "<");
                            int openParenthesesCount = StringUtil.count(linePart, "(");
                            if (closeParenthesesCount != openParenthesesCount || greaterThanCount != lessThanCount) continue;
                            if (Validator.isNull(indent)) {
                                for (int i = 0; i < lineLeadingTabCount - 1; ++i) {
                                    indent = indent + "\t";
                                }
                            }
                            String string = StringUtil.replace(content, "\n" + previousLine + "\n", "\n" + previousLine.substring(0, x3 + 1) + "\n" + indent + previousLine.substring(x3 + 2) + "\n");
                            return string;
                        }
                    }
                    if (previousLine.endsWith("(") || previousLine.endsWith("+")) {
                        int x4 = -1;
                        while ((x4 = strippedQuotesLine.indexOf(", ", x4 + 1)) != -1) {
                            closeParenthesisCount = StringUtil.count(strippedQuotesLine.substring(0, x4), ")");
                            openParenthesisCount = StringUtil.count(strippedQuotesLine.substring(0, x4), "(");
                            if ((!previousLine.endsWith("(") || openParenthesisCount >= closeParenthesisCount) && (!previousLine.endsWith("+") || openParenthesisCount > closeParenthesisCount)) continue;
                            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                    }
                    if ((x = strippedQuotesLine.indexOf(", ")) != -1) {
                        int openParenthesisCount3;
                        String linePart = strippedQuotesLine.substring(0, x);
                        closeParenthesisCount2 = StringUtil.count(linePart, ")");
                        if (closeParenthesisCount2 > (openParenthesisCount3 = StringUtil.count(linePart, "("))) {
                            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                    } else if (trimmedLine.endsWith(",") && !trimmedLine.startsWith("for (") && (closeParenthesisCount = StringUtil.count(strippedQuotesLine, ")")) < (openParenthesisCount = StringUtil.count(strippedQuotesLine, "("))) {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if ((line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf(34)) == -1 || x < y)) {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (line.endsWith(" throws") || previousLine.endsWith("(") && line.contains(" throws ") && line.endsWith("{")) {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (trimmedLine.startsWith(".") || line.endsWith(".") && line.contains("=")) {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    if (trimmedLine.matches("^\\} (catch|else|finally) .*")) {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                }
                if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                    this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                }
                if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                    this.processErrorMessage(fileName, "{:" + fileName + " " + lineCount);
                }
                if (trimmedLine.startsWith("catch (") || trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (") || Validator.isNotNull(ifClause)) {
                    ifClause = ifClause + line + "\n";
                    if (line.endsWith(") {")) {
                        String newIfClause = this.formatIfClause(ifClause, fileName, lineCount);
                        if (!ifClause.equals(newIfClause) && content.contains(ifClause)) {
                            indent = StringUtil.replace(content, ifClause, newIfClause);
                            return indent;
                        }
                        ifClause = "";
                    } else if (line.endsWith(";")) {
                        ifClause = "";
                    }
                }
                int lineLength = this.getLineLength(line);
                if (!(line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                    if (lineLength > 80) {
                        if (!JavaSourceProcessor.isExcludedPath(this._lineLengthExcludes, absolutePath, lineCount) && !this.isAnnotationParameter(content, trimmedLine)) {
                            String truncateLongLinesContent = this.getTruncateLongLinesContent(content, line, trimmedLine, lineCount);
                            if (truncateLongLinesContent != null && !truncateLongLinesContent.equals(content)) {
                                String string = truncateLongLinesContent;
                                return string;
                            }
                            this.processErrorMessage(fileName, "> 80: " + fileName + " " + lineCount);
                        }
                    } else {
                        String combinedLinesContent;
                        if (!trimmedLine.startsWith("//")) {
                            int x;
                            if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
                                this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                            if (lineLeadingTabCount == previousLineLeadingTabCount && (previousLine.endsWith("=") || previousLine.endsWith("("))) {
                                this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                            if (Validator.isNotNull(trimmedLine) && previousLine.endsWith("{") && !trimmedLine.startsWith("}") && previousLineLeadingTabCount + 1 != lineLeadingTabCount) {
                                this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                            if (previousLine.endsWith(".") && (x = trimmedLine.indexOf(40)) != -1 && this.getLineLength(previousLine) + x < 80 && (trimmedLine.endsWith("(") || trimmedLine.charAt(x + 1) != ')')) {
                                this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                            int diff = lineLeadingTabCount - previousLineLeadingTabCount;
                            if (trimmedLine.startsWith("throws ") && (diff == 0 || diff > 1)) {
                                this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                            if (diff == 2 && previousLineLeadingTabCount > 0 && line.endsWith(";") && !previousLine.contains("\tfor (") && !previousLine.contains("\ttry (")) {
                                line = StringUtil.replaceFirst(line, "\t", "");
                            }
                        }
                        if ((combinedLinesContent = this.getCombinedLinesContent(content, fileName, absolutePath, line, trimmedLine, lineLength, lineCount, previousLine, lineLeadingTabCount, previousLineLeadingTabCount)) != null && !combinedLinesContent.equals(content)) {
                            String string = combinedLinesContent;
                            return string;
                        }
                    }
                }
                if (lineCount > 1) {
                    sb.append(previousLine);
                    if (Validator.isNotNull(previousLine) && Validator.isNotNull(trimmedLine) && !previousLine.contains("/*") && !previousLine.endsWith("*/")) {
                        String trimmedPreviousLine = StringUtil.trimLeading(previousLine);
                        trimmedLine = StringUtil.trimLeading(line);
                        if (trimmedPreviousLine.startsWith("// ") && !trimmedLine.startsWith("// ") || !trimmedPreviousLine.startsWith("// ") && trimmedLine.startsWith("// ")) {
                            sb.append("\n");
                        } else if (!trimmedPreviousLine.endsWith("{") && !trimmedPreviousLine.endsWith(":") && (trimmedLine.startsWith("for (") || trimmedLine.startsWith("if (") || trimmedLine.startsWith("try {"))) {
                            sb.append("\n");
                        } else if (!(!previousLine.endsWith("\t}") || trimmedLine.startsWith("}") || trimmedLine.startsWith(")") || trimmedLine.startsWith("//") || trimmedLine.equals("*/") || trimmedLine.startsWith("catch ") || trimmedLine.startsWith("else ") || trimmedLine.startsWith("finally ") || trimmedLine.startsWith("while "))) {
                            sb.append("\n");
                        }
                    }
                    sb.append("\n");
                }
                previousLine = line;
            }
            sb.append(previousLine);
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    protected String formatModulesFile(String fileName, String absolutePath, String className, String packagePath, String content) throws Exception {
        if (fileName.endsWith("Test.java")) {
            if (absolutePath.contains("/src/testIntegration/java/") || absolutePath.contains("/test/integration/")) {
                if (content.contains("@RunWith(Arquillian.class)") && content.contains("import org.powermock.")) {
                    this.processErrorMessage(fileName, "Do not use PowerMock inside Arquillian tests: " + fileName);
                }
                if (!packagePath.endsWith(".test")) {
                    this.processErrorMessage(fileName, "Module integration test must be under a test subpackage" + fileName);
                }
            } else if ((absolutePath.contains("/test/unit/") || absolutePath.contains("/src/test/java/")) && packagePath.endsWith(".test")) {
                this.processErrorMessage(fileName, "Module unit test should not be under a test subpackage" + fileName);
            }
        }
        if (content.contains("ProxyFactory.newServiceTrackedInstance(")) {
            this.processErrorMessage(fileName, "Do not use ProxyFactory.newServiceTrackedInstance in modules: " + fileName);
        }
        if (content.contains("@Component")) {
            content = this.formatOSGIComponents(fileName, absolutePath, content, className, packagePath);
        }
        if (!absolutePath.contains("/modules/core/") && !absolutePath.contains("/test/") && !absolutePath.contains("/testIntegration/") && content.contains("import com.liferay.registry.Registry")) {
            this.processErrorMessage(fileName, "Do not use Registry in modules: " + fileName);
        }
        if (!absolutePath.contains("/test/") && content.contains("@Meta.OCD") && !content.contains("@ExtendedObjectClassDefinition")) {
            this.processErrorMessage(fileName, "Specify category using @ExtendedObjectClassDefinition: " + fileName);
        }
        return content;
    }

    protected String formatOSGIComponents(String fileName, String absolutePath, String content, String className, String packagePath) throws Exception {
        String moduleServicePackagePath = null;
        Matcher matcher = this._serviceUtilImportPattern.matcher(content);
        while (matcher.find()) {
            String serviceUtilClassPackagePath;
            String serviceUtilClassName = matcher.group(2);
            if (moduleServicePackagePath == null) {
                moduleServicePackagePath = this.getModuleServicePackagePath(fileName);
            }
            if (Validator.isNotNull(moduleServicePackagePath) && (serviceUtilClassPackagePath = matcher.group(1)).startsWith(moduleServicePackagePath)) continue;
            this.processErrorMessage(fileName, "LPS-59076: Use @Reference instead of calling " + serviceUtilClassName + " directly: " + fileName);
        }
        matcher = this._referenceMethodPattern.matcher(content);
        while (matcher.find()) {
            String methodContent;
            Matcher referenceMethodContentMatcher;
            String methodName = matcher.group(4);
            if (!methodName.startsWith("set")) continue;
            String annotationParameters = matcher.group(1);
            if (!annotationParameters.contains("unbind =") && !content.contains("un" + methodName + "(")) {
                if (Validator.isNull(annotationParameters)) {
                    return StringUtil.insert(content, "(unbind = \"-\")", matcher.start(1));
                }
                if (!annotationParameters.contains("\n")) {
                    return StringUtil.insert(content, ", unbind = \"-\"", matcher.end(1) - 1);
                }
                if (!annotationParameters.contains("\n\n")) {
                    String indent = "\t\t";
                    int x = content.lastIndexOf("\n", matcher.end(1) - 1);
                    return StringUtil.replaceFirst(content, "\n", ",\n" + indent + "unbind = \"-\"" + "\n", x - 1);
                }
            }
            if (!(referenceMethodContentMatcher = this._referenceMethodContentPattern.matcher(methodContent = matcher.group(6))).find()) continue;
            String typeName = matcher.group(5);
            String variableName = referenceMethodContentMatcher.group(1);
            StringBundler sb = new StringBundler(5);
            sb.append("private volatile ");
            sb.append(typeName);
            sb.append("\\s+");
            sb.append(variableName);
            sb.append(";");
            Pattern privateVarPattern = Pattern.compile(sb.toString());
            Matcher privateVarMatcher = privateVarPattern.matcher(content);
            if (!privateVarMatcher.find()) continue;
            String match = privateVarMatcher.group();
            String replacement = StringUtil.replace(match, "private volatile ", "private ");
            return StringUtil.replace(content, match, replacement);
        }
        return this.formatDuplicateReferenceMethods(fileName, content, className, packagePath);
    }

    protected String getCombinedLinesContent(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String match;
            String tabs = matcher.group(1);
            int x = matcher.start(1);
            String openChar = matcher.group(matcher.groupCount());
            int y = -1;
            if (openChar.equals("{")) {
                y = content.indexOf("\n" + tabs + "}", x);
            } else if (openChar.equals("(")) {
                y = content.indexOf("\n" + tabs + ")", x);
            }
            y = content.indexOf(10, y + 1);
            if (y < x) {
                return content;
            }
            String replacement = match = content.substring(x, y);
            while (replacement.contains("\n\t")) {
                replacement = StringUtil.replace(replacement, "\n\t", "\n");
            }
            if (this.getLineLength(replacement = StringUtil.replace(replacement, new String[]{",\n", "\n"}, new String[]{", ", ""})) > 80) continue;
            return this.getCombinedLinesContent(StringUtil.replace(content, match, replacement), pattern);
        }
        return content;
    }

    protected String getCombinedLinesContent(String content, String fileName, String line, String trimmedLine, int lineLength, int lineCount, String previousLine, String linePart, int tabDiff, boolean addToPreviousLine, boolean extraSpace, int numNextLinesRemoveLeadingTab) {
        int previousLineStartPos = this.getLineStartPos(content, lineCount - 1);
        if (linePart == null) {
            String combinedLine = previousLine;
            if (extraSpace) {
                combinedLine = combinedLine + " ";
            }
            combinedLine = combinedLine + trimmedLine;
            String nextLine = this.getNextLine(content, lineCount);
            if (nextLine == null) {
                return null;
            }
            if (line.endsWith("{") && tabDiff != 0 && !previousLine.contains(" class ") && Validator.isNull(nextLine)) {
                return StringUtil.replaceFirst(content, previousLine + "\n" + line + "\n", combinedLine, previousLineStartPos);
            }
            if (numNextLinesRemoveLeadingTab > 0) {
                int nextLineStartPos = this.getLineStartPos(content, lineCount + 1);
                for (int i = 0; i < numNextLinesRemoveLeadingTab; ++i) {
                    content = StringUtil.replaceFirst(content, "\t", "", nextLineStartPos);
                    nextLineStartPos = content.indexOf(10, nextLineStartPos) + 1;
                }
            }
            return StringUtil.replaceFirst(content, previousLine + "\n" + line, combinedLine, previousLineStartPos);
        }
        String firstLine = previousLine;
        String secondLine = line;
        if (addToPreviousLine) {
            if (extraSpace) {
                firstLine = firstLine + " ";
            }
            firstLine = firstLine + linePart;
            secondLine = StringUtil.replaceFirst(line, linePart, "");
        } else if (linePart.length() + lineLength <= 80 && (line.endsWith("{") || line.endsWith(";"))) {
            firstLine = StringUtil.replaceLast(firstLine, StringUtil.trim(linePart), "");
            secondLine = extraSpace ? StringUtil.replaceLast(line, "\t", "\t" + linePart + " ") : StringUtil.replaceLast(line, "\t", "\t" + linePart);
        } else {
            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
            return null;
        }
        firstLine = StringUtil.trimTrailing(firstLine);
        return StringUtil.replaceFirst(content, previousLine + "\n" + line, firstLine + "\n" + secondLine, previousLineStartPos);
    }

    protected String getCombinedLinesContent(String content, String fileName, String absolutePath, String line, String trimmedLine, int lineLength, int lineCount, String previousLine, int lineTabCount, int previousLineTabCount) {
        String filePart;
        int pos;
        String nextLine;
        int nextLineTabCount;
        int closeParenthesisCount;
        int openParenthesisCount;
        if (Validator.isNull(line) || Validator.isNull(previousLine) || JavaSourceProcessor.isExcludedPath(this._fitOnSingleLineExcludes, absolutePath, lineCount)) {
            return null;
        }
        String trimmedPreviousLine = StringUtil.trimLeading(previousLine);
        if (line.contains("// ") || line.contains("*/") || line.contains("*/") || previousLine.contains("// ") || previousLine.contains("*/") || previousLine.contains("*/")) {
            return null;
        }
        int tabDiff = lineTabCount - previousLineTabCount;
        if (previousLine.endsWith("= new")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, "new", tabDiff, false, true, 0);
        }
        if (trimmedLine.startsWith("+ ") || trimmedLine.startsWith("- ") || trimmedLine.startsWith("|| ") || trimmedLine.startsWith("&& ")) {
            int pos2 = trimmedLine.indexOf(32);
            String linePart = trimmedLine.substring(0, pos2);
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart, tabDiff, true, true, 0);
        }
        if (previousLine.endsWith("<") && !previousLine.endsWith(" <")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, "<", tabDiff, false, false, 0);
        }
        int previousLineLength = this.getLineLength(previousLine);
        if (trimmedLine.length() + previousLineLength < 80) {
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
            }
            if (!(!line.endsWith(";") || previousLine.endsWith(":") || previousLine.endsWith("[") || previousLine.endsWith("{") || previousLine.endsWith("(") || previousLine.endsWith(".") || !previousLine.contains("[") && previousLine.contains("]") || lineTabCount != previousLineTabCount + 1)) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
            }
            if (trimmedLine.startsWith("throws") && (line.endsWith("{") || line.endsWith(";")) && lineTabCount == previousLineTabCount + 1) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
            }
            if (previousLine.endsWith("=")) {
                if (line.endsWith("{")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    return null;
                }
                if (previousLine.endsWith(" =") && line.endsWith("(")) {
                    int i = 0;
                    while (true) {
                        String nextLine2;
                        if (Validator.isNull(nextLine2 = this.getNextLine(content, lineCount + i)) || nextLine2.endsWith(") {")) {
                            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            return null;
                        }
                        if (nextLine2.endsWith(") +")) {
                            return null;
                        }
                        if (nextLine2.endsWith(";")) {
                            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, i + 1);
                        }
                        ++i;
                    }
                }
            }
        }
        if (trimmedLine.length() + previousLineLength <= 80 && (previousLine.endsWith("[") || previousLine.endsWith("(") || previousLine.endsWith(".")) && line.endsWith(";")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, false, 0);
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = trimmedLine;
            int pos3 = 0;
            while (true) {
                if ((pos3 = tempLine.indexOf(45)) == -1) {
                    pos3 = tempLine.indexOf(43);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf(47);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf(42);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("||");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("&&");
                }
                if (pos3 == -1) break;
                String linePart = tempLine.substring(0, pos3);
                openParenthesisCount = StringUtil.count(linePart, "(");
                if (openParenthesisCount == (closeParenthesisCount = StringUtil.count(linePart, ")"))) {
                    return null;
                }
                tempLine = tempLine.substring(0, pos3) + tempLine.substring(pos3 + 1);
            }
            int x = trimmedLine.indexOf(40);
            if (x == 0) {
                x = trimmedLine.indexOf(40, 1);
            }
            if (x != -1) {
                char previousChar;
                int y = trimmedLine.indexOf(41, x);
                int z = trimmedLine.indexOf(34);
                if (x + 1 != y && (z == -1 || z > x) && (previousChar = trimmedLine.charAt(x - 1)) != ')' && previousChar != '(' && previousChar != ' ' && previousLineLength + 1 + x < 80) {
                    String linePart = trimmedLine.substring(0, x + 1);
                    if (linePart.startsWith("(") && !linePart.contains(")")) {
                        return null;
                    }
                    return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart, tabDiff, true, true, 0);
                }
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !trimmedPreviousLine.equals("},") && (nextLineTabCount = JavaSourceProcessor.getLeadingTabCount(nextLine = this.getNextLine(content, lineCount))) != lineTabCount + 1) {
            int x = trimmedLine.indexOf(44);
            if (x != -1) {
                while (previousLineLength + 1 + x < 80) {
                    String linePart = trimmedLine.substring(0, x + 1);
                    if (this.isValidJavaParameter(linePart)) {
                        if (trimmedLine.equals(linePart)) {
                            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
                        }
                        return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart + " ", tabDiff, true, true, 0);
                    }
                    String partAfterComma = trimmedLine.substring(x + 1);
                    int pos4 = partAfterComma.indexOf(44);
                    if (pos4 != -1) {
                        x = x + pos4 + 1;
                        continue;
                    }
                    break;
                }
            } else if (trimmedLine.length() + previousLineLength < 80) {
                if (!trimmedLine.startsWith("new ") || !line.endsWith("{")) {
                    return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
                }
                openParenthesisCount = StringUtil.count(line, "(");
                if (openParenthesisCount != (closeParenthesisCount = StringUtil.count(line, ")"))) {
                    return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, true, 0);
                }
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        if (StringUtil.count(previousLine, "(") > 1 && (pos = trimmedPreviousLine.lastIndexOf(40, trimmedPreviousLine.length() - 2)) > 0 && Character.isLetterOrDigit(trimmedPreviousLine.charAt(pos - 1)) && !(filePart = trimmedPreviousLine.substring(pos + 1)).contains(")") && !filePart.contains("\"")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, filePart, tabDiff, false, false, 0);
        }
        if (trimmedLine.length() + previousLineLength > 80) {
            return null;
        }
        if (line.endsWith(",")) {
            String strippedQuotesLine = JavaSourceProcessor.stripQuotes(trimmedLine, '\"');
            int openParenthesisCount2 = StringUtil.count(strippedQuotesLine, "(");
            int closeParenthesisCount2 = StringUtil.count(strippedQuotesLine, ")");
            if (closeParenthesisCount2 > openParenthesisCount2) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, false, 0);
            }
        }
        if ((line.endsWith("{") && !trimmedLine.startsWith("new ") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, tabDiff, false, false, 0);
        }
        return null;
    }

    protected String getFormattedClassLine(String indent, String classLine) {
        ArrayList<String> lines;
        block15: {
            while (classLine.contains("\t ")) {
                classLine = StringUtil.replace(classLine, "\t ", "\t");
            }
            String classSingleLine = StringUtil.replace(classLine.substring(1), new String[]{"\t", "\n"}, new String[]{"", " "});
            classSingleLine = indent + classSingleLine;
            lines = new ArrayList<String>();
            if (this.getLineLength(classSingleLine) <= 80) {
                lines.add(classSingleLine);
            } else {
                int y;
                String newIndent = indent;
                String newLine = classSingleLine;
                int x = -1;
                while ((x = (y = newLine.indexOf(" extends ", x + 1)) == -1 ? newLine.indexOf(" implements ", x + 1) : y) != -1) {
                    String linePart = newLine.substring(0, x);
                    if (StringUtil.count(linePart, ">") != StringUtil.count(linePart, "<") || this.getLineLength(linePart) > 80) continue;
                    if (lines.isEmpty()) {
                        newIndent = newIndent + "\t";
                    }
                    lines.add(linePart);
                    newLine = newIndent + newLine.substring(x + 1);
                    if (this.getLineLength(newLine) <= 80) {
                        lines.add(newLine);
                        break block15;
                    }
                    x = -1;
                }
                if (lines.isEmpty()) {
                    return null;
                }
                x = newLine.length();
                while (true) {
                    if ((x = newLine.lastIndexOf(", ", x - 1)) == -1) {
                        return null;
                    }
                    String linePart = newLine.substring(0, x + 1);
                    if (StringUtil.count(linePart, ">") != StringUtil.count(linePart, "<") || this.getLineLength(linePart) > 80) continue;
                    lines.add(linePart);
                    if (linePart.contains("\textends")) {
                        newIndent = newIndent + "\t\t";
                    } else if (linePart.contains("\timplements")) {
                        newIndent = newIndent + "\t\t   ";
                    }
                    newLine = newIndent + newLine.substring(x + 2);
                    if (this.getLineLength(newLine) <= 80) {
                        lines.add(newLine);
                        break;
                    }
                    x = newLine.length();
                }
            }
        }
        String formattedClassLine = null;
        for (String line : lines) {
            if (formattedClassLine == null) {
                formattedClassLine = "\n" + line;
                continue;
            }
            formattedClassLine = formattedClassLine + "\n" + line;
        }
        return formattedClassLine;
    }

    protected int getIfClauseLineBreakPos(String line) {
        int y;
        int x = line.lastIndexOf(" || ", 77);
        int z = Math.max(x, y = line.lastIndexOf(" && ", 77));
        if (z != -1) {
            return z + 3;
        }
        if (!(line.endsWith(" ||") || line.endsWith(" &&") || line.endsWith(") {"))) {
            return -1;
        }
        x = line.indexOf("= ");
        if (x != -1) {
            return x + 1;
        }
        x = line.indexOf("> ");
        if (x != -1) {
            return x + 1;
        }
        x = line.indexOf("< ");
        if (x != -1) {
            return x + 1;
        }
        x = 81;
        while ((x = line.lastIndexOf(", ", x - 1)) != -1) {
            String linePart = line.substring(0, x);
            if (StringUtil.count(linePart, ")") != StringUtil.count(linePart, "(")) continue;
            return x + 1;
        }
        x = 0;
        while ((x = line.indexOf(40, x + 1)) != -1) {
            if (!Character.isLetterOrDigit(line.charAt(x - 1))) continue;
            return x + 1;
        }
        x = line.indexOf(46);
        if (x != -1) {
            return x + 1;
        }
        return -1;
    }

    protected List<String> getImportedExceptionClassNames(JavaDocBuilder javaDocBuilder) {
        ArrayList<String> exceptionClassNames = new ArrayList<String>();
        JavaSource javaSource = javaDocBuilder.getSources()[0];
        for (String importClassName : javaSource.getImports()) {
            if (!importClassName.endsWith("Exception") || exceptionClassNames.contains(importClassName)) continue;
            exceptionClassNames.add(importClassName);
        }
        return exceptionClassNames;
    }

    protected int getIncorrectLineBreakPos(String line, String previousLine) {
        int x = line.length();
        while (true) {
            int openParenthesesCount;
            String linePart1;
            int closeParenthesesCount;
            int z;
            int y;
            if ((x = Math.max(y = line.lastIndexOf(" || ", x - 1), z = line.lastIndexOf(" && ", x - 1))) == -1) {
                return x;
            }
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            if (Validator.isNotNull(previousLine) && (closeParenthesesCount = StringUtil.count(linePart1 = JavaSourceProcessor.stripQuotes(line.substring(0, x), '\"'), ")")) > (openParenthesesCount = StringUtil.count(linePart1, "("))) {
                return x + 3;
            }
            if (!line.endsWith(" ||") && !line.endsWith(" &&")) continue;
            String linePart2 = JavaSourceProcessor.stripQuotes(line.substring(x), '\"');
            closeParenthesesCount = StringUtil.count(linePart2, ")");
            openParenthesesCount = StringUtil.count(linePart2, "(");
            if (openParenthesesCount > closeParenthesesCount) break;
        }
        return x + 3;
    }

    protected int getLineStartPos(String content, int lineCount) {
        int x = 0;
        for (int i = 1; i < lineCount; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    protected String getModuleClassContent(String fullClassName) throws Exception {
        String classContent = this._moduleFileContentsMap.get(fullClassName);
        if (classContent != null) {
            return classContent;
        }
        Map<String, String> moduleFileNamesMap = this.getModuleFileNamesMap();
        String moduleFileName = moduleFileNamesMap.get(fullClassName);
        if (moduleFileName == null) {
            this._moduleFileContentsMap.put(fullClassName, "");
            return "";
        }
        File file = new File(moduleFileName);
        classContent = FileUtil.read(file);
        this._moduleFileContentsMap.put(fullClassName, classContent);
        return classContent;
    }

    protected Map<String, String> getModuleFileNamesMap() throws Exception {
        if (this._moduleFileNamesMap != null) {
            return this._moduleFileNamesMap;
        }
        this._moduleFileNamesMap = new HashMap<String, String>();
        List<Object> fileNames = new ArrayList();
        String moduleRootDirLocation = "modules/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(this.sourceFormatterArgs.getBaseDirName() + moduleRootDirLocation);
            if (file.exists()) {
                fileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName() + moduleRootDirLocation, null, new String[0], this.getIncludes());
                break;
            }
            moduleRootDirLocation = "../" + moduleRootDirLocation;
        }
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, "\\", "/");
            String className = StringUtil.replace(fileName, "/", ".");
            int pos = className.lastIndexOf(".com.liferay.");
            className = className.substring(pos + 1, fileName.length() - 5);
            this._moduleFileNamesMap.put(className, fileName);
        }
        return this._moduleFileNamesMap;
    }

    protected String getModuleServicePackagePath(String fileName) {
        int pos;
        String serviceDirLocation = fileName;
        while (true) {
            if ((pos = serviceDirLocation.lastIndexOf("/")) == -1) {
                return "";
            }
            File file = new File((serviceDirLocation = serviceDirLocation.substring(0, pos + 1)) + "service");
            if (file.exists()) break;
            file = new File(serviceDirLocation + "liferay");
            if (file.exists()) {
                return "";
            }
            serviceDirLocation = StringUtil.replaceLast(serviceDirLocation, "/", "");
        }
        serviceDirLocation = serviceDirLocation + "service";
        serviceDirLocation = StringUtil.replace(serviceDirLocation, "/", ".");
        pos = serviceDirLocation.lastIndexOf(".com.");
        return serviceDirLocation.substring(pos + 1);
    }

    protected String getModuleSuperClassContent(String content, String className, String packagePath) throws Exception {
        Pattern pattern = Pattern.compile(" class " + className + "\\s+extends\\s+([\\w.]+) ");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String superClassName = matcher.group(1);
        if (superClassName.contains(".")) {
            if (!superClassName.startsWith("com.liferay")) {
                return null;
            }
            return this.getModuleClassContent(superClassName);
        }
        String superClassPackagePath = packagePath;
        pattern = Pattern.compile("\nimport (.+?)\\." + superClassName + ";");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            superClassPackagePath = matcher.group(1);
        }
        if (!superClassPackagePath.startsWith("com.liferay")) {
            return null;
        }
        String superClassFullClassName = superClassPackagePath + "." + superClassName;
        return this.getModuleClassContent(superClassFullClassName);
    }

    protected String getNextLine(String content, int lineCount) {
        int nextLineStartPos = this.getLineStartPos(content, lineCount + 1);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    protected Collection<String> getPluginJavaFiles() throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/model/*Clp.java", "**/model/impl/*BaseImpl.java", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/service/**/service/*Service.java", "**/service/**/service/*ServiceClp.java", "**/service/**/service/*ServiceFactory.java", "**/service/**/service/*ServiceUtil.java", "**/service/**/service/*ServiceWrapper.java", "**/service/**/service/ClpSerializer.java", "**/service/**/service/messaging/*ClpMessageListener.java", "**/service/**/service/persistence/*Finder.java", "**/service/**/service/persistence/*Util.java", "**/service/base/*ServiceBaseImpl.java", "**/service/base/*ServiceClpInvoker.java", "**/service/http/*JSONSerializer.java", "**/service/http/*ServiceHttp.java", "**/service/http/*ServiceJSON.java", "**/service/http/*ServiceSoap.java", "**/tools/templates/**"};
        String[] includes = new String[]{"**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected Collection<String> getPortalJavaFiles() throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/*_IW.java", "**/PropsValues.java", "**/counter/service/**", "**/jsp/*", "**/model/impl/*BaseImpl.java", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/portal/service/**", "**/portal-client/**", "**/portal-web/test/**/*Test.java", "**/portlet/**/service/**", "**/test/*-generated/**", "**/source/formatter/**"};
        String[] includes = this.getIncludes();
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**/portal-client/**", "**/tools/ext_tmpl/**", "**/*_IW.java", "**/test/**/*PersistenceTest.java", "**/source/formatter/**"};
        includes = new String[]{"**/com/liferay/portal/kernel/service/ServiceContext*.java", "**/model/BaseModel.java", "**/model/impl/BaseModelImpl.java", "**/portal-test/**/portal/service/**/*.java", "**/portal-test-internal/**/portal/service/**/*.java", "**/service/Base*.java", "**/service/PersistedModelLocalService*.java", "**/service/http/*HttpTest.java", "**/service/http/*SoapTest.java", "**/service/http/TunnelUtil.java", "**/service/impl/*.java", "**/service/jms/*.java", "**/service/permission/*.java", "**/service/persistence/BasePersistence.java", "**/service/persistence/BatchSession*.java", "**/service/persistence/*FinderImpl.java", "**/service/persistence/*Query.java", "**/service/persistence/impl/*.java", "**/portal-impl/test/**/*.java", "**/util-bridges/**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected String getTruncateLongLinesContent(String content, String line, String trimmedLine, int lineCount) {
        String firstLine;
        String secondLine;
        String firstLine2;
        int x;
        int i;
        String indent = "";
        for (i = 0; i < JavaSourceProcessor.getLeadingTabCount(line); ++i) {
            indent = indent + "\t";
        }
        if ((line.endsWith("(") || line.endsWith(";")) && (x = line.indexOf(" = ")) != -1) {
            firstLine2 = line.substring(0, x + 2);
            if (firstLine2.contains("\"")) {
                return null;
            }
            secondLine = indent + "\t" + line.substring(x + 3);
            if (line.endsWith(";")) {
                return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
            }
            if (Validator.isNotNull(this.getNextLine(content, lineCount))) {
                return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n" + "\t");
            }
        }
        if (line.endsWith(")") || line.endsWith(",") || line.endsWith("{") || line.endsWith(";")) {
            x = 0;
            while ((x = line.indexOf(", ", x + 1)) != -1) {
                if (!this.isValidJavaParameter(line.substring(0, x))) continue;
                firstLine2 = line.substring(0, x + 1);
                secondLine = indent + line.substring(x + 2);
                return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
            }
        }
        if ((line.endsWith("{") || line.endsWith(";")) && (trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && (x = line.indexOf(" throws ")) != -1) {
            firstLine2 = line.substring(0, x);
            secondLine = indent + "\t" + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
        }
        if ((line.endsWith(")") || line.endsWith("{")) && (trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && (x = line.indexOf(40)) != -1 && line.charAt(x + 1) != ')') {
            String secondLineIndent = indent + "\t";
            if (line.endsWith(")")) {
                secondLineIndent = secondLineIndent + "\t";
            }
            firstLine = line.substring(0, x + 1);
            String secondLine2 = secondLineIndent + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine + "\n" + secondLine2 + "\n");
        }
        if (line.endsWith(";")) {
            x = line.indexOf(40);
            if (x != -1) {
                char c = line.charAt(x - 1);
                if (c != ' ' && c != '\t' && line.charAt(x + 1) != ')') {
                    firstLine = line.substring(0, x + 1);
                    if (firstLine.contains("\"")) {
                        return null;
                    }
                    String secondLine3 = indent + "\t" + line.substring(x + 1);
                    return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine + "\n" + secondLine3 + "\n");
                }
            } else {
                x = line.lastIndexOf(" ");
                if (x != -1) {
                    firstLine2 = line.substring(0, x);
                    secondLine = indent + "\t" + line.substring(x + 1);
                    if (this.getLineLength(secondLine) <= 80) {
                        return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
                    }
                }
            }
        }
        if (line.contains("\tfor (") && line.endsWith(" {") && (x = line.indexOf(" : ")) != -1) {
            firstLine2 = line.substring(0, x + 2);
            secondLine = indent + "\t" + "\t" + line.substring(x + 3);
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n\n");
        }
        i = this.getIfClauseLineBreakPos(line);
        if (i == -1) {
            return null;
        }
        firstLine2 = line.substring(0, i);
        secondLine = indent + line.substring(i);
        if (secondLine.endsWith(") {")) {
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n\n");
        }
        return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
    }

    protected boolean hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR")) && !content.contains("hasGeneratedTag");
    }

    protected boolean isAnnotationParameter(String content, String line) {
        Matcher matcher = _annotationPattern.matcher(content);
        while (matcher.find()) {
            String annotationParameters = matcher.group(3);
            if (!annotationParameters.contains(line)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidJavaParameter(String javaParameter) {
        if (javaParameter.contains(" implements ") || javaParameter.contains(" throws ")) {
            return false;
        }
        int quoteCount = StringUtil.count(javaParameter, "\"");
        if (quoteCount % 2 == 1) {
            return false;
        }
        javaParameter = JavaSourceProcessor.stripQuotes(javaParameter, '\"');
        int openParenthesisCount = StringUtil.count(javaParameter, "(");
        int closeParenthesisCount = StringUtil.count(javaParameter, ")");
        int lessThanCount = StringUtil.count(javaParameter, "<");
        int greaterThanCount = StringUtil.count(javaParameter, ">");
        int openCurlyBraceCount = StringUtil.count(javaParameter, "{");
        int closeCurlyBraceCount = StringUtil.count(javaParameter, "}");
        return openParenthesisCount == closeParenthesisCount && lessThanCount == greaterThanCount && openCurlyBraceCount == closeCurlyBraceCount;
    }

    @Override
    protected void postFormat() throws Exception {
        this.checkBndInheritAnnotationOption();
    }

    protected void setBNDInheritRequiredValue(String fileName, boolean bndInheritRequired) throws Exception {
        Tuple bndFileLocationAndContentTuple = this.getBNDFileLocationAndContentTuple(fileName);
        String bndFileLocation = (String)bndFileLocationAndContentTuple.getObject(0);
        Tuple bndInheritTuple = this._bndInheritRequiredTupleMap.get(bndFileLocation);
        if (bndInheritTuple == null || bndInheritRequired) {
            String bndContent = (String)bndFileLocationAndContentTuple.getObject(1);
            this._bndInheritRequiredTupleMap.put(bndFileLocation, new Tuple(bndContent, bndInheritRequired));
        }
    }

    protected String sortExceptions(String line) {
        String exception;
        if (!line.endsWith("{") && !line.endsWith(";")) {
            return line;
        }
        int x = line.indexOf("throws ");
        if (x == -1) {
            return line;
        }
        String previousException = "";
        String[] exceptions = StringUtil.split(line.substring(x), ' ');
        for (int i = 1; i < exceptions.length && !(exception = exceptions[i]).equals("{"); ++i) {
            if (exception.endsWith(",") || exception.endsWith(";")) {
                exception = exception.substring(0, exception.length() - 1);
            }
            if (Validator.isNotNull(previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                line = StringUtil.replace(line, previousException + ", " + exception, exception + ", " + previousException);
                return this.sortExceptions(line);
            }
            previousException = exception;
        }
        return line;
    }
}

