/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.JavaTerm;
import com.liferay.source.formatter.JavaTermComparator;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClass {
    private static final String _ACCESS_MODIFIER_PRIVATE = "private";
    private static final String _ACCESS_MODIFIER_PROTECTED = "protected";
    private static final String _ACCESS_MODIFIER_PUBLIC = "public";
    private static final String _ACCESS_MODIFIER_UNKNOWN = "unknown";
    private static final String[] _ACCESS_MODIFIERS = new String[]{"private", "protected", "public"};
    private final String _absolutePath;
    private final Pattern _camelCasePattern = Pattern.compile("([a-z])([A-Z0-9])");
    private String _classContent;
    private final Pattern _classPattern = Pattern.compile("(private|protected|public) ((abstract|static) )*(class|enum|interface) ([\\s\\S]*?) \\{\n");
    private int _constructorCount = 0;
    private final String _content;
    private final Pattern _enumTypePattern = Pattern.compile("\t[A-Z0-9]+[ _,;\\(\n]");
    private final File _file;
    private final String _fileName;
    private final String _indent;
    private final List<JavaClass> _innerClasses = new ArrayList<JavaClass>();
    private final JavaSourceProcessor _javaSourceProcessor;
    private final List<String> _javaTermAccessLevelModifierExcludes;
    private Set<JavaTerm> _javaTerms;
    private final int _lineCount;
    private final String _name;
    private final JavaClass _outerClass;
    private String _packagePath;

    public JavaClass(String name, String packagePath, File file, String fileName, String absolutePath, String content, String classContent, int lineCount, String indent, JavaClass outerClass, List<String> javaTermAccessLevelModifierExcludes, JavaSourceProcessor javaSourceProcessor) throws Exception {
        this._name = name;
        this._packagePath = packagePath;
        this._file = file;
        this._fileName = fileName;
        this._absolutePath = absolutePath;
        this._content = content;
        this._classContent = classContent;
        this._lineCount = lineCount;
        this._indent = indent;
        this._outerClass = outerClass;
        this._javaTermAccessLevelModifierExcludes = javaTermAccessLevelModifierExcludes;
        this._javaSourceProcessor = javaSourceProcessor;
        this._javaTerms = this.getJavaTerms();
    }

    public String formatJavaTerms(Set<String> annotationsExclusions, Set<String> immutableFieldTypes, List<String> checkJavaFieldTypesExcludes, List<String> javaTermSortExcludes, List<String> testAnnotationsExcludes) throws Exception {
        if (this._javaTerms == null) {
            if (!BaseSourceProcessor.isExcludedPath(this._javaTermAccessLevelModifierExcludes, this._absolutePath) && !BaseSourceProcessor.isExcludedPath(javaTermSortExcludes, this._absolutePath)) {
                this._javaSourceProcessor.processErrorMessage(this._fileName, "Parsing error while retrieving java terms " + this._fileName);
            }
            return this._classContent;
        }
        if (this._javaTerms.isEmpty()) {
            return this._classContent;
        }
        String originalContent = this._classContent;
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : this._javaTerms) {
            if (javaTerm.isConstructor()) {
                this.checkConstructor(javaTerm);
            }
            this.checkUnusedParameters(javaTerm);
            if (this._fileName.endsWith("LocalServiceImpl.java") && javaTerm.hasAnnotation("Indexable") && !javaTerm.hasReturnType()) {
                this._javaSourceProcessor.processErrorMessage(this._fileName, "Missing return type for method with @Indexable: " + this._fileName + " " + javaTerm.getLineCount());
            }
            if (!BaseSourceProcessor.isExcludedPath(checkJavaFieldTypesExcludes, this._absolutePath)) {
                this.checkJavaFieldType(javaTerm, annotationsExclusions, immutableFieldTypes);
            }
            if (!originalContent.equals(this._classContent)) {
                return this._classContent;
            }
            this.sortJavaTerms(previousJavaTerm, javaTerm, javaTermSortExcludes);
            this.fixTabsAndIncorrectEmptyLines(javaTerm);
            this.formatAnnotations(javaTerm, testAnnotationsExcludes);
            if (!originalContent.equals(this._classContent)) {
                return this._classContent;
            }
            previousJavaTerm = javaTerm;
        }
        for (JavaClass innerClass : this._innerClasses) {
            String newInnerClassContent;
            String innerClassContent = innerClass.getContent();
            if (innerClassContent.equals(newInnerClassContent = innerClass.formatJavaTerms(annotationsExclusions, immutableFieldTypes, checkJavaFieldTypesExcludes, javaTermSortExcludes, testAnnotationsExcludes))) continue;
            this._classContent = StringUtil.replace(this._classContent, innerClassContent, newInnerClassContent);
            return this._classContent;
        }
        this.fixJavaTermsDividers(this._javaTerms, javaTermSortExcludes);
        return this._classContent;
    }

    public String getClassName() {
        if (this._outerClass != null) {
            return this._outerClass.getClassName() + "$" + this._name;
        }
        return this._packagePath + "." + this._name;
    }

    public String getContent() {
        return this._classContent;
    }

    protected Set<JavaTerm> addStaticBlocks(Set<JavaTerm> javaTerms, List<JavaTerm> staticBlocks) {
        TreeSet<JavaTerm> newJavaTerms = new TreeSet<JavaTerm>(new JavaTermComparator());
        for (JavaTerm javaTerm : javaTerms) {
            if (!javaTerm.isStatic() || !javaTerm.isVariable()) {
                newJavaTerms.add(javaTerm);
                continue;
            }
            Iterator<JavaTerm> staticBlocksIterator = staticBlocks.iterator();
            while (staticBlocksIterator.hasNext()) {
                JavaTerm staticBlock = staticBlocksIterator.next();
                String staticBlockContent = staticBlock.getContent();
                if (!staticBlockContent.contains(javaTerm.getName())) continue;
                staticBlock.setType(javaTerm.getType() + 1);
                newJavaTerms.add(staticBlock);
                staticBlocksIterator.remove();
            }
            newJavaTerms.add(javaTerm);
        }
        if (!staticBlocks.isEmpty()) {
            newJavaTerms.addAll(staticBlocks);
        }
        return newJavaTerms;
    }

    protected void checkAnnotationForMethod(JavaTerm javaTerm, String annotation, String requiredMethodNameRegex, int requiredMethodType, String fileName) {
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        if (javaTerm.hasAnnotation(annotation)) {
            if (!matcher.find()) {
                this._javaSourceProcessor.processErrorMessage(fileName, "LPS-36303: Incorrect method name: " + methodName + " " + fileName);
            } else if (javaTerm.getType() != requiredMethodType) {
                this._javaSourceProcessor.processErrorMessage(fileName, "LPS-36303: Incorrect method type for " + methodName + " " + fileName);
            }
        } else if (matcher.find() && !javaTerm.hasAnnotation("Override")) {
            this._javaSourceProcessor.processErrorMessage(fileName, "Annotation @" + annotation + " required for " + methodName + " " + fileName);
        }
    }

    protected void checkConstructor(JavaTerm javaTerm) throws Exception {
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains("\tsuper();")) {
            String newJavaTermContent = StringUtil.replace(javaTermContent, "\tsuper();", "");
            this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
            return;
        }
        if (!ListUtil.isEmpty(javaTerm.getParameterTypes())) {
            this.checkConstructorParameterOrder(javaTerm);
            return;
        }
        if (this._packagePath == null || this._constructorCount > 1 || !javaTermContent.contains("{\n" + this._indent + "}\n")) {
            return;
        }
        String accessModifier = this.getAccessModifier();
        if (javaTerm.isPrivate() && !accessModifier.equals(_ACCESS_MODIFIER_PRIVATE) || javaTerm.isProtected() && !accessModifier.equals(_ACCESS_MODIFIER_PRIVATE) && !accessModifier.equals(_ACCESS_MODIFIER_PROTECTED)) {
            return;
        }
        Pattern pattern = Pattern.compile("class " + this._name + "[ \t\n]+extends");
        Matcher matcher = pattern.matcher(this._classContent);
        if (!matcher.find()) {
            return;
        }
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
        javaDocBuilder.addSource(this._file);
        com.thoughtworks.qdox.model.JavaClass javaClass = javaDocBuilder.getClassByName(this.getClassName());
        com.thoughtworks.qdox.model.JavaClass superJavaClass = javaClass.getSuperJavaClass();
        JavaMethod superJavaClassConstructor = superJavaClass.getMethodBySignature(superJavaClass.getName(), null);
        if (superJavaClassConstructor != null && ArrayUtil.isEmpty(superJavaClassConstructor.getExceptions())) {
            this._classContent = StringUtil.replace(this._classContent, javaTermContent, "");
        }
    }

    protected void checkConstructorParameterOrder(JavaTerm javaTerm) {
        int previousPos = -1;
        for (String parameterName : javaTerm.getParameterNames()) {
            String beforeParameter;
            Pattern pattern = Pattern.compile("\\{\n([\\s\\S]*?)(_" + parameterName + " =[ \t\n]+" + parameterName + ";)");
            Matcher matcher = pattern.matcher(javaTerm.getContent());
            if (!matcher.find() || (beforeParameter = matcher.group(1)).contains(parameterName + " =")) continue;
            int pos = matcher.start(2);
            if (previousPos > pos) {
                this._javaSourceProcessor.processErrorMessage(this._fileName, "Constructor parameter order " + parameterName + ": " + this._fileName);
                return;
            }
            previousPos = pos;
        }
    }

    protected void checkFinalableFieldType(JavaTerm javaTerm, Set<String> annotationsExclusions, String modifierDefinition) throws Exception {
        for (String annotation : annotationsExclusions) {
            if (!javaTerm.hasAnnotation(annotation)) continue;
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("(((\\+\\+( ?))|(--( ?)))");
        sb.append(javaTerm.getName());
        sb.append(")|((\\b|\\.)");
        sb.append(javaTerm.getName());
        sb.append("((( )((=)|(\\+=)|(-=)|(\\*=)|(/=)|(%=)))");
        sb.append("|(\\+\\+)|(--)|(( )((\\|=)|(&=)|(^=)))))");
        Pattern pattern = Pattern.compile(sb.toString());
        if (!this.isFinalableField(javaTerm, this._name, pattern, true)) {
            return;
        }
        String javaTermContent = javaTerm.getContent();
        String newJavaTermContent = StringUtil.replaceFirst(javaTermContent, modifierDefinition, modifierDefinition + " final");
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    protected void checkImmutableFieldType(String javaTermName) {
        if (javaTermName.equals("serialVersionUID")) {
            return;
        }
        Matcher matcher = this._camelCasePattern.matcher(javaTermName);
        String newName = matcher.replaceAll("$1_$2");
        newName = StringUtil.toUpperCase(newName);
        this._classContent = this._classContent.replaceAll("(?<=[\\W&&[^.\"]])(" + javaTermName + ")\\b", newName);
    }

    protected void checkJavaFieldType(JavaTerm javaTerm, Set<String> annotationsExclusions, Set<String> immutableFieldTypes) throws Exception {
        String javaTermContent;
        if (!BaseSourceProcessor.portalSource || !javaTerm.isVariable()) {
            return;
        }
        String javaTermName = javaTerm.getName();
        Pattern pattern = Pattern.compile("\t(private |protected |public )(((final|static|transient)( |\n))*)([\\s\\S]*?)" + javaTermName);
        Matcher matcher = pattern.matcher(javaTermContent = javaTerm.getContent());
        if (!matcher.find()) {
            return;
        }
        if ((javaTerm.isPrivate() && !javaTermName.equals("serialVersionUID")) ^ javaTermName.charAt(0) == '_') {
            if (javaTerm.isPrivate()) {
                this._classContent = this._classContent.replaceAll("(?<=[\\W&&[^.\"]])(" + javaTermName + ")\\b", "_".concat(javaTermName));
            } else {
                this._javaSourceProcessor.processErrorMessage(this._fileName, "Only private var should start with underscore: " + this._fileName + " " + javaTerm.getLineCount());
            }
        }
        String modifierDefinition = StringUtil.trim(javaTermContent.substring(matcher.start(1), matcher.start(6)));
        boolean isFinal = modifierDefinition.contains("final");
        boolean isStatic = modifierDefinition.contains("static");
        String javaFieldType = StringUtil.trim(matcher.group(6));
        if (isFinal && isStatic && javaFieldType.startsWith("Map<")) {
            this.checkMutableFieldType(javaTerm.getName());
        }
        if (!javaTerm.isPrivate()) {
            return;
        }
        if (isFinal) {
            if (immutableFieldTypes.contains(javaFieldType)) {
                if (isStatic) {
                    this.checkImmutableFieldType(javaTerm.getName());
                } else {
                    this.checkStaticableFieldType(javaTerm.getContent());
                }
            }
        } else {
            this.checkFinalableFieldType(javaTerm, annotationsExclusions, modifierDefinition);
        }
    }

    protected void checkMutableFieldType(String javaTermName) {
        if (!StringUtil.isUpperCase(javaTermName)) {
            return;
        }
        StringBuilder sb = new StringBuilder(javaTermName.length());
        for (int i = 0; i < javaTermName.length(); ++i) {
            char c = javaTermName.charAt(i);
            if (i > 1) {
                if (c == '_') continue;
                if (javaTermName.charAt(i - 1) == '_') {
                    sb.append(c);
                    continue;
                }
            }
            sb.append(Character.toLowerCase(c));
        }
        String newName = sb.toString();
        if (!newName.equals(javaTermName)) {
            this._classContent = this._classContent.replaceAll("(?<=[\\W&&[^.\"]])(" + javaTermName + ")\\b", newName);
        }
    }

    protected void checkStaticableFieldType(String javaTermContent) {
        if (!javaTermContent.contains("=")) {
            return;
        }
        String newJavaTermContent = StringUtil.replaceFirst(javaTermContent, "private final", "private static final");
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    protected void checkTestAnnotations(JavaTerm javaTerm) {
        int methodType = javaTerm.getType();
        if (methodType != 5 && methodType != 3) {
            return;
        }
        this.checkAnnotationForMethod(javaTerm, "After", "^.*tearDown\\z", 5, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "AfterClass", "^.*tearDownClass\\z", 3, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "Before", "^.*setUp\\z", 5, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "BeforeClass", "^.*setUpClass\\z", 3, this._fileName);
        this.checkAnnotationForMethod(javaTerm, "Test", "^.*test", 5, this._fileName);
    }

    protected void checkUnusedParameters(JavaTerm javaTerm) {
        if (!javaTerm.isPrivate() || !javaTerm.isMethod()) {
            return;
        }
        for (String parameterName : javaTerm.getParameterNames()) {
            if (StringUtil.count(javaTerm.getContent(), parameterName) != 1) continue;
            this._javaSourceProcessor.processErrorMessage(this._fileName, "Unused parameter " + parameterName + ": " + this._fileName + " " + javaTerm.getLineCount());
        }
    }

    protected void fixJavaTermsDividers(Set<JavaTerm> javaTerms, List<String> javaTermSortExcludes) {
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermContent = javaTerm.getContent();
            if (javaTermContent.startsWith(this._indent + "//")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermContent = previousJavaTerm.getContent();
            if (previousJavaTermContent.startsWith(this._indent + "//")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermName = javaTerm.getName();
            if (BaseSourceProcessor.isExcludedPath(javaTermSortExcludes, this._absolutePath, javaTerm.getLineCount(), javaTermName)) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermName = previousJavaTerm.getName();
            boolean requiresEmptyLine = false;
            if (previousJavaTerm.getType() != javaTerm.getType()) {
                requiresEmptyLine = true;
            } else if (!javaTerm.isVariable()) {
                requiresEmptyLine = true;
            } else if (StringUtil.isUpperCase(javaTermName) && !StringUtil.isLowerCase(javaTermName) || StringUtil.isUpperCase(previousJavaTermName) && !StringUtil.isLowerCase(previousJavaTermName)) {
                requiresEmptyLine = true;
            } else if (this.hasAnnotationCommentOrJavadoc(javaTermContent) || this.hasAnnotationCommentOrJavadoc(previousJavaTermContent)) {
                requiresEmptyLine = true;
            } else if (previousJavaTerm.getType() == 20 && (previousJavaTermName.equals("_instance") || previousJavaTermName.equals("_log") || previousJavaTermName.equals("_logger"))) {
                requiresEmptyLine = true;
            } else if (previousJavaTermContent.contains("\n\n\t") || javaTermContent.contains("\n\n\t")) {
                requiresEmptyLine = true;
            }
            if (requiresEmptyLine) {
                if (!this._classContent.contains("\n\n" + javaTermContent)) {
                    this._classContent = StringUtil.replace(this._classContent, "\n" + javaTermContent, "\n\n" + javaTermContent);
                    return;
                }
            } else if (this._classContent.contains("\n\n" + javaTermContent)) {
                this._classContent = StringUtil.replace(this._classContent, "\n\n" + javaTermContent, "\n" + javaTermContent);
                return;
            }
            previousJavaTerm = javaTerm;
        }
        String lastJavaTermContent = previousJavaTerm.getContent();
        if (!lastJavaTermContent.endsWith("\n\n")) {
            int x = this._classContent.lastIndexOf(125);
            this._classContent = StringUtil.insert(this._classContent, "\n", x - this._indent.length() + 1);
        }
    }

    protected String fixLeadingTabs(String content, String line, int expectedTabCount) {
        int leadingTabCount = JavaSourceProcessor.getLeadingTabCount(line);
        String newLine = line;
        while (leadingTabCount != expectedTabCount) {
            if (leadingTabCount > expectedTabCount) {
                newLine = StringUtil.replaceFirst(newLine, "\t", "");
                --leadingTabCount;
                continue;
            }
            newLine = "\t" + newLine;
            ++leadingTabCount;
        }
        return StringUtil.replace(content, line, newLine);
    }

    protected void fixTabsAndIncorrectEmptyLines(JavaTerm javaTerm) {
        if (!javaTerm.isConstructor() && !javaTerm.isMethod()) {
            return;
        }
        String javaTermContent = "\n" + javaTerm.getContent();
        Pattern methodNameAndParametersPattern = Pattern.compile("\n" + this._indent + "(private |protected |public ).*?(\\{|;)\n", 32);
        Matcher matcher = methodNameAndParametersPattern.matcher(javaTermContent);
        if (!matcher.find()) {
            return;
        }
        String methodNameAndParameters = matcher.group();
        String[] lines = StringUtil.splitLines(methodNameAndParameters);
        if (lines.length == 1) {
            String trimmedJavaTermContent;
            if (methodNameAndParameters.endsWith("{\n") && javaTermContent.contains(methodNameAndParameters + "\n") && !javaTermContent.contains(methodNameAndParameters + "\n" + this._indent + "\t" + "/*") && !javaTermContent.contains(methodNameAndParameters + "\n" + this._indent + "\t" + "// ") && !(trimmedJavaTermContent = StringUtil.trimTrailing(javaTermContent)).endsWith("\n\n" + this._indent + "}")) {
                this._classContent = StringUtil.replace(this._classContent, methodNameAndParameters + "\n", methodNameAndParameters);
            }
            return;
        }
        if (methodNameAndParameters.endsWith("{\n") && !javaTermContent.contains(methodNameAndParameters + "\n") && !javaTermContent.contains(methodNameAndParameters + this._indent + "}")) {
            this._classContent = StringUtil.replace(this._classContent, methodNameAndParameters, methodNameAndParameters + "\n");
        }
        boolean throwsException = methodNameAndParameters.contains(this._indent + "throws ");
        String newMethodNameAndParameters = methodNameAndParameters;
        int expectedTabCount = -1;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.contains(this._indent + "throws ")) {
                newMethodNameAndParameters = this.fixLeadingTabs(newMethodNameAndParameters, line, this._indent.length() + 1);
                break;
            }
            if (expectedTabCount == -1) {
                if (!line.endsWith("(")) continue;
                expectedTabCount = Math.max(JavaSourceProcessor.getLeadingTabCount(line), this._indent.length()) + 1;
                if (!throwsException || expectedTabCount != this._indent.length() + 1) continue;
                ++expectedTabCount;
                continue;
            }
            String previousLine = lines[i - 1];
            newMethodNameAndParameters = previousLine.endsWith(",") || previousLine.endsWith("(") ? this.fixLeadingTabs(newMethodNameAndParameters, line, expectedTabCount) : this.fixLeadingTabs(newMethodNameAndParameters, line, JavaSourceProcessor.getLeadingTabCount(previousLine) + 1);
        }
        this._classContent = StringUtil.replace(this._classContent, methodNameAndParameters, newMethodNameAndParameters);
    }

    protected void formatAnnotations(JavaTerm javaTerm, List<String> testAnnotationsExcludes) throws Exception {
        String newJavaTermContent;
        String javaTermContent;
        if (this._indent.length() == 1 && !BaseSourceProcessor.isExcludedPath(testAnnotationsExcludes, this._absolutePath) && this._fileName.endsWith("Test.java")) {
            this.checkTestAnnotations(javaTerm);
        }
        if (!(javaTermContent = javaTerm.getContent()).equals(newJavaTermContent = this._javaSourceProcessor.formatAnnotations(this._fileName, javaTerm.getName(), javaTermContent, this._indent))) {
            this._classContent = this._classContent.replace(javaTermContent, newJavaTermContent);
        }
    }

    protected String getAccessModifier() {
        String accessModifier;
        Matcher matcher = this._classPattern.matcher(this._classContent);
        if (matcher.find() && ((accessModifier = matcher.group(1)).equals(_ACCESS_MODIFIER_PRIVATE) || accessModifier.equals(_ACCESS_MODIFIER_PROTECTED) || accessModifier.equals(_ACCESS_MODIFIER_PUBLIC))) {
            return accessModifier;
        }
        return _ACCESS_MODIFIER_UNKNOWN;
    }

    protected String getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf(123);
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf(60)) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(32);
        return line.substring(pos + 1);
    }

    protected String getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(32);
        return line.substring(x + 1);
    }

    protected JavaTerm getJavaTerm(String name, int type, int lineCount, int startPos, int endPos) throws Exception {
        String javaTermContent = this._classContent.substring(startPos, endPos);
        if (Validator.isNull(name) || !this.isValidJavaTerm(javaTermContent)) {
            return null;
        }
        JavaTerm javaTerm = new JavaTerm(name, type, javaTermContent, lineCount, this._indent);
        if (javaTerm.isConstructor()) {
            ++this._constructorCount;
        }
        if (!javaTerm.isClass()) {
            return javaTerm;
        }
        JavaClass innerClass = new JavaClass(name, this._packagePath, this._file, this._fileName, this._absolutePath, this._content, javaTermContent, lineCount, this._indent + "\t", this, this._javaTermAccessLevelModifierExcludes, this._javaSourceProcessor);
        this._innerClasses.add(innerClass);
        return javaTerm;
    }

    protected Set<JavaTerm> getJavaTerms() throws Exception {
        TreeSet<JavaTerm> javaTerms = new TreeSet<JavaTerm>(new JavaTermComparator(false));
        ArrayList<JavaTerm> staticBlocks = new ArrayList<JavaTerm>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(this._classContent));
        int index = 0;
        int lineCount = this._lineCount - 1;
        String line = null;
        String javaTermName = null;
        int javaTermLineCount = -1;
        int javaTermStartPosition = -1;
        int javaTermType = -1;
        int lastCommentOrAnnotationPos = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String insideClass;
            Matcher matcher;
            ++lineCount;
            if (JavaSourceProcessor.getLeadingTabCount(line) != this._indent.length()) {
                index = index + line.length() + 1;
                continue;
            }
            if (line.startsWith(this._indent + "private ") || line.equals(this._indent + _ACCESS_MODIFIER_PRIVATE) || line.startsWith(this._indent + "protected ") || line.equals(this._indent + _ACCESS_MODIFIER_PROTECTED) || line.startsWith(this._indent + "public ") || line.equals(this._indent + _ACCESS_MODIFIER_PUBLIC) || line.equals(this._indent + "static {")) {
                Tuple tuple = this.getJavaTermTuple(line, this._classContent, index);
                if (tuple == null) {
                    return null;
                }
                int javaTermEndPosition = 0;
                javaTermEndPosition = lastCommentOrAnnotationPos == -1 ? index : lastCommentOrAnnotationPos;
                if (javaTermStartPosition != -1 && javaTermEndPosition < this._classContent.length()) {
                    JavaTerm javaTerm = this.getJavaTerm(javaTermName, javaTermType, javaTermLineCount, javaTermStartPosition, javaTermEndPosition);
                    if (javaTerm == null) {
                        return null;
                    }
                    if (javaTermType == 21) {
                        staticBlocks.add(javaTerm);
                    } else {
                        javaTerms.add(javaTerm);
                    }
                }
                javaTermLineCount = lineCount;
                javaTermName = (String)tuple.getObject(0);
                javaTermStartPosition = javaTermEndPosition;
                javaTermType = (Integer)tuple.getObject(1);
                lastCommentOrAnnotationPos = -1;
            } else if (this.hasAnnotationCommentOrJavadoc(line)) {
                if (lastCommentOrAnnotationPos == -1) {
                    lastCommentOrAnnotationPos = index;
                }
            } else if (!(line.startsWith(this._indent + "}") || line.startsWith(this._indent + ")") || line.startsWith(this._indent + "extends") || line.startsWith(this._indent + "implements") || BaseSourceProcessor.isExcludedPath(this._javaTermAccessLevelModifierExcludes, this._absolutePath) || !(matcher = this._classPattern.matcher(this._classContent)).find() || !(insideClass = this._classContent.substring(matcher.end())).contains(line) || this.isEnumType(line, matcher.group(4)))) {
                this._javaSourceProcessor.processErrorMessage(this._fileName, "Missing access level modifier: " + this._fileName + " " + lineCount);
            }
            index = index + line.length() + 1;
        }
        if (javaTermStartPosition != -1) {
            int javaTermEndPosition = this._classContent.lastIndexOf(125) - this._indent.length() + 1;
            JavaTerm javaTerm = this.getJavaTerm(javaTermName, javaTermType, javaTermLineCount, javaTermStartPosition, javaTermEndPosition);
            if (javaTerm == null) {
                return null;
            }
            if (javaTermType == 21) {
                staticBlocks.add(javaTerm);
            } else {
                javaTerms.add(javaTerm);
            }
        }
        return this.addStaticBlocks(javaTerms, staticBlocks);
    }

    protected Tuple getJavaTermTuple(String line, String accessModifier) {
        if (!line.startsWith(this._indent + accessModifier + " ")) {
            return null;
        }
        int x = line.indexOf(61);
        int y = line.indexOf(40);
        if (line.startsWith(this._indent + accessModifier + " static ")) {
            if (line.contains(" class ") || line.contains(" enum ")) {
                return this.getJavaTermTuple(this.getClassName(line), accessModifier, 23, 15, 7);
            }
            if (x > 0 && (y == -1 || y > x) || line.endsWith(";") && y == -1) {
                return this.getJavaTermTuple(this.getVariableName(line), accessModifier, 20, 12, 1);
            }
            if (y != -1) {
                return this.getJavaTermTuple(this.getConstructorOrMethodName(line, y), accessModifier, 17, 9, 3);
            }
            return null;
        }
        if (line.contains(" @interface ") || line.contains(" class ") || line.contains(" enum ") || line.contains(" interface ")) {
            return this.getJavaTermTuple(this.getClassName(line), accessModifier, 24, 16, 8);
        }
        if (x > 0 && (y == -1 || y > x) || line.endsWith(";") && y == -1) {
            return this.getJavaTermTuple(this.getVariableName(line), accessModifier, 22, 14, 6);
        }
        if (y != -1) {
            int spaceCount = StringUtil.count(line.substring(0, y), " ");
            if (spaceCount == 1) {
                return this.getJavaTermTuple(this.getConstructorOrMethodName(line, y), accessModifier, 18, 10, 4);
            }
            if (spaceCount > 1) {
                return this.getJavaTermTuple(this.getConstructorOrMethodName(line, y), accessModifier, 19, 11, 5);
            }
        }
        return null;
    }

    protected Tuple getJavaTermTuple(String line, String content, int index) {
        int posStartNextLine = index;
        while (!line.endsWith("{") && !line.endsWith(";")) {
            posStartNextLine = content.indexOf(10, posStartNextLine) + 1;
            int posEndNextline = content.indexOf(10, posStartNextLine);
            String nextLine = content.substring(posStartNextLine, posEndNextline);
            nextLine = StringUtil.trimLeading(nextLine);
            if (line.endsWith("(")) {
                line = line + nextLine;
                continue;
            }
            line = line + " " + nextLine;
        }
        line = StringUtil.replace(line, " synchronized ", " ");
        for (String accessModifier : _ACCESS_MODIFIERS) {
            Tuple tuple = this.getJavaTermTuple(line, accessModifier);
            if (tuple == null) continue;
            return tuple;
        }
        if (line.startsWith(this._indent + "static {")) {
            return new Tuple("static", 21);
        }
        return null;
    }

    protected Tuple getJavaTermTuple(String javaTermName, String accessModifier, int privateJavaTermType, int protectedJavaTermType, int publicJavaTermType) {
        if (accessModifier.equals(_ACCESS_MODIFIER_PRIVATE)) {
            return new Tuple(javaTermName, privateJavaTermType);
        }
        if (accessModifier.equals(_ACCESS_MODIFIER_PROTECTED)) {
            return new Tuple(javaTermName, protectedJavaTermType);
        }
        return new Tuple(javaTermName, publicJavaTermType);
    }

    protected String getVariableName(String line) {
        int x = line.indexOf(61);
        int y = line.lastIndexOf(32);
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim(line);
            y = line.lastIndexOf(32);
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    protected boolean hasAnnotationCommentOrJavadoc(String s) {
        return s.startsWith(this._indent + "@") || s.startsWith(this._indent + "/") || s.startsWith(this._indent + " *");
    }

    protected boolean isEnumType(String line, String javaClassType) {
        if (!javaClassType.equals("enum")) {
            return false;
        }
        Matcher matcher = this._enumTypePattern.matcher(line + "\n");
        return matcher.find();
    }

    protected boolean isFinalableField(JavaTerm javaTerm, String javaTermClassName, Pattern pattern, boolean checkOuterClass) {
        if (this._javaTerms == null) {
            return false;
        }
        if (checkOuterClass && this._outerClass != null) {
            return this._outerClass.isFinalableField(javaTerm, javaTermClassName, pattern, true);
        }
        for (JavaTerm curJavaTerm : this._javaTerms) {
            if (!curJavaTerm.isMethod() && (!curJavaTerm.isConstructor() || javaTermClassName.equals(this._name))) continue;
            String content = curJavaTerm.getContent();
            Matcher matcher = pattern.matcher(content);
            if (!content.contains(javaTerm.getName()) || !matcher.find()) continue;
            return false;
        }
        for (JavaClass innerClass : this._innerClasses) {
            if (innerClass.isFinalableField(javaTerm, javaTermClassName, pattern, false)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidJavaTerm(String content) {
        if (content.startsWith(this._indent + "static {")) {
            return true;
        }
        while (!(content.startsWith(this._indent + _ACCESS_MODIFIER_PRIVATE) || content.startsWith(this._indent + _ACCESS_MODIFIER_PROTECTED) || content.startsWith(this._indent + _ACCESS_MODIFIER_PUBLIC))) {
            content = content.substring(content.indexOf(10) + 1);
        }
        int indentLinesCount = StringUtil.count(content, "\n" + this._indent) - StringUtil.count(content, "\n" + this._indent + "\t");
        if ((content = StringUtil.trim(content)).endsWith("}") && (indentLinesCount == 1 || (indentLinesCount == 2 || indentLinesCount == 3) && content.contains("\n" + this._indent + "static {"))) {
            return true;
        }
        return content.endsWith("};") && indentLinesCount == 1 || content.endsWith(";") && indentLinesCount == 0;
    }

    protected void sortJavaTerms(JavaTerm previousJavaTerm, JavaTerm javaTerm, List<String> javaTermSortExcludes) {
        if (previousJavaTerm == null || this._content.contains("@Meta.OCD(")) {
            return;
        }
        String javaTermName = javaTerm.getName();
        if (BaseSourceProcessor.isExcludedPath(javaTermSortExcludes, this._absolutePath, -1, javaTermName)) {
            return;
        }
        if (previousJavaTerm.getLineCount() <= javaTerm.getLineCount()) {
            return;
        }
        String previousJavaTermName = previousJavaTerm.getName();
        String javaTermNameLowerCase = StringUtil.toLowerCase(javaTermName);
        String previousJavaTermNameLowerCase = StringUtil.toLowerCase(previousJavaTermName);
        if (!(this._fileName.contains("persistence") && (previousJavaTermName.startsWith("doCount") && javaTermName.startsWith("doCount") || previousJavaTermName.startsWith("doFind") && javaTermName.startsWith("doFind") || previousJavaTermNameLowerCase.startsWith("count") && javaTermNameLowerCase.startsWith("count") || previousJavaTermNameLowerCase.startsWith("filter") && javaTermNameLowerCase.startsWith("filter") || previousJavaTermNameLowerCase.startsWith("find") && javaTermNameLowerCase.startsWith("find") || previousJavaTermNameLowerCase.startsWith("join") && javaTermNameLowerCase.startsWith("join")))) {
            this._classContent = StringUtil.replaceFirst(this._classContent, "\n" + javaTerm.getContent(), "\n" + previousJavaTerm.getContent());
            this._classContent = StringUtil.replaceLast(this._classContent, "\n" + previousJavaTerm.getContent(), "\n" + javaTerm.getContent());
        }
    }
}

