/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.portal.tools.ImportsFormatter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDImportsFormatter
extends ImportsFormatter {
    public static String getImports(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String formatBNDImports(String content, Pattern pattern) throws IOException {
        String imports = BNDImportsFormatter.getImports(content, pattern);
        if (Validator.isNull(imports)) {
            return content;
        }
        BNDImportsFormatter importsFormatter = new BNDImportsFormatter();
        String newImports = importsFormatter.format(imports);
        newImports = StringUtil.replace(newImports, new String[]{"\n", "\n,\\"}, new String[]{",\\\n", "\n\t\\"});
        if (!imports.equals(newImports = StringUtil.replaceLast(newImports, ",\\", ""))) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        return content;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        String importString;
        if (line.endsWith("\\")) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.endsWith(",")) {
            line = line.substring(0, line.length() - 1);
        }
        if (Validator.isNull(importString = StringUtil.trim(line))) {
            return null;
        }
        int pos = importString.indexOf(";");
        if (pos != -1) {
            importString = importString.substring(0, pos);
        }
        return new ImportPackage(importString, false, line, true);
    }
}

