/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.highlight;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HighlightUtil {
    public static final String HIGHLIGHT_TAG_CLOSE = "</liferay-hl>";
    public static final String HIGHLIGHT_TAG_OPEN = "<liferay-hl>";
    public static final String[] HIGHLIGHTS = new String[]{"<span class=\"highlight\">", "</span>"};
    private static final Pattern _pattern = Pattern.compile("<liferay-hl>(.*?)</liferay-hl>");

    public static void addSnippet(Document document, Set<String> queryTerms, String snippet, String snippetFieldName) {
        if (!snippet.equals("")) {
            Matcher matcher = _pattern.matcher(snippet);
            while (matcher.find()) {
                queryTerms.add(matcher.group(1));
            }
            snippet = StringUtil.replace(snippet, HIGHLIGHT_TAG_OPEN, "");
            snippet = StringUtil.replace(snippet, HIGHLIGHT_TAG_CLOSE, "");
        }
        document.addText("snippet".concat("_").concat(snippetFieldName), snippet);
    }

    public static String highlight(String s, String[] queryTerms) {
        return HighlightUtil.highlight(s, queryTerms, HIGHLIGHTS[0], HIGHLIGHTS[1]);
    }

    public static String highlight(String s, String[] queryTerms, String highlight1, String highlight2) {
        if (Validator.isNull(s) || ArrayUtil.isEmpty(queryTerms)) {
            return s;
        }
        if (queryTerms.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * queryTerms.length - 1);
        for (int i = 0; i < queryTerms.length; ++i) {
            sb.append(Pattern.quote(queryTerms[i].trim()));
            if (i + 1 >= queryTerms.length) continue;
            sb.append("|");
        }
        int flags = 66;
        Pattern pattern = Pattern.compile(sb.toString(), flags);
        return HighlightUtil._highlight(s, pattern, highlight1, highlight2);
    }

    private static String _highlight(String s, Pattern pattern, String highlight1, String highlight2) {
        StringTokenizer st = new StringTokenizer(s);
        if (st.countTokens() == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * st.countTokens() - 1);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Matcher matcher = pattern.matcher(token);
            if (matcher.find()) {
                StringBuffer hightlighted = new StringBuffer();
                do {
                    matcher.appendReplacement(hightlighted, highlight1 + matcher.group() + highlight2);
                } while (matcher.find());
                matcher.appendTail(hightlighted);
                sb.append(hightlighted);
            } else {
                sb.append(token);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

