/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseServiceImplCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;
import org.dom4j.DocumentException;

public class JavaServiceImplErcUsageCheck
extends BaseServiceImplCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws DocumentException, IOException {
        String entityName;
        JavaClass javaClass = javaTerm.getParentJavaClass();
        if (javaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        String className = javaClass.getName();
        if (className.endsWith("LocalServiceImpl") || !className.endsWith("ServiceImpl")) {
            return javaTerm.getContent();
        }
        List<String> ercEnabledEntityNames = this.getErcEnabledEntityNames(this.getServiceXmlDocument(absolutePath));
        if (!ercEnabledEntityNames.contains(entityName = this.getEntityName(className))) {
            return javaTerm.getContent();
        }
        return this._formatServiceImpl(entityName, javaTerm);
    }

    private String _formatServiceImpl(String entityName, JavaTerm javaTerm) {
        String lastMethodNameContent;
        String entityLocalServiceName;
        String javaTermName = javaTerm.getName();
        JavaSignature javaSignature = javaTerm.getSignature();
        String entityReturnType = javaSignature.getReturnType();
        if (!this.isApplicableCheck(entityName, entityReturnType, javaTermName)) {
            return javaTerm.getContent();
        }
        String javaTermContent = javaTerm.getContent();
        if (!javaTermContent.contains(entityLocalServiceName = StringUtil.lowerCaseFirstLetter(entityReturnType) + "LocalService.")) {
            return javaTermContent;
        }
        for (JavaParameter parameter : javaSignature.getParameters()) {
            if (!StringUtil.equals(parameter.getParameterName(), "externalReferenceCode") || !StringUtil.equals(parameter.getParameterType(), "String")) continue;
            return javaTermContent;
        }
        String methodName = javaTermName + "(";
        int x = -1;
        while ((x = javaTermContent.indexOf(methodName, x + 1)) != -1) {
            if (this.isInsideComment(javaTermContent, x)) continue;
            javaTermContent = StringUtil.insert(javaTermContent, "String externalReferenceCode, ", methodName.length() + x);
            break;
        }
        if ((lastMethodNameContent = StringUtil.extractLast(javaTermContent, methodName)).contains("externalReferenceCode,")) {
            return javaTermContent;
        }
        return StringUtil.replaceLast(javaTermContent, methodName, methodName + "\n\t\texternalReferenceCode, ");
    }
}

