/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseStylingCheck;
import com.liferay.source.formatter.check.util.JsonSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLStylingCheck
extends BaseStylingCheck {
    private static final Pattern _assignPattern = Pattern.compile("\n(\t*)\\w+ =(\\s*\\{)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatAssignBlock(content);
        return this.formatStyling(content);
    }

    private String _fixIndentation(String content, String indent) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (Validator.isNull(line)) {
                    sb.append("\n");
                    continue;
                }
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.matches("\\w+ =.*")) {
                    sb.append(indent);
                    sb.append("\t");
                    sb.append(trimmedLine);
                } else {
                    sb.append(line);
                }
                sb.append("\n");
            }
            if (sb.length() > 0) {
                sb.setIndex(sb.index() - 1);
            }
        }
        return sb.toString();
    }

    private String _formatAssignBlock(String content) throws IOException {
        int x = -1;
        block0: while ((x = content.indexOf("<#assign\n", x + 1)) != -1) {
            int y = x;
            while ((y = content.indexOf("/>", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(content, y)) continue;
                String assignContent = content.substring(x += 8, y);
                int level = this.getLevel(assignContent, new String[]{"{", "("}, new String[]{"}", ")"});
                if (level != 0) continue;
                assignContent = StringUtil.trimTrailing(assignContent);
                int lineNumber = SourceUtil.getLineNumber(content, x);
                String newAssignContent = this._fixIndentation(assignContent, SourceUtil.getIndent(SourceUtil.getLine(content, lineNumber)));
                if (assignContent.equals(newAssignContent = this._formatJsonAssign(newAssignContent))) continue block0;
                return StringUtil.replace(content, assignContent, newAssignContent, x);
            }
        }
        return content;
    }

    private String _formatJsonAssign(String content) {
        Matcher matcher = _assignPattern.matcher(content);
        block0: while (matcher.find()) {
            int x = matcher.end();
            while ((x = content.indexOf("}\n", x + 1)) != -1) {
                String s;
                int level;
                if (ToolsUtil.isInsideQuotes(content, x) || (level = this.getLevel(s = content.substring(matcher.start(2), x + 2), "{", "}")) != 0) continue;
                JSONObject jsonObject = JsonSourceUtil.getJSONObject(s);
                if (jsonObject == null) continue block0;
                String indent = matcher.group(1);
                StringBundler sb = new StringBundler(2);
                sb.append("\n");
                sb.append(JsonSourceUtil.fixIndentation(jsonObject, indent + "\t"));
                String replacement = sb.toString();
                if (s.equals(replacement)) continue block0;
                return StringUtil.replace(content, s, replacement, matcher.start(2));
            }
        }
        return content;
    }
}

