/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertiesPlaywrightTestCheck
extends BaseFileCheck {
    private static final String _PLAYWRIGHT_TEST_PROJECT_NAME = "playwright.test.project[playwright-js-tomcat90-mysql57-jdk8][relevant]";
    private static final String _TESTRAY_MAIN_COMPONENT_NAME = "testray.main.component.name";
    private List<String> _buildGradleFileNames;
    private List<String> _testrayAllTeamsComponentNames;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/test.properties")) {
            return content;
        }
        if (absolutePath.contains("/modules/test/playwright/tests/")) {
            List<String> buildGradleFileNames;
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            String testrayMainComponentName = properties.getProperty(_TESTRAY_MAIN_COMPONENT_NAME);
            if (testrayMainComponentName == null) {
                this.addMessage(fileName, "Missing property 'testray.main.component.name' in test.properties");
                return content;
            }
            List<String> testrayAllTeamsComponentNames = this._getTestrayAllTeamsComponentNames();
            if (!testrayAllTeamsComponentNames.contains(testrayMainComponentName)) {
                this.addMessage(fileName, StringBundler.concat("Property value '", testrayMainComponentName, "' does not exist in 'testray.team.*.component.names' ", "in ", SourceUtil.getRootDirName(absolutePath), "/test.properties"));
            }
            if (ListUtil.isEmpty(buildGradleFileNames = this._getBuildGradleFileNames())) {
                return content;
            }
            String moduleName = this._getModuleName(absolutePath);
            ArrayList<String> testPropertiesFileNames = new ArrayList<String>();
            for (String buildGradleFileName : buildGradleFileNames) {
                if (!buildGradleFileName.endsWith("/" + moduleName + "/build.gradle")) continue;
                int x = buildGradleFileName.lastIndexOf("/");
                testPropertiesFileNames.add(buildGradleFileName.substring(0, x) + "/test.properties");
            }
            if (ListUtil.isEmpty(testPropertiesFileNames) || testPropertiesFileNames.size() != 1) {
                return content;
            }
            File file = new File((String)testPropertiesFileNames.get(0));
            if (!file.exists()) {
                this.addMessage(fileName, "Missing test.properties for module '" + moduleName + "' in modules");
            }
        }
        if (absolutePath.contains("/modules/apps/") || absolutePath.contains("/modules/dxp/apps/")) {
            String moduleName = this._getModuleName(absolutePath);
            File file = new File(this.getPortalDir() + "/modules/test/playwright/tests/" + moduleName);
            if (!file.exists()) {
                return content;
            }
            if (!(file = new File(file, "test.properties")).exists()) {
                this.addMessage(fileName, "Missing test.properties in playwright/tests/" + moduleName);
                return content;
            }
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            List<String> playwrightTestProjectList = ListUtil.fromString(properties.getProperty(_PLAYWRIGHT_TEST_PROJECT_NAME), ",");
            if (ListUtil.isEmpty(playwrightTestProjectList)) {
                this.addMessage(fileName, "Missing property 'playwright.test.project[playwright-js-tomcat90-mysql57-jdk8][relevant]' in test.properties");
            } else if (!playwrightTestProjectList.contains(moduleName)) {
                this.addMessage(fileName, StringBundler.concat("Missing property value '", moduleName, "' in '", _PLAYWRIGHT_TEST_PROJECT_NAME, "'"));
            }
        }
        return content;
    }

    private synchronized List<String> _getBuildGradleFileNames() throws IOException {
        if (this._buildGradleFileNames != null) {
            return this._buildGradleFileNames;
        }
        this._buildGradleFileNames = SourceFormatterUtil.scanForFileNames(this.getPortalDir().getCanonicalPath() + "/modules", new String[]{"apps/**/build.gradle", "dxp/apps/**/build.gradle"});
        return this._buildGradleFileNames;
    }

    private String _getModuleName(String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        return absolutePath.substring(y + 1, x);
    }

    private synchronized List<String> _getTestrayAllTeamsComponentNames() throws IOException {
        if (this._testrayAllTeamsComponentNames != null) {
            return this._testrayAllTeamsComponentNames;
        }
        this._testrayAllTeamsComponentNames = new ArrayList<String>();
        File file = new File(this.getPortalDir(), "test.properties");
        if (!file.exists()) {
            return this._testrayAllTeamsComponentNames;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        List<String> testrayAvailableComponentNames = ListUtil.fromString(properties.getProperty("testray.available.component.names"), ",");
        for (String testrayAvailableComponentName : testrayAvailableComponentNames) {
            String testrayTeamComponentName;
            List<String> testrayTeamComponentNames;
            if (!testrayAvailableComponentName.startsWith("${") && !testrayAvailableComponentName.endsWith("}") || ListUtil.isEmpty(testrayTeamComponentNames = ListUtil.fromString(properties.getProperty(testrayTeamComponentName = testrayAvailableComponentName.substring(2, testrayAvailableComponentName.length() - 1)), ","))) continue;
            this._testrayAllTeamsComponentNames.addAll(testrayTeamComponentNames);
        }
        return this._testrayAllTeamsComponentNames;
    }
}

