/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLWorkflowDefinitionFileStylingCheck
extends BaseFileCheck {
    private static final Pattern _labelTagPattern = Pattern.compile("\t<label [^>]*?>\n\t*(.+)\n\t*</label>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("workflow-definition.xml")) {
            return content;
        }
        Matcher matcher = _labelTagPattern.matcher(content);
        while (matcher.find()) {
            String titleCaseLabel;
            String label = matcher.group(1);
            if (label.equals(titleCaseLabel = StringUtil.getTitleCase(label, false, new String[0]))) continue;
            return StringUtil.replaceFirst(content, label, titleCaseLabel, matcher.start(1));
        }
        return content;
    }
}

