/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ConstructorMissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE = "empty.line.missing";

    public int[] getDefaultTokens() {
        return new int[]{8};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST statementsDetailAST = detailAST.findFirstToken(7);
        if (statementsDetailAST == null) {
            return;
        }
        List<String> parameterNames = this.getParameterNames(detailAST);
        if (parameterNames.isEmpty()) {
            return;
        }
        DetailAST nextExpressionDetailAST = statementsDetailAST.getFirstChild();
        if (!this._isExpressionAssignsParameter(nextExpressionDetailAST, parameterNames)) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(nextExpressionDetailAST);
        while (true) {
            nextExpressionDetailAST = nextExpressionDetailAST.getNextSibling();
            if ((nextExpressionDetailAST = nextExpressionDetailAST.getNextSibling()) != null && nextExpressionDetailAST.getType() == 73) {
                return;
            }
            if (!this._isExpressionAssignsParameter(nextExpressionDetailAST, parameterNames)) {
                int startLineNumber = this.getStartLineNumber(nextExpressionDetailAST);
                if (endLineNumber + 1 != startLineNumber) {
                    return;
                }
                this.log(startLineNumber, _MSG_MISSING_EMPTY_LINE, new Object[]{startLineNumber});
                return;
            }
            endLineNumber = this.getEndLineNumber(nextExpressionDetailAST);
        }
    }

    private boolean _isExpressionAssignsParameter(DetailAST expressionDetailAST, List<String> parameters) {
        String text;
        DetailAST lastChildDetailAST;
        if (expressionDetailAST == null || expressionDetailAST.getType() != 28) {
            return false;
        }
        DetailAST childDetailAST = expressionDetailAST.getFirstChild();
        if (childDetailAST.getType() != 80 || childDetailAST.getChildCount() != 2) {
            return false;
        }
        DetailAST firstChildDetailAST = childDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 58) {
            if (firstChildDetailAST.getChildCount() != 2) {
                return false;
            }
            DetailAST detailAST1 = firstChildDetailAST.getFirstChild();
            DetailAST detailAST2 = firstChildDetailAST.getLastChild();
            if (detailAST1.getType() != 78 || detailAST2.getType() != 58) {
                return false;
            }
        }
        if ((lastChildDetailAST = childDetailAST.getLastChild()).getType() == 58 && !parameters.contains(text = lastChildDetailAST.getText()) && !text.matches("^[A-Z0-9_]+$")) {
            return false;
        }
        DetailAST nextSiblingDetailAST = expressionDetailAST.getNextSibling();
        return nextSiblingDetailAST.getType() == 45;
    }
}

