/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    private byte[] _buffer;
    private int _index;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this._buffer = new byte[size];
    }

    public void reset() {
        this._index = 0;
    }

    public int size() {
        return this._index;
    }

    public byte[] toByteArray() {
        byte[] newBuffer = new byte[this._index];
        System.arraycopy(this._buffer, 0, newBuffer, 0, this._index);
        return newBuffer;
    }

    public String toString() {
        return new String(this._buffer, 0, this._index);
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this._buffer, 0, this._index, charsetName);
    }

    public byte[] unsafeGetByteArray() {
        return this._buffer;
    }

    public ByteBuffer unsafeGetByteBuffer() {
        return ByteBuffer.wrap(this._buffer, 0, this._index);
    }

    @Override
    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        BoundaryCheckerUtil.check(bytes.length, offset, length);
        if (length == 0) {
            return;
        }
        int newIndex = this._index + length;
        this._ensureCapacity(newIndex);
        System.arraycopy(bytes, offset, this._buffer, this._index, length);
        this._index = newIndex;
    }

    @Override
    public void write(int b) {
        int newIndex = this._index + 1;
        this._ensureCapacity(newIndex);
        this._buffer[this._index] = (byte)b;
        this._index = newIndex;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this._buffer, 0, this._index);
    }

    private void _ensureCapacity(int minCapacity) {
        if (minCapacity > this._buffer.length) {
            int newBufferSize = Math.max(this._buffer.length << 1, minCapacity);
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._buffer.length);
            this._buffer = newBuffer;
        }
    }
}

