/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeSCSSMixinsCheck
extends BaseUpgradeCheck {
    private static final Pattern _mixinPattern = Pattern.compile("@include\\s*(([\\w+-]+)\\((.+)*\\))");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher = _mixinPattern.matcher(content);
        while (matcher.find()) {
            String method = matcher.group(1);
            String mixin = matcher.group(2);
            if (mixin.equals("media-query")) {
                content = StringUtil.replace(content, method, this._replaceMediaQuery(fileName, method));
            } else if (mixin.equals("respond-to")) {
                content = StringUtil.replace(content, method, this._replaceRespondTo(method));
            }
            content = StringUtil.replace(content, method, this._replaceGenericType(method));
        }
        return content;
    }

    @Override
    protected String[] getValidExtensions() {
        return new String[]{"scss"};
    }

    private String _replaceGenericType(String mixin) {
        String methodCall = mixin.substring(0, mixin.indexOf("("));
        if (methodCall.equals("lg")) {
            return "media-breakpoint-up(xl)";
        }
        if (methodCall.equals("md")) {
            return "media-breakpoint-up(lg)";
        }
        if (methodCall.equals("sm")) {
            return "media-breakpoint-up(md)";
        }
        if (methodCall.equals("xs")) {
            return "media-breakpoint-up(sm)";
        }
        return mixin;
    }

    private String _replaceMediaQuery(String fileName, String mixin) {
        List<String> parameterNames = JavaSourceUtil.getParameterNames(mixin);
        if (parameterNames.size() != 1) {
            String message = StringBundler.concat("Do not use 'media-query' mixing, replace with its equivalent ", "(e.g., media-breakpoint-up, media-breakpoint-only, ", "media-breakpoint-down, etc.), see LPS-194507.");
            this.addMessage(fileName, message);
        } else {
            if (parameterNames.contains("md")) {
                return "media-breakpoint-up(lg)";
            }
            if (parameterNames.contains("sm")) {
                return "media-breakpoint-up(md)";
            }
        }
        return mixin;
    }

    private String _replaceRespondTo(String mixin) {
        List<String> parameterNames = JavaSourceUtil.getParameterNames(mixin);
        if (parameterNames.contains("desktop")) {
            if (parameterNames.contains("tablet")) {
                return "media-breakpoint-up(md)";
            }
            return "media-breakpoint-up(lg)";
        }
        if (parameterNames.contains("phone")) {
            if (parameterNames.contains("tablet")) {
                return "media-breakpoint-down(md)";
            }
            return "media-breakpoint-down(sm)";
        }
        if (parameterNames.contains("tablet")) {
            return "media-breakpoint-only(md)";
        }
        return mixin;
    }
}

