/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TryWithResourcesCheck
extends BaseCheck {
    private static final String _CLOSEABLE_TYPE_NAMES_CATEGORY = "closeableTypeNames";
    private static final String _CLOSEABLE_TYPE_NAMES_FILE_NAME = "closeable-type-names.json";
    private static final String _MSG_USE_TRY_WITH_RESOURCES = "try.with.resources.use";
    private static final String _POPULATE_TYPE_NAMES_KEY = "populateTypeNames";
    private static final Log _log = LogFactoryUtil.getLog(TryWithResourcesCheck.class);
    private Tuple _closeableTypeNamesTuple;

    public int[] getDefaultTokens() {
        return new int[]{95};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST literalFinallyDetailAST = detailAST.findFirstToken(97);
        if (literalFinallyDetailAST != null) {
            this._checkFinallyStatement(detailAST, literalFinallyDetailAST);
        }
        if (!this.isAttributeValue(_POPULATE_TYPE_NAMES_KEY)) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 176) {
            this._populateCloseableTypeNames(firstChildDetailAST);
        }
    }

    private void _checkFinallyStatement(DetailAST literalTryDetailAST, DetailAST literalFinallyDetailAST) {
        HashMap<Integer, String> cleanUpVariableNamesMap = new HashMap<Integer, String>();
        HashMap<Integer, String> closeVariableNamesMap = new HashMap<Integer, String>();
        DetailAST slistDetailAST = literalFinallyDetailAST.findFirstToken(7);
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(slistDetailAST, true, 27);
        for (DetailAST detailAST : methodCallDetailASTList) {
            List<String> cleanUpVariableNames = this._getCleanUpVariableNames(detailAST);
            for (String cleanUpVariableName : cleanUpVariableNames) {
                DetailAST typeDetailAST;
                if (!this._useTryWithResources(cleanUpVariableName, typeDetailAST = this.getVariableTypeDetailAST(literalTryDetailAST, cleanUpVariableName, false), literalTryDetailAST)) {
                    return;
                }
                cleanUpVariableNamesMap.put(detailAST.getLineNo(), cleanUpVariableName);
            }
            String closeVariableName = this._getCloseVariableName(detailAST, literalFinallyDetailAST);
            if (closeVariableName == null) continue;
            DetailAST typeDetailAST = this.getVariableTypeDetailAST(literalTryDetailAST, closeVariableName, false);
            if (!this._useTryWithResources(closeVariableName, typeDetailAST, literalTryDetailAST)) {
                return;
            }
            List<String> closeableTypeNames = this._getCloseableTypeNames();
            if (!closeableTypeNames.contains(this.getFullyQualifiedTypeName(typeDetailAST, true))) {
                return;
            }
            closeVariableNamesMap.put(detailAST.getLineNo(), closeVariableName);
        }
        for (Map.Entry entry : cleanUpVariableNamesMap.entrySet()) {
            this.log((Integer)entry.getKey(), _MSG_USE_TRY_WITH_RESOURCES, new Object[]{entry.getValue(), "DataAccess.cleanUp"});
        }
        for (Map.Entry entry : closeVariableNamesMap.entrySet()) {
            String closeVariableName = (String)entry.getValue();
            this.log((Integer)entry.getKey(), _MSG_USE_TRY_WITH_RESOURCES, new Object[]{closeVariableName, closeVariableName + ".close"});
        }
    }

    private List<String> _getCleanUpVariableNames(DetailAST methodCallDetailAST) {
        ArrayList<String> variableNames = new ArrayList<String>();
        DetailAST dotDetailAST = methodCallDetailAST.getFirstChild();
        if (dotDetailAST.getType() != 59) {
            return variableNames;
        }
        DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
        if (!Objects.equals(lastChildDetailAST.getText(), "cleanUp")) {
            return variableNames;
        }
        DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
        if (!Objects.equals(firstChildDetailAST.getText(), "DataAccess")) {
            return variableNames;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 58) continue;
            variableNames.add(firstChildDetailAST.getText());
        }
        return variableNames;
    }

    private List<String> _getCloseableTypeNames() {
        Tuple closeableTypeNamesTuple = this._getCloseableTypeNamesTuple();
        JSONObject jsonObject = (JSONObject)closeableTypeNamesTuple.getObject(0);
        JSONArray jsonArray = (JSONArray)jsonObject.get(_CLOSEABLE_TYPE_NAMES_CATEGORY);
        return JSONUtil.toStringList(jsonArray, "name");
    }

    private synchronized Tuple _getCloseableTypeNamesTuple() {
        if (this._closeableTypeNamesTuple != null) {
            return this._closeableTypeNamesTuple;
        }
        this._closeableTypeNamesTuple = this.getTypeNamesTuple(_CLOSEABLE_TYPE_NAMES_FILE_NAME, _CLOSEABLE_TYPE_NAMES_CATEGORY);
        return this._closeableTypeNamesTuple;
    }

    private String _getCloseVariableName(DetailAST methodCallDetailAST, DetailAST literalFinallyDetailAST) {
        DetailAST dotDetailAST = methodCallDetailAST.getFirstChild();
        if (dotDetailAST.getType() != 59) {
            return null;
        }
        DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
        if (!Objects.equals(lastChildDetailAST.getText(), "close")) {
            return null;
        }
        DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 58) {
            return null;
        }
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return null;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 7) {
            return null;
        }
        String variableName = firstChildDetailAST.getText();
        if (this.equals(parentDetailAST = parentDetailAST.getParent(), literalFinallyDetailAST)) {
            return variableName;
        }
        if (parentDetailAST.getType() != 83) {
            return null;
        }
        DetailAST exprDetailAST = parentDetailAST.findFirstToken(28);
        firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 115) {
            return null;
        }
        lastChildDetailAST = firstChildDetailAST.getLastChild();
        if (lastChildDetailAST.getType() != 135) {
            return null;
        }
        if (!variableName.equals((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getText())) {
            return null;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 7) {
            return null;
        }
        if (this.equals(parentDetailAST = parentDetailAST.getParent(), literalFinallyDetailAST)) {
            return variableName;
        }
        return null;
    }

    private void _populateCloseableTypeNames(DetailAST resourceSpecificationDetailAST) {
        Tuple closeableTypeNamesTuple = this._getCloseableTypeNamesTuple();
        File closeableTypeNamesFile = (File)closeableTypeNamesTuple.getObject(1);
        if (closeableTypeNamesFile == null) {
            return;
        }
        DetailAST resourcesDetailAST = resourceSpecificationDetailAST.findFirstToken(177);
        if (resourcesDetailAST == null) {
            return;
        }
        List<String> closeableTypeNames = this._getCloseableTypeNames();
        List<DetailAST> resourceDetailASTList = this.getAllChildTokens(resourcesDetailAST, false, 178);
        for (DetailAST resourceDetailAST : resourceDetailASTList) {
            String typeName;
            DetailAST typeDetailAST = resourceDetailAST.findFirstToken(13);
            if (typeDetailAST == null || (typeName = this.getFullyQualifiedTypeName(typeDetailAST, false)) == null || closeableTypeNames.contains(typeName)) continue;
            closeableTypeNames.add(typeName);
            Collections.sort(closeableTypeNames);
            try {
                JSONObjectImpl jsonObject = new JSONObjectImpl();
                JSONArrayImpl jsonArray = new JSONArrayImpl();
                for (String closeableTypeName : closeableTypeNames) {
                    jsonArray.put(new JSONObjectImpl(HashMapBuilder.put("name", closeableTypeName).build()));
                }
                jsonObject.put(_CLOSEABLE_TYPE_NAMES_CATEGORY, jsonArray);
                FileUtil.write(closeableTypeNamesFile, JSONUtil.toString(jsonObject));
                System.out.println(StringBundler.concat("Added '", typeName, "' to '", _CLOSEABLE_TYPE_NAMES_FILE_NAME, "'"));
                this._closeableTypeNamesTuple = null;
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(ioException);
            }
        }
    }

    private boolean _useTryWithResources(String variableName, DetailAST typeDetailAST, DetailAST literalTryDetailAST) {
        if (typeDetailAST == null) {
            return false;
        }
        DetailAST parentDetailAST = typeDetailAST.getParent();
        if (parentDetailAST.getType() != 10 || this.hasParentWithTokenType(typeDetailAST, 156)) {
            return false;
        }
        int endLineNumber = this.getEndLineNumber(literalTryDetailAST);
        int assignCount = 0;
        DetailAST assignDetailAST = parentDetailAST.findFirstToken(80);
        if (assignDetailAST != null) {
            DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
            if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 135) {
                ++assignCount;
            }
        }
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(parentDetailAST, variableName);
        for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
            if (this.hasParentWithTokenType(variableCallerDetailAST, 181)) {
                return false;
            }
            parentDetailAST = variableCallerDetailAST.getParent();
            if (parentDetailAST.getType() == 80) {
                if (assignCount > 0) {
                    return false;
                }
                DetailAST literalIfDetailAST = this.getParentWithTokenType(variableCallerDetailAST, 83);
                if (literalIfDetailAST != null && literalIfDetailAST.getLineNo() > typeDetailAST.getLineNo()) {
                    return false;
                }
                ++assignCount;
            }
            if (variableCallerDetailAST.getLineNo() > endLineNumber) {
                return false;
            }
            DetailAST callerLiteralTryDetailAST = this.getParentWithTokenType(variableCallerDetailAST, 95);
            if (callerLiteralTryDetailAST == null || callerLiteralTryDetailAST.getLineNo() >= literalTryDetailAST.getLineNo() && (callerLiteralTryDetailAST.getLineNo() != literalTryDetailAST.getLineNo() || !this.hasParentWithTokenType(variableCallerDetailAST, 96))) continue;
            return false;
        }
        return true;
    }
}

