/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiPropsUtilCheck
extends BaseFileCheck {
    private static final Pattern _propsUtilGetPasswordPattern = Pattern.compile("\n\t+var (\\w+) = (PropsUtil.get\\(\"default.admin.password\"\\));");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith(".testcase") || SourceUtil.isXML(content)) {
            return content;
        }
        File file = new File(this.getPortalDir(), "test.properties");
        if (!file.exists()) {
            return content;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return this._checkInlinePassword(fileName, content, properties);
    }

    private String _checkInlinePassword(String fileName, String content, Properties properties) {
        Matcher matcher = _propsUtilGetPasswordPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, StringBundler.concat("Pass '", matcher.group(2), "' directly instead of assigning value to variable '", matcher.group(1), "'"), this.getLineNumber(content, matcher.start()) + 1);
        }
        String password = properties.getProperty("test.portal.default.admin.password");
        if (Validator.isNull(password)) {
            return content;
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("(\\w*[Pp]assword = )\"" + password + "\"");
        matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (this._isInsideTripleQuotes(content, matcher.start())) continue;
            matcher.appendReplacement(sb, matcher.group(1) + "PropsUtil.get(\"default.admin.password\")");
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    private boolean _isInsideTripleQuotes(String content, int pos) {
        String s = content.substring(pos);
        int x = s.indexOf("''';");
        if (x == -1) {
            return false;
        }
        return !(s = s.substring(0, x)).contains("= '''");
    }
}

