/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Fork;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLFork
extends StyleElement {
    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        int foundGroup = 0;
        int foundSequence = 0;
        while ((child = kids.next()) != null) {
            if (child instanceof XSLSequence) {
                ++foundSequence;
                continue;
            }
            if (child instanceof XSLForEachGroup) {
                ++foundGroup;
                continue;
            }
            if (child instanceof XSLFallback) continue;
            this.compileError(child.getDisplayName() + " cannot appear as a child of xsl:fork");
        }
        if (foundGroup > 1) {
            this.compileError("xsl:fork contains more than one xsl:for-each-group instruction");
        }
        if (foundGroup > 0 && foundSequence > 0) {
            this.compileError("Cannot mix xsl:sequence and xsl:for-each-group within xsl:fork");
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, true);
        if (content instanceof Block) {
            return new Fork(((Block)content).getOperanda());
        }
        return content;
    }
}

