/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPFunctionNameCheck
extends BaseFileCheck {
    private static final String _FUNCTION_NAME_REGEX = "^[a-z0-9][_a-zA-Z0-9]*$";
    private static final Pattern _functionPattern = Pattern.compile("[\n\t]function (<.*>)?(\\w+)\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _functionPattern.matcher(content);
        while (matcher.find()) {
            String functionName = matcher.group(2);
            if (functionName.matches(_FUNCTION_NAME_REGEX)) continue;
            this.addMessage(fileName, StringBundler.concat("Function '", functionName, "' much match pattern '", _FUNCTION_NAME_REGEX, "'"), this.getLineNumber(content, matcher.start(2)));
        }
        return content;
    }
}

