/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaRunSqlStylingCheck
extends BaseJavaTermCheck {
    private static final Pattern _runSqlPattern = Pattern.compile("\\brunSQL\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String content = javaTerm.getContent();
        Matcher matcher = _runSqlPattern.matcher(content);
        while (matcher.find()) {
            String runSqlMethodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(runSqlMethodCall);
            if (parameterList.isEmpty() || parameterList.size() != 1) continue;
            String parameter = parameterList.get(0);
            String newParameter = parameter.replaceAll("([\\s\\S]*)?(?<!\\[\\$)\\b(FALSE|TRUE)\\b(?!\\$\\])([\\s\\S]*)", "$1[\\$$2\\$]$3");
            if (newParameter.endsWith(";\"") && !newParameter.endsWith("\";\"")) {
                newParameter = StringUtil.removeLast(newParameter, ";");
            }
            if (parameter.equals(newParameter)) continue;
            return StringUtil.replaceFirst(content, parameter, newParameter, matcher.start());
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

