/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesUpgradeLiferayPluginPackageFileCheck
extends BaseFileCheck {
    private static final Pattern _noEEPattern = Pattern.compile("-noee:\\s*(true|false)\n*");
    private static final Pattern _portalDependencyJarsPattern = Pattern.compile("portal-dependency-jars=\\\\(\n[\t| ]+.+){2,}\n*");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String suffix = "/liferay-plugin-package.properties";
        if (!fileName.endsWith(suffix) || FileUtil.exists(StringUtil.replace(fileName, suffix, "/liferay-look-and-feel.xml"))) {
            return content;
        }
        String upgradeToVersion = this.getAttributeValue("upgrade.to.version", absolutePath);
        if (upgradeToVersion == null) {
            return content;
        }
        return this._formatPluginPackageProperties(content);
    }

    private String _addNoEEProperty(String content) {
        Matcher matcher = _noEEPattern.matcher(content);
        if (matcher.find()) {
            String value = matcher.group(1);
            if (value.equals("false")) {
                content = StringUtil.replace(content, value, "true", matcher.start(1));
            }
        } else {
            content = content + "\n\n-noee: true";
        }
        return content;
    }

    private String _formatPluginPackageProperties(String content) {
        content = this._removePortalDependencyJarsProperty(content);
        content = this._addNoEEProperty(content);
        return content;
    }

    private String _removePortalDependencyJarsProperty(String content) {
        Matcher matcher = _portalDependencyJarsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        return StringUtil.removeSubstring(content, matcher.group(0));
    }
}

