/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.processor.SourceProcessor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CopyrightCheck
extends BaseFileCheck {
    private static final String _XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final Pattern _copyrightPattern = Pattern.compile("[\\+-] \\* SPDX-FileCopyrightText: \\(c\\) (\\d{4}) Liferay, Inc\\. https://liferay\\.com");
    private static List<String> _currentBranchFileNames;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        String gitWorkingBranchName = sourceFormatterArgs.getGitWorkingBranchName();
        if (gitWorkingBranchName.matches("release-\\d{4}\\.q[1-4]")) {
            return content;
        }
        if (!fileName.endsWith(".tpl") && !fileName.endsWith(".vm")) {
            content = this._fixCopyright(fileName, absolutePath, content, sourceFormatterArgs);
        }
        return content;
    }

    private String _fixCopyright(String fileName, String absolutePath, String content, SourceFormatterArgs sourceFormatterArgs) throws Exception {
        int x = content.indexOf("/**\n * SPDX-FileCopyrightText: (c) ");
        if (x == -1) {
            this.addMessage(fileName, "Missing copyright");
            return content;
        }
        String s = content.substring(x + 35, content.indexOf("\n", x + 35));
        if (!s.matches("\\d{4} Liferay, Inc\\. https://liferay\\.com")) {
            this.addMessage(fileName, "Missing copyright");
            return content;
        }
        if (!(content.startsWith("/**\n * SPDX-FileCopyrightText: (c) ") || content.startsWith("<%--\n/**\n * SPDX-FileCopyrightText: (c) ") || content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n/**\n * SPDX-FileCopyrightText: (c) "))) {
            this.addMessage(fileName, "File must start with copyright");
            return content;
        }
        for (String currentBranchRenamedFileName : sourceFormatterArgs.getCurrentBranchRenamedFileNames()) {
            if (!absolutePath.endsWith(currentBranchRenamedFileName)) continue;
            return content;
        }
        for (String currentBranchAddedFileNames : sourceFormatterArgs.getCurrentBranchAddedFileNames()) {
            if (!absolutePath.endsWith(currentBranchAddedFileNames)) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            String currentYear = simpleDateFormat.format(new Date());
            String year = s.substring(0, 4);
            if (!year.equals(currentYear)) {
                return StringUtil.replaceFirst(content, year, currentYear, x + 35);
            }
            return content;
        }
        for (String currentBranchFileName : this._getCurrentBranchFileNames(sourceFormatterArgs)) {
            if (!absolutePath.endsWith(currentBranchFileName)) continue;
            Matcher matcher = _copyrightPattern.matcher(GitUtil.getCurrentBranchFileDiff(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName(), absolutePath));
            ArrayList<String> years = new ArrayList<String>();
            while (matcher.find()) {
                years.add(matcher.group(1));
            }
            if (years.size() != 2) {
                return content;
            }
            if (StringUtil.equals((String)years.get(0), (String)years.get(1))) continue;
            return StringUtil.replaceFirst(content, "SPDX-FileCopyrightText: (c) " + (String)years.get(1) + " Liferay, Inc. https://liferay.com", "SPDX-FileCopyrightText: (c) " + (String)years.get(0) + " Liferay, Inc. https://liferay.com");
        }
        return content;
    }

    private synchronized List<String> _getCurrentBranchFileNames(SourceFormatterArgs sourceFormatterArgs) throws Exception {
        if (_currentBranchFileNames != null) {
            return _currentBranchFileNames;
        }
        _currentBranchFileNames = GitUtil.getCurrentBranchFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName());
        return _currentBranchFileNames;
    }
}

