/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;

@FileStatefulCheck
public final class PackageDeclarationCheck
extends AbstractCheck {
    public static final String MSG_KEY_MISSING = "missing.package.declaration";
    public static final String MSG_KEY_MISMATCH = "mismatch.package.directory";
    private static final int DEFAULT_LINE_NUMBER = 1;
    private boolean defined;
    private boolean matchDirectoryStructure = true;

    public void setMatchDirectoryStructure(boolean matchDirectoryStructure) {
        this.matchDirectoryStructure = matchDirectoryStructure;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{16};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.defined = false;
    }

    @Override
    public void finishTree(DetailAST ast) {
        if (!this.defined) {
            int lineNumber = 1;
            if (ast != null) {
                lineNumber = ast.getLineNo();
            }
            this.log(lineNumber, MSG_KEY_MISSING, new Object[0]);
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.defined = true;
        if (this.matchDirectoryStructure) {
            DetailAST packageNameAst = ast.getLastChild().getPreviousSibling();
            FullIdent fullIdent = FullIdent.createFullIdent(packageNameAst);
            String packageName = fullIdent.getText().replace('.', File.separatorChar);
            String directoryName = this.getDirectoryName();
            if (!directoryName.endsWith(packageName)) {
                this.log(fullIdent.getLineNo(), MSG_KEY_MISMATCH, packageName);
            }
        }
    }

    private String getDirectoryName() {
        String fileName = this.getFileContents().getFileName();
        int lastSeparatorPos = fileName.lastIndexOf(File.separatorChar);
        return fileName.substring(0, lastSeparatorPos);
    }
}

