/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLUpgradeCompatibilityVersionCheck
extends BaseFileCheck {
    private static final Pattern _compatibilityVersionPattern = Pattern.compile("\\s<compatibility>\\s*((<version>.+<\\/version>\\s*)+)\\s<\\/compatibility>");
    private String _upgradeToVersion;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        this._upgradeToVersion = this.getAttributeValue("upgrade.to.version", absolutePath);
        if (this._upgradeToVersion == null || !fileName.endsWith(".xml")) {
            return content;
        }
        return this._checkNewCompatibilityVersion(content);
    }

    private String _checkNewCompatibilityVersion(String content) {
        Matcher matcher = _compatibilityVersionPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String versions = matcher.group(1);
        String[] upgradeToVersionParts = StringUtil.split(this._upgradeToVersion, ".");
        String newVersion = StringBundler.concat("<version>", upgradeToVersionParts[0], ".", upgradeToVersionParts[1], ".0+</version>");
        if (versions.contains(newVersion)) {
            return content;
        }
        return StringUtil.replace(content, versions, newVersion + "\n");
    }
}

