/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.Arrays;
import java.util.List;

public class JSPFileNameCheck
extends BaseFileCheck {
    private static final List<String> _allowedSuffixes = Arrays.asList("-compat", "-ext", "-ext-post", "-ext-pre");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith(".jsp") && !fileName.endsWith(".jspf")) {
            return content;
        }
        int x = absolutePath.lastIndexOf(47);
        int y = absolutePath.lastIndexOf(46);
        String shortFileName = absolutePath.substring(x + 1, y);
        for (String allowedSuffix : _allowedSuffixes) {
            if (!shortFileName.endsWith(allowedSuffix)) continue;
            return content;
        }
        for (Object c : (Object)shortFileName.toCharArray()) {
            if (Character.isLetterOrDigit((char)c) || c == 95) continue;
            this.addMessage(fileName, StringBundler.concat("Do not use '", Character.valueOf((char)c), "' in file name"));
        }
        return content;
    }
}

