/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLTagCheck
extends BaseFileCheck {
    private static final Pattern _assignTagsBlockPattern = Pattern.compile("((\t*)<#assign(.(?!<[#@]))+?/>(\n|$)+){2,}", 40);
    private static final Pattern _incorrectAssignTagPattern = Pattern.compile("(<#assign .*=.*[^/])>(\n|$)");
    private static final Pattern _tagAttributePattern = Pattern.compile("\\s([^\\s=]+)\\s*?=");
    private static final Pattern _tagPattern = Pattern.compile("(\\A|\n)(\t*)<@(\\S[^>]*?)(/?>)(\n|\\Z)", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatTags(content);
        return this._formatAssignTags(content);
    }

    private String _formatAssignTags(String content) {
        Matcher matcher = _incorrectAssignTagPattern.matcher(content);
        content = matcher.replaceAll("$1 />\n");
        matcher = _assignTagsBlockPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String tabs = matcher.group(2);
            String replacement = StringUtil.removeSubstrings(match, "<#assign ", "<#assign\n", "/>");
            replacement = StringUtil.removeChar(replacement, '\t');
            String[] lines = StringUtil.splitLines(replacement);
            StringBundler sb = new StringBundler(3 * lines.length + 5);
            sb.append(tabs);
            sb.append("<#assign");
            for (String line : lines) {
                sb.append("\n\t");
                sb.append(tabs);
                sb.append(line);
            }
            sb.append("\n");
            sb.append(tabs);
            sb.append("/>\n\n");
            content = StringUtil.replace(content, match, sb.toString());
        }
        return content;
    }

    private String _formatTags(String content) {
        Matcher matcher = _tagPattern.matcher(content);
        while (matcher.find()) {
            String replacement;
            String match = matcher.group(3);
            Map<String, String> attributesMap = this._getAttributesMap(match);
            if (attributesMap.isEmpty()) continue;
            String tabs = matcher.group(2);
            String delimeter = " ";
            if (attributesMap.size() > 1) {
                delimeter = "\n" + tabs + "\t";
            }
            StringBundler sb = new StringBundler(attributesMap.size() * 4 + 4);
            sb.append(this._getTagName(match));
            sb.append(delimeter);
            for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(entry.getValue());
                sb.append(delimeter);
            }
            sb.setIndex(sb.index() - 1);
            String closingTag = matcher.group(4);
            if (attributesMap.size() > 1) {
                sb.append("\n");
                sb.append(tabs);
            } else if (closingTag.equals("/>")) {
                sb.append(" ");
            }
            if ((replacement = sb.toString()).equals(match)) continue;
            return StringUtil.replaceFirst(content, match, replacement, matcher.start());
        }
        return content;
    }

    private Map<String, String> _getAttributesMap(String s) {
        TreeMap<String, String> attributesMap = new TreeMap<String, String>();
        String attributeName = null;
        while (true) {
            boolean match = false;
            Matcher matcher = _tagAttributePattern.matcher(s);
            while (matcher.find()) {
                if (ToolsUtil.isInsideQuotes(s, matcher.end() - 1)) continue;
                match = true;
                break;
            }
            if (!match) break;
            if (attributeName != null) {
                attributesMap.put(attributeName, StringUtil.trim(s.substring(0, matcher.start())));
            }
            attributeName = matcher.group(1);
            s = s.substring(matcher.end());
        }
        if (attributeName != null) {
            attributesMap.put(attributeName, StringUtil.trim(s));
        }
        return attributesMap;
    }

    private String _getTagName(String s) {
        StringBundler sb = new StringBundler();
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

