/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeMissingTestCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String className = JavaSourceUtil.getClassName(fileName);
        if (!absolutePath.contains("/upgrade/") || absolutePath.contains("-test/") || className.startsWith("Base") || !this._isUpgradeProcess(absolutePath, content)) {
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        for (String currentBranchRenamedFileName : sourceFormatterArgs.getCurrentBranchRenamedFileNames()) {
            if (!absolutePath.endsWith(currentBranchRenamedFileName)) continue;
            return content;
        }
        for (String currentBranchAddedFileNames : sourceFormatterArgs.getCurrentBranchAddedFileNames()) {
            if (!absolutePath.endsWith(currentBranchAddedFileNames)) continue;
            this._checkMissingTestFile(fileName, absolutePath, content, className);
            return content;
        }
        return content;
    }

    private void _checkMissingTestFile(String fileName, String absolutePath, String content, String className) {
        String expectedTestClassName = null;
        File file = null;
        if (this.isModulesFile(absolutePath)) {
            expectedTestClassName = StringBundler.concat(JavaSourceUtil.getPackageName(content), ".test.", className, "Test");
            file = JavaSourceUtil.getJavaFile(expectedTestClassName, SourceUtil.getRootDirName(absolutePath), this.getBundleSymbolicNamesMap(absolutePath));
        } else if (absolutePath.contains("/portal-impl/") || absolutePath.contains("/portal-kernel/")) {
            expectedTestClassName = StringUtil.replaceFirst(absolutePath, new String[]{"/portal-impl/src/", "/portal-kernel/src/"}, new String[]{"/portal-impl/test/unit/", "/portal-kernel/test/unit/"});
            expectedTestClassName = StringUtil.insert(expectedTestClassName, "Test", expectedTestClassName.length() - 5);
            file = new File(expectedTestClassName);
        }
        if (file == null || !file.exists()) {
            this.addMessage(fileName, "Test class '" + expectedTestClassName + "' does not exist");
        }
    }

    private boolean _isUpgradeProcess(String absolutePath, String content) {
        Pattern pattern = Pattern.compile(" class " + JavaSourceUtil.getClassName(absolutePath) + "\\s+extends\\s+([\\w.]+) ");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return false;
        }
        String extendedClassName = matcher.group(1);
        if (extendedClassName.equals("UpgradeProcess")) {
            return true;
        }
        pattern = Pattern.compile("\nimport (.*\\." + extendedClassName + ");");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            extendedClassName = matcher.group(1);
        }
        if (!extendedClassName.contains(".")) {
            extendedClassName = JavaSourceUtil.getPackageName(content) + "." + extendedClassName;
        }
        if (!extendedClassName.startsWith("com.liferay.")) {
            return false;
        }
        File file = JavaSourceUtil.getJavaFile(extendedClassName, SourceUtil.getRootDirName(absolutePath), this.getBundleSymbolicNamesMap(absolutePath));
        if (file == null) {
            return false;
        }
        return this._isUpgradeProcess(file.getAbsolutePath(), FileUtil.read(file));
    }
}

