/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class JavaServiceObjectCheck
extends BaseJavaTermCheck {
    private static final Pattern _getterCallPattern = Pattern.compile("\\W(\\w+)\\.\\s*(get)([A-Z]\\w*)\\(\\)");
    private static final Pattern _setterCallPattern = Pattern.compile("(\\w+)\\.\\s*set([A-Z]\\w*)\\([^;]+;");
    private static final Pattern _setterCallsPattern = Pattern.compile("(^[ \t]*\\w+\\.\\s*set[A-Z]\\w*\\([^;]+;\n)+", 40);

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        List<String> importNames = this.getImportNames(javaTerm);
        if (importNames.isEmpty()) {
            return javaTerm.getContent();
        }
        String javaTermContent = this._formatGetterMethodCalls(javaTerm, fileContent, fileName, absolutePath, importNames);
        return this._formatSetterMethodCalls(javaTerm, javaTermContent, fileContent, fileName, absolutePath, importNames);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private String _formatGetterMethodCalls(JavaTerm javaTerm, String fileContent, String fileName, String absolutePath, List<String> importNames) throws IOException {
        String content = javaTerm.getContent();
        Matcher matcher = _getterCallPattern.matcher(content);
        while (matcher.find()) {
            String getterObjectName;
            String variableName = matcher.group(1);
            String variableTypeName = this.getVariableTypeName(content, javaTerm, fileContent, fileName, variableName, false, true);
            if (variableTypeName == null || !this._isBooleanColumn(absolutePath, variableTypeName, getterObjectName = TextFormatter.format(matcher.group(3), 8), importNames)) continue;
            return StringUtil.replaceFirst(content, "get", "is", matcher.start(2));
        }
        return content;
    }

    private String _formatSetterMethodCalls(JavaTerm javaTerm, String content, String fileContent, String fileName, String absolutePath, List<String> importNames) throws IOException {
        Matcher matcher1 = _setterCallsPattern.matcher(content);
        block0: while (matcher1.find()) {
            String setterCallsCodeBlock = matcher1.group();
            String previousMatch = null;
            String previousSetterObjectName = null;
            String previousVariableName = null;
            String variableTypeName = null;
            Matcher matcher2 = _setterCallPattern.matcher(setterCallsCodeBlock);
            while (matcher2.find()) {
                String tablesSQLContent;
                File file;
                String tablesSQLFileLocation;
                Element serviceXMLElement;
                String match = matcher2.group();
                String setterObjectName = TextFormatter.format(matcher2.group(2), 8);
                String variableName = matcher2.group(1);
                if (!variableName.equals(previousVariableName)) {
                    previousMatch = match;
                    previousSetterObjectName = setterObjectName;
                    previousVariableName = variableName;
                    variableTypeName = this.getVariableTypeName(content, javaTerm, fileContent, fileName, variableName, false, true);
                    if (variableTypeName != null) continue;
                    continue block0;
                }
                this.populateModelInformations();
                Object[] modelInformation = this.getModelInformation(this._getPackagePath(absolutePath, variableTypeName, importNames));
                if (modelInformation == null || (serviceXMLElement = (Element)modelInformation[0]) == null || Validator.isNull(tablesSQLFileLocation = (String)modelInformation[1]) || !(file = new File(tablesSQLFileLocation)).exists() || (tablesSQLContent = FileUtil.read(file)) == null) continue block0;
                int x = variableTypeName.lastIndexOf(".");
                if (x != -1) {
                    variableTypeName = variableTypeName.substring(x + 1);
                }
                String[] parts = StringUtil.split(this._getTableAndColumName(variableTypeName, previousSetterObjectName, serviceXMLElement), ":");
                int index1 = -1;
                if (parts.length == 2) {
                    index1 = SourceUtil.getColumnIndex(tablesSQLContent, parts[0], parts[1]);
                }
                parts = StringUtil.split(this._getTableAndColumName(variableTypeName, setterObjectName, serviceXMLElement), ":");
                int index2 = -1;
                if (parts.length == 2) {
                    index2 = SourceUtil.getColumnIndex(tablesSQLContent, parts[0], parts[1]);
                }
                if (index2 != -1 && (index1 > index2 || index1 == -1)) {
                    x = matcher2.start();
                    int y = content.lastIndexOf(previousMatch, x);
                    content = StringUtil.replaceFirst(content, match, previousMatch, matcher1.start() + x);
                    return StringUtil.replaceFirst(content, previousMatch, match, matcher1.start() + y);
                }
                previousMatch = match;
                previousSetterObjectName = setterObjectName;
                previousVariableName = variableName;
            }
        }
        return content;
    }

    private String _getPackagePath(String absolutePath, String variableTypeName, List<String> importNames) {
        int x = variableTypeName.lastIndexOf(".");
        if (x != -1) {
            String packageName = variableTypeName.substring(0, x);
            if (packageName.startsWith("com.liferay.") && packageName.endsWith(".model")) {
                return StringUtil.replaceLast(packageName, ".model", "");
            }
            return "";
        }
        for (String importName : importNames) {
            if (!importName.startsWith("com.liferay.") || !importName.endsWith(".model." + variableTypeName)) continue;
            return StringUtil.replaceLast(importName, ".model." + variableTypeName, "");
        }
        if (absolutePath.contains("/portal-impl/")) {
            return "portal-impl";
        }
        return "";
    }

    private String _getTableAndColumName(String variableTypeName, String setterObjectName, Element serviceXMLElement) {
        String tableName = variableTypeName;
        for (Element entityElement : serviceXMLElement.elements("entity")) {
            if (!tableName.equals(entityElement.attributeValue("name"))) continue;
            if (Validator.isNotNull(entityElement.attributeValue("table"))) {
                tableName = entityElement.attributeValue("table");
            }
            String convertedSetterObjectName = setterObjectName.replaceFirst("^(create|modified)Date$", "$1Time");
            convertedSetterObjectName = convertedSetterObjectName.replaceFirst("(.+?)(List|Map|(Unicode)?Properties)$", "$1");
            for (Element columnElement : entityElement.elements("column")) {
                String columnName = columnElement.attributeValue("name");
                if (!StringUtil.equalsIgnoreCase(setterObjectName, columnName) && !StringUtil.equalsIgnoreCase(convertedSetterObjectName, columnName) && (!setterObjectName.equals("className") || !columnName.equals("classNameId"))) continue;
                if (Validator.isNotNull(columnElement.attributeValue("db-name"))) {
                    return tableName + ":" + columnElement.attributeValue("db-name");
                }
                return tableName + ":" + columnName;
            }
        }
        return tableName + ":" + setterObjectName;
    }

    private boolean _isBooleanColumn(String absolutePath, String variableTypeName, String getterObjectName, List<String> importNames) throws IOException {
        Element serviceXMLElement;
        this.populateModelInformations();
        Object[] modelInformation = this.getModelInformation(this._getPackagePath(absolutePath, variableTypeName, importNames));
        if (modelInformation == null) {
            return false;
        }
        int x = variableTypeName.lastIndexOf(".");
        if (x != -1) {
            variableTypeName = variableTypeName.substring(x + 1);
        }
        if ((serviceXMLElement = (Element)modelInformation[0]) == null) {
            return false;
        }
        for (Element entityElement : serviceXMLElement.elements("entity")) {
            if (!variableTypeName.equals(entityElement.attributeValue("name"))) continue;
            for (Element columnElement : entityElement.elements("column")) {
                if (!getterObjectName.equals(columnElement.attributeValue("name")) || !Objects.equals(columnElement.attributeValue("type"), "boolean")) continue;
                return true;
            }
        }
        return false;
    }
}

