/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseStylingCheck;
import com.liferay.source.formatter.check.util.JsonSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLStylingCheck
extends BaseStylingCheck {
    private static final Pattern _assignPattern = Pattern.compile("\n(\t*)\\w+ =(\\s*\\{)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatAssignBlock(content);
        return this.formatStyling(content);
    }

    private String _formatAssignBlock(String content) {
        int x = -1;
        block0: while ((x = content.indexOf("<#assign\n", x + 1)) != -1) {
            int y = x;
            while ((y = content.indexOf("/>", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(content, y)) continue;
                String assignContent = content.substring(x += 8, y);
                int level = this.getLevel(assignContent, new String[]{"{", "("}, new String[]{"}", ")"});
                if (level != 0) continue;
                String newAssignContent = this._formatJsonAssign(assignContent);
                if (assignContent.equals(newAssignContent)) continue block0;
                return StringUtil.replace(content, assignContent, newAssignContent, x);
            }
        }
        return content;
    }

    private String _formatJsonAssign(String content) {
        Matcher matcher = _assignPattern.matcher(content);
        while (matcher.find()) {
            String s;
            int level;
            int x = matcher.end();
            while ((x = content.indexOf("}\n", x + 1)) == -1 || ToolsUtil.isInsideQuotes(content, x) || (level = this.getLevel(s = content.substring(matcher.start(2), x + 2), "{", "}")) != 0) {
            }
            JSONObject jsonObject = JsonSourceUtil.getJSONObject(s);
            if (jsonObject == null) continue;
            String indent = matcher.group(1);
            StringBundler sb = new StringBundler(2);
            sb.append("\n");
            sb.append(JsonSourceUtil.fixIndentation(jsonObject, indent + "\t"));
            String replacement = sb.toString();
            if (s.equals(replacement)) continue;
            return StringUtil.replace(content, s, replacement, matcher.start(2));
        }
        return content;
    }
}

