/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class OperatorOperandCheck
extends BaseCheck {
    private static final String _MSG_IMPROVE_READABILITY = "readability.improve";

    public int[] getDefaultTokens() {
        return ArrayUtil.append(ARITHMETIC_OPERATOR_TOKEN_TYPES, RELATIONAL_OPERATOR_TOKEN_TYPES);
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this._isInsideGlobalVariableDefinition(detailAST)) {
            return;
        }
        this._checkOperand(detailAST, detailAST.getFirstChild(), "left");
        if (ArrayUtil.contains(ARITHMETIC_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            this._checkOperand(detailAST, detailAST.getLastChild(), "right");
        }
    }

    private void _checkOperand(DetailAST operatorDetailAST, DetailAST detailAST, String side) {
        DetailAST parentDetailAST;
        if (detailAST == null) {
            return;
        }
        DetailAST exprDetailAST = this.getParentWithTokenType(detailAST, 28);
        if (exprDetailAST != null && (parentDetailAST = exprDetailAST.getParent()).getType() == 84) {
            return;
        }
        if (detailAST.getType() == 76) {
            DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()).getType() == 77 && detailAST.getLineNo() != nextSiblingDetailAST.getLineNo()) {
                this.log(detailAST, _MSG_IMPROVE_READABILITY, new Object[]{side, operatorDetailAST.getText()});
            }
            return;
        }
        if (detailAST.getType() == 77) {
            DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
            if ((previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()).getType() == 76 && detailAST.getLineNo() != previousSiblingDetailAST.getLineNo()) {
                this.log(detailAST, _MSG_IMPROVE_READABILITY, new Object[]{side, operatorDetailAST.getText()});
            }
            return;
        }
        if (detailAST.getType() != 27) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        if (!methodCallDetailASTList.isEmpty()) {
            detailAST = methodCallDetailASTList.get(methodCallDetailASTList.size() - 1);
        }
        if (this.isAtLineEnd(detailAST, this.getLine(detailAST.getLineNo() - 1))) {
            this.log(detailAST, _MSG_IMPROVE_READABILITY, new Object[]{side, operatorDetailAST.getText()});
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 59 && this.isAtLineEnd(firstChildDetailAST, this.getLine(firstChildDetailAST.getLineNo() - 1))) {
            this.log(firstChildDetailAST, _MSG_IMPROVE_READABILITY, new Object[]{side, operatorDetailAST.getText()});
        }
    }

    private boolean _isInsideGlobalVariableDefinition(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (parentDetailAST.getType() == 14 || parentDetailAST.getType() == 154 || parentDetailAST.getType() == 15) {
                return true;
            }
            if (parentDetailAST.getType() == 8 || parentDetailAST.getType() == 9) {
                return false;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }
}

