/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class PoshiVariableNameCheck
extends BaseFileCheck {
    private static final String[][] _ALL_CAPS_STRINGS = new String[][]{{"DDL", "Ddl"}, {"DDM", "Ddm"}, {"DL", "Dl"}, {"PK", "Pk"}, {"URL", "Url"}};
    private static final Pattern _variableReferencePattern = Pattern.compile("(\\$\\{)([a-zA-Z0-9_]+?)(\\})");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException, PoshiScriptParserException {
        if (fileName.endsWith(".path")) {
            Matcher matcher = _variableReferencePattern.matcher(content);
            while (matcher.find()) {
                this._checkVariableName(fileName, "", "", matcher.group(2));
            }
            return content;
        }
        if (SourceUtil.isXML(content)) {
            return content;
        }
        File file = new File(fileName);
        PoshiElement poshiElement = (PoshiElement)PoshiNodeFactory.newPoshiNodeFromFile(FileUtil.getURL(file));
        String poshiElementSyntax = Dom4JUtil.format((Element)poshiElement);
        Document document = SourceUtil.readXML(poshiElementSyntax);
        if (document == null) {
            return content;
        }
        this._parsePoshiElements(fileName, "", document.getRootElement());
        return content;
    }

    private void _checkVariableName(String fileName, String commandName, String executeName, String variableName) {
        char firstChar;
        if (Validator.isNull(variableName)) {
            return;
        }
        String message = commandName;
        if (Validator.isNotNull(executeName)) {
            message = message + "#" + executeName;
        }
        if (!Character.isLowerCase(firstChar = variableName.charAt(0))) {
            this.addMessage(fileName, StringBundler.concat("Variable '", variableName, "' in '", message, "' should start with a lowercase letter"));
            return;
        }
        String allCapsName = this._getAllCapsName(variableName);
        if (!variableName.equals(allCapsName)) {
            this.addMessage(fileName, StringBundler.concat("Rename variable '", variableName, "' to '", allCapsName, "' in '", message));
            return;
        }
        String expectedName = this._getExpectedName(variableName);
        if (!variableName.equals(expectedName)) {
            this.addMessage(fileName, StringBundler.concat("Rename variable '", variableName, "' to '", expectedName, "' in '", message));
        }
    }

    private String _getAllCapsName(String variableName) {
        for (String[] array : _ALL_CAPS_STRINGS) {
            String s = array[1];
            int x = -1;
            while ((x = variableName.indexOf(s, x + 1)) != -1) {
                int y = x + s.length();
                if (y != variableName.length() && !Character.isUpperCase(variableName.charAt(y))) continue;
                return variableName.substring(0, x) + array[0] + variableName.substring(y);
            }
        }
        return variableName;
    }

    private String _getExpectedName(String variableName) {
        String[] words = StringUtil.split(variableName, "_");
        String expectedName = "";
        for (String word : words) {
            char secondChar;
            char firstChar = word.charAt(0);
            expectedName = !Character.isUpperCase(firstChar) ? expectedName + word + "_" : (!Character.isUpperCase(secondChar = word.charAt(1)) ? StringBundler.concat(expectedName, Character.valueOf(Character.toLowerCase(firstChar)), word.substring(1), "_") : expectedName + word + "_");
        }
        return expectedName.substring(0, expectedName.length() - 1);
    }

    private void _parsePoshiElements(String fileName, String commandName, Element parentElement) {
        List elements = parentElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("command")) {
                commandName = element.attributeValue("name");
            } else if (elementName.equals("return") || elementName.equals("var")) {
                Element variableParentElement = element.getParent();
                String variableParentElementName = variableParentElement.getName();
                String executeName = "";
                if (variableParentElementName.equals("execute")) {
                    String methodName;
                    String className = variableParentElement.attributeValue("class");
                    executeName = Objects.equals(className, methodName = variableParentElement.attributeValue("method")) ? className : className + "." + methodName;
                }
                this._checkVariableName(fileName, commandName, executeName, element.attributeValue("name"));
            }
            this._parsePoshiElements(fileName, commandName, element);
        }
    }
}

