/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.processor;

import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.processor.BaseSourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.ModulesPropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected void postFormat() throws IOException {
        if (!this._checkModulesPropertiesFile()) {
            return;
        }
        File modulesPropertiesFile = new File(this.getPortalDir(), "modules/modules.properties");
        String newContent = ModulesPropertiesUtil.getContent(this.getPortalDir());
        String oldContent = FileUtil.read(modulesPropertiesFile);
        if (!oldContent.equals(newContent)) {
            FileUtil.write(modulesPropertiesFile, newContent);
            System.out.println("Updated 'modules.properties'");
        }
    }

    private boolean _checkModulesPropertiesFile() {
        if (!this.isPortalSource()) {
            return false;
        }
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        List<String> fileExtensions = sourceFormatterArgs.getFileExtensions();
        return fileExtensions.contains("bnd");
    }
}

