/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStringBundlerConcatCheck
extends BaseJavaTermCheck {
    private static final Pattern _stringBundlerConcatPattern = Pattern.compile("StringBundler\\.concat\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        List<String> imports = this.getImportNames(javaTerm);
        boolean hasPetraStringStringBundler = imports.contains("com.liferay.petra.string.StringBundler");
        String javaTermContent = javaTerm.getContent();
        Matcher matcher = _stringBundlerConcatPattern.matcher(javaTermContent);
        while (matcher.find()) {
            String stringBundlerConcatMethodCall;
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(javaTermContent, matcher.start() + 1) || (parameterList = JavaSourceUtil.getParameterList(stringBundlerConcatMethodCall = JavaSourceUtil.getMethodCall(javaTermContent, matcher.start()))).size() == 1 && javaTermContent.indexOf("... " + parameterList.get(0)) != -1) continue;
            if (parameterList.size() < 3) {
                this.addMessage(fileName, "Do not use 'StringBundler.concat' when concatenating less than 3 elements", javaTerm.getLineNumber(matcher.start()));
            }
            if (!hasPetraStringStringBundler) continue;
            for (String parameter : parameterList) {
                String newParameter;
                if (StringUtil.equals(parameter, newParameter = this._removeUnnecessaryTypeCast(parameter))) continue;
                String newStringBundlerConcatMethodCall = StringUtil.replaceFirst(stringBundlerConcatMethodCall, parameter, newParameter);
                return StringUtil.replace(javaTermContent, stringBundlerConcatMethodCall, newStringBundlerConcatMethodCall, matcher.start());
            }
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private String _removeUnnecessaryTypeCast(String parameter) {
        String stringValueOfMethodCall;
        List<String> parameterList;
        if (parameter.startsWith("String.valueOf(") && (parameterList = JavaSourceUtil.getParameterList(stringValueOfMethodCall = JavaSourceUtil.getMethodCall(parameter, 0))).size() == 1) {
            return parameterList.get(0);
        }
        if (parameter.endsWith(".toString()") && !StringUtil.equals(parameter, "super.toString()")) {
            return parameter.substring(0, parameter.lastIndexOf(".toString()"));
        }
        return parameter;
    }
}

