/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.PythonImportPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonImportsFormatter
extends BaseImportsFormatter {
    private static final Pattern _importPattern = Pattern.compile("([ \t]*)from (.*) import (.*)");

    protected static List<String> getImportsList(String content, Pattern importPattern) {
        ArrayList<String> importsList = new ArrayList<String>();
        Matcher matcher = importPattern.matcher(content);
        while (matcher.find()) {
            importsList.add(matcher.group());
        }
        return importsList;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        return this._createPythonImportPackage(line);
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packageDir, String className) throws IOException {
        List<String> importsList = PythonImportsFormatter.getImportsList(content, importPattern);
        for (String imports : importsList) {
            content = this.doFormat(content, packageDir, className, imports);
        }
        return content;
    }

    protected String doFormat(String content, String packageDir, String className, String imports) throws IOException {
        if (Validator.isNull(imports)) {
            return content;
        }
        String newImports = this._mergeImports(imports);
        newImports = this.sortAndGroupImports(newImports);
        if (!imports.equals(newImports = this._splitImports(newImports))) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        return content;
    }

    private ImportPackage _createPythonImportPackage(String line) {
        Matcher matcher = _importPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String packageName = matcher.group(2);
        return new PythonImportPackage(packageName, line);
    }

    private String _mergeImports(String imports) {
        imports = imports.replaceAll("\\\\\n", "");
        TreeMap packageImportsMap = new TreeMap();
        Matcher matcher = _importPattern.matcher(imports);
        String indent = null;
        while (matcher.find()) {
            if (indent == null) {
                indent = matcher.group(1);
            }
            ArrayList<String> importNamesList = new ArrayList<String>();
            String importNames = matcher.group(3);
            for (String importName : importNames.split(",")) {
                importNamesList.add(importName.trim());
            }
            String packageName = matcher.group(2);
            if (packageImportsMap.containsKey(packageName)) {
                importNamesList.addAll((Collection)packageImportsMap.get(packageName));
            }
            packageImportsMap.put(packageName, importNamesList);
        }
        if (MapUtil.isEmpty(packageImportsMap)) {
            return imports;
        }
        StringBundler sb = new StringBundler(packageImportsMap.size() * 6);
        for (Map.Entry entry : packageImportsMap.entrySet()) {
            sb.append(indent);
            sb.append("from ");
            sb.append((String)entry.getKey());
            sb.append(" import ");
            List importNamesList = (List)entry.getValue();
            Collections.sort(importNamesList);
            sb.append(ListUtil.toString(importNamesList, "", ", "));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _splitImports(String imports) {
        String[] newImports = imports.split("\n");
        StringBundler sb = new StringBundler(newImports.length * 2);
        for (String newImport : newImports) {
            String indent = newImport.replaceFirst("(\t*).*", "$1");
            sb.append(newImport.replaceAll(", ", ", \\\\\n\t" + indent));
            sb.append("\n");
        }
        return sb.toString();
    }
}

