/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;

public class JIRAUtil {
    public static void validateJIRAProjectNames(List<String> commitMessages, List<String> projectNames) throws Exception {
        if (projectNames.isEmpty()) {
            return;
        }
        block0: for (String commitMessage : commitMessages) {
            if (commitMessage.startsWith("Revert ") || commitMessage.startsWith("artifact:ignore") || commitMessage.startsWith("build.gradle auto SF") || commitMessage.endsWith("/ci-merge.")) continue;
            for (String projectName : projectNames) {
                if (!commitMessage.startsWith(projectName)) continue;
                continue block0;
            }
            throw new Exception(StringBundler.concat("Found formatting issues:\n", "At least one commit message is missing a reference to a ", "required JIRA project: ", StringUtil.merge(projectNames, ", "), ". Please verify that the JIRA project keys are specified", "in source-formatter.properties in the liferay-portal ", "repository."));
        }
    }
}

