/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeSetResultsSetTotalMethodCheck
extends BaseFileCheck {
    private static final Pattern _setResultsPattern = Pattern.compile("\\w+\\.setResults\\(");
    private static final Pattern _setTotalPattern = Pattern.compile("(\\s*)\\w+\\.setTotal\\([^;]+;");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!(fileName.endsWith(".java") || fileName.endsWith(".jsp") || fileName.endsWith(".jspf"))) {
            return content;
        }
        content = this._removeSetTotal(content);
        content = this._replaceSetResults(content);
        return content;
    }

    private String _removeSetTotal(String content) {
        String newContent = content;
        Matcher setTotalMatcher = _setTotalPattern.matcher(content);
        while (setTotalMatcher.find()) {
            if (!this.hasClassOrVariableName("SearchContainer", content, content, JavaSourceUtil.getMethodCall(content, setTotalMatcher.start()))) continue;
            newContent = StringUtil.removeSubstring(newContent, setTotalMatcher.group());
        }
        return newContent;
    }

    private String _replaceSetResults(String content) {
        String newContent = content;
        Matcher setResultsMatcher = _setResultsPattern.matcher(content);
        while (setResultsMatcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(content, setResultsMatcher.start());
            if (!this.hasClassOrVariableName("SearchContainer", content, content, methodCall)) continue;
            newContent = StringUtil.replace(newContent, methodCall, StringUtil.replace(methodCall, ".setResults(", ".setResultsAndTotal("));
        }
        return newContent;
    }
}

