/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeSCSSNodeSassPatternsCheck
extends BaseUpgradeCheck {
    private static final Pattern _divisionPattern = Pattern.compile("(\\$\\w+|[0-9.]+)\\s*\\/\\s*(\\$\\w+|[0-9.]+)");
    private static final Pattern _interpolationPattern = Pattern.compile("([\\w-\\.]+)\\#\\{([\\w\\.\\$\\(\\), \\&]+)\\}([\\w-\\.\\#\\{\\.\\$\\(\\)\\}]*)");

    @Override
    protected String format(String fileName, String absolutePath, String content) {
        String newContent = content;
        Matcher divisionMatcher = _divisionPattern.matcher(content);
        boolean replaced = false;
        while (divisionMatcher.find()) {
            StringBuilder sb = new StringBuilder();
            sb.append("math.div(");
            sb.append(divisionMatcher.group(1));
            sb.append(", ");
            sb.append(divisionMatcher.group(2));
            sb.append(")");
            newContent = StringUtil.replace(newContent, divisionMatcher.group(), sb.toString());
            replaced = true;
        }
        if (replaced) {
            newContent = StringBundler.concat("@use \"sass:math\";", "\n", newContent);
        }
        Matcher interpolationMatcher = _interpolationPattern.matcher(content);
        while (interpolationMatcher.find()) {
            String newInterpolation = this._formatInterpolation(interpolationMatcher);
            newContent = StringUtil.replace(newContent, interpolationMatcher.group(), newInterpolation);
        }
        return newContent;
    }

    @Override
    protected String[] getValidExtensions() {
        return new String[]{"scss"};
    }

    private String _formatInterpolation(Matcher matcher) {
        StringBuilder sb = new StringBuilder();
        sb.append("#{'");
        sb.append(matcher.group(1));
        sb.append("' + ");
        sb.append(matcher.group(2));
        String interpolation = matcher.group(3);
        if (!interpolation.isEmpty()) {
            if (interpolation.contains("#{")) {
                String variableName = StringUtil.replace(interpolation, "#{", "' + ");
                sb.append(" + '");
                sb.append(variableName);
            } else {
                sb.append(" + '");
                sb.append(interpolation);
                sb.append("'}");
            }
        } else {
            sb.append("}");
        }
        return sb.toString();
    }
}

