/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradePortletDisplayCheck
extends BaseUpgradeCheck {
    private static final Pattern _getPortletInstanceConfigurationPattern = Pattern.compile("\\t*(\\w+)(.\\s*getPortletInstanceConfiguration\\()");
    private static final Pattern _themeDisplayPattern = Pattern.compile("ThemeDisplay\\s*(\\w+)");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        String newContent = content;
        if (fileName.endsWith(".jsp")) {
            Matcher getPortletInstanceConfigurationMatcher = _getPortletInstanceConfigurationPattern.matcher(content);
            if (getPortletInstanceConfigurationMatcher.find()) {
                return this._getNewContent(newContent, fileName, getPortletInstanceConfigurationMatcher, content, "themeDisplay");
            }
        } else {
            JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
            for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
                if (!childJavaTerm.isJavaMethod()) continue;
                JavaMethod javaMethod = (JavaMethod)childJavaTerm;
                String javaMethodContent = javaMethod.getContent();
                Matcher getPortletInstanceConfigurationMatcher = _getPortletInstanceConfigurationPattern.matcher(javaMethodContent);
                while (getPortletInstanceConfigurationMatcher.find()) {
                    Matcher themeDisplayMatcher = _themeDisplayPattern.matcher(javaMethodContent);
                    if (themeDisplayMatcher.find()) {
                        newContent = this._getNewContent(javaMethodContent, fileName, getPortletInstanceConfigurationMatcher, newContent, themeDisplayMatcher.group(1));
                        continue;
                    }
                    newContent = this._getNewContent(javaMethodContent, fileName, getPortletInstanceConfigurationMatcher, newContent, getPortletInstanceConfigurationMatcher.group(1) + ".getThemeDisplay()");
                }
            }
        }
        return newContent;
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.portal.configuration.module.configuration.ConfigurationProviderUtil"};
    }

    @Override
    protected String[] getValidExtensions() {
        return new String[]{"java", "jsp"};
    }

    private String _getNewContent(String content, String fileName, Matcher matcher, String newContent, String newParameters) {
        String methodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
        String variableName = this.getVariableName(methodCall);
        if (!this.hasClassOrVariableName("PortletDisplay", newContent, fileName, methodCall) && !variableName.contains("portletDisplay")) {
            return newContent;
        }
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        if (parameterList.size() > 1) {
            return newContent;
        }
        String indent = JavaSourceUtil.getIndent(methodCall);
        return StringUtil.replace(newContent, content, StringUtil.replace(content, methodCall, JavaSourceUtil.addMethodNewParameters(indent, new int[]{parameterList.size()}, indent + "ConfigurationProviderUtil.getPortletInstanceConfiguration(", new String[]{newParameters}, parameterList)));
    }
}

