/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.PropertyValueComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class PropertiesSourceFormatterFileCheck
extends BaseFileCheck {
    private static final Pattern _checkPropertyPattern = Pattern.compile("\n\\s*#?(checkstyle|source\\.check)\\.(.*\\.check)\\.");
    private static List<String> _sourceFormatterProperties;
    private Boolean _hasPrivateAppsDir;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!absolutePath.endsWith("/source-formatter.properties")) {
            return content;
        }
        content = this._fixCheckProperties(content);
        this._checkCheckstylePropertiesGroupAndOrder(fileName, content, "checkstyle.");
        this._checkSourceCheckPropertiesGroupAndOrder(fileName, content, "source.check.");
        this._checkPropertiesOrder(fileName, absolutePath, content);
        return this._formatSourceFormatterProperties(fileName, content);
    }

    private void _checkCheckstylePropertiesGroupAndOrder(String fileName, String content, String prefix) {
        String properties = this._getProperites(content, prefix);
        if (properties == null) {
            return;
        }
        this._checkPropertiesGroupAndOrder(fileName, prefix, properties);
    }

    private void _checkPropertiesGroupAndOrder(String fileName, String prefix, String content) {
        String previousPropertyKey = "";
        for (String line : content.split("\n")) {
            String propertyKey = this._getPropertyKey(line);
            if (propertyKey == null) continue;
            if (!StringUtil.startsWith(propertyKey, prefix)) {
                this.addMessage(fileName, StringBundler.concat("Property '", propertyKey, "' should not be in the group for '", prefix, "*'"));
                return;
            }
            if (Validator.isNotNull(previousPropertyKey) && previousPropertyKey.compareToIgnoreCase(propertyKey) > 0) {
                this.addMessage(fileName, StringBundler.concat("Incorrect order of properties: '", propertyKey, "' should come before '", previousPropertyKey, "'"));
                return;
            }
            previousPropertyKey = propertyKey;
        }
    }

    private void _checkPropertiesOrder(String fileName, String absolutePath, String content) throws Exception {
        String rootDirName;
        int pos = absolutePath.lastIndexOf(47);
        String fileLocation = fileName.substring(0, pos);
        if (fileLocation.equals(rootDirName = SourceUtil.getRootDirName(absolutePath))) {
            return;
        }
        List<String> sourceFormatterProperties = this._getSourceFormatterProperties();
        if (ListUtil.isEmpty(sourceFormatterProperties)) {
            return;
        }
        int previousPropertyPosition = -1;
        String propertyKey = null;
        String previousPropertyKey = null;
        for (String line : content.split("\n")) {
            propertyKey = this._getPropertyKey(line);
            if (propertyKey == null || (pos = sourceFormatterProperties.indexOf(propertyKey)) == -1) continue;
            if (previousPropertyPosition != -1 && pos < previousPropertyPosition) {
                this.addMessage(fileName, StringBundler.concat("Incorrect order of properties: '", propertyKey, "' should come before '", previousPropertyKey, "', see the order in ", rootDirName, "/source-formatter.properties"));
                return;
            }
            previousPropertyKey = propertyKey;
            previousPropertyPosition = pos;
        }
    }

    private void _checkSourceCheckPropertiesGroupAndOrder(String fileName, String content, String prefix) {
        String properties = this._getProperites(content, prefix);
        if (properties == null) {
            return;
        }
        this._checkPropertiesGroupAndOrder(fileName, prefix, properties);
    }

    private String _fixCheckProperties(String content) throws Exception {
        Matcher matcher = _checkPropertyPattern.matcher(content);
        while (matcher.find()) {
            List<String> checkNames = null;
            checkNames = Objects.equals(matcher.group(1), "checkstyle") ? this._getCheckstyleCheckNames() : this._getSourceCheckCheckNames();
            String match = matcher.group(2);
            String formattedMatch = StringUtil.removeChar(match, '.');
            for (String checkName : checkNames) {
                if (!StringUtil.equalsIgnoreCase(checkName, formattedMatch)) continue;
                return StringUtil.replaceFirst(content, match, checkName, matcher.start());
            }
        }
        return content;
    }

    private String _formatSourceFormatterProperties(String fileName, String content) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            if (Validator.isNull(value)) continue;
            List<String> propertyValues = ListUtil.fromString(value, ",");
            if (propertyValues.size() > 1) {
                content = this._sortPropertyValues(content, key, propertyValues);
            }
            if (!key.endsWith("excludes") && !key.endsWith("FileNames")) continue;
            for (String propertyFileName : propertyValues) {
                File file;
                if (propertyFileName.contains("*") || propertyFileName.endsWith("-ext.properties") || this.isPortalSource() && !this._hasPrivateAppsDir() && this.isModulesApp(propertyFileName, true)) continue;
                int pos = propertyFileName.indexOf(64);
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if ((pos = propertyFileName.indexOf("->")) != -1) {
                    propertyFileName = propertyFileName.substring(pos + 2);
                }
                if ((file = this.getFile(propertyFileName, this.getMaxDirLevel())) != null) continue;
                this.addMessage(fileName, "Property value '" + propertyFileName + "' points to file that does not exist");
            }
        }
        return content;
    }

    private List<String> _getCheckstyleCheckNames() throws Exception {
        Element element = this._getRootElement("checkstyle.xml");
        if (element == null) {
            return Collections.emptyList();
        }
        return this._getCheckstyleCheckNames(element);
    }

    private List<String> _getCheckstyleCheckNames(Element moduleElement) {
        ArrayList<String> checkstyleCheckNames = new ArrayList<String>();
        String checkName = moduleElement.attributeValue("name");
        int x = checkName.lastIndexOf(46);
        if (x != -1) {
            checkstyleCheckNames.add(checkName.substring(x + 1));
        } else {
            checkstyleCheckNames.add(checkName);
        }
        for (Element childModuleElement : moduleElement.elements("module")) {
            checkstyleCheckNames.addAll(this._getCheckstyleCheckNames(childModuleElement));
        }
        return checkstyleCheckNames;
    }

    private String _getProperites(String content, String prefix) {
        int x = content.indexOf("    " + prefix);
        if (x == -1) {
            return null;
        }
        int y = content.lastIndexOf("    " + prefix);
        y = content.indexOf("=", y + 1);
        return content.substring(x, y + 1);
    }

    private String _getPropertyKey(String line) {
        String trimmedLine = line.trim();
        if (Validator.isNull(trimmedLine) || trimmedLine.startsWith("#")) {
            return null;
        }
        int x = trimmedLine.indexOf(61);
        if (x == -1) {
            return null;
        }
        return trimmedLine.substring(0, x);
    }

    private Element _getRootElement(String fileName) throws Exception {
        ClassLoader classLoader = PropertiesSourceFormatterFileCheck.class.getClassLoader();
        if (classLoader == null) {
            return null;
        }
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            return null;
        }
        String content = StringUtil.read(inputStream);
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return null;
        }
        return document.getRootElement();
    }

    private List<String> _getSourceCheckCheckNames() throws Exception {
        ArrayList<String> sourceCheckCheckNames = new ArrayList<String>();
        Element rootElement = this._getRootElement("sourcechecks.xml");
        if (rootElement == null) {
            return sourceCheckCheckNames;
        }
        for (Element sourceProcessorElement : rootElement.elements("source-processor")) {
            for (Element checkElement : sourceProcessorElement.elements("check")) {
                sourceCheckCheckNames.add(checkElement.attributeValue("name"));
            }
        }
        return sourceCheckCheckNames;
    }

    private synchronized List<String> _getSourceFormatterProperties() throws Exception {
        if (_sourceFormatterProperties != null) {
            return _sourceFormatterProperties;
        }
        File file = new File(this.getPortalDir() + "/source-formatter.properties");
        String content = FileUtil.read(file);
        if (content == null) {
            return Collections.emptyList();
        }
        _sourceFormatterProperties = new ArrayList<String>();
        for (String line : content.split("\n")) {
            String propertyKey = this._getPropertyKey(line);
            if (propertyKey == null) continue;
            _sourceFormatterProperties.add(propertyKey);
        }
        return _sourceFormatterProperties;
    }

    private synchronized boolean _hasPrivateAppsDir() {
        if (this._hasPrivateAppsDir != null) {
            return this._hasPrivateAppsDir;
        }
        this._hasPrivateAppsDir = false;
        if (this.isPortalSource()) {
            return this._hasPrivateAppsDir;
        }
        File dxpAppsDir = this.getFile("modules/dxp/apps", this.getMaxDirLevel());
        if (dxpAppsDir != null) {
            this._hasPrivateAppsDir = true;
            return this._hasPrivateAppsDir;
        }
        File privateAppsDir = this.getFile("modules/private/apps", this.getMaxDirLevel());
        if (privateAppsDir != null) {
            this._hasPrivateAppsDir = true;
        }
        return this._hasPrivateAppsDir;
    }

    private String _sortPropertyValues(String content, String propertyKey, List<String> propertyValues) {
        PropertyValueComparator comparator = new PropertyValueComparator();
        for (int i = 0; i < propertyValues.size() - 1; ++i) {
            String nextPropertyValue;
            String propertyValue = propertyValues.get(i);
            if (comparator.compare(propertyValue, nextPropertyValue = propertyValues.get(i + 1)) <= 0) continue;
            return this._swapValues(content, propertyKey, propertyValue, nextPropertyValue);
        }
        return content;
    }

    private String _swapValues(String content, int x, String s1, String s2) {
        char c;
        do {
            if ((x = content.indexOf(s1, x + 1)) != -1) continue;
            return content;
        } while (!Character.isWhitespace(c = content.charAt(x - 1)) && c != '=' && c != ',' || x + s1.length() < content.length() && !Character.isWhitespace(c = content.charAt(x + s1.length())) && c != ',');
        return StringUtil.replaceFirst(content, s1, s2, x);
    }

    private String _swapValues(String content, String propertyKey, String propertyValue, String nextPropertyValue) {
        int x = -1;
        do {
            if ((x = content.indexOf(propertyKey + "=")) != -1) continue;
            return content;
        } while (x != 0 && !Character.isWhitespace(content.charAt(x - 1)));
        content = this._swapValues(content, x, nextPropertyValue, propertyValue);
        content = this._swapValues(content, x, propertyValue, nextPropertyValue);
        return content;
    }
}

