/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstanceInitializerCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_ASSIGN_ORDER = "assign.order.incorrect";
    private static final String _MSG_INCORRECT_METHOD_CALL_ORDER = "method.call.order.incorrect";
    private static final String _MSG_INLINE_IF_STATEMENT = "if.statement.inline";
    private static final String _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL = "assign.move.before.method.call";
    private static final String _MSG_USE_ASSIGN_INSTEAD = "assign.use.instead";
    private static final String _MSG_USE_SET_METHOD_INSTEAD = "set.method.use.instead";
    private static final Log _log = LogFactoryUtil.getLog(InstanceInitializerCheck.class);
    private volatile Map<String, String> _bundleSymbolicNamesMap;
    private volatile String _rootDirName;

    public int[] getDefaultTokens() {
        return new int[]{11};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 7) {
            return;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(firstChildDetailAST, false, 28);
        if (exprDetailASTList.size() >= 2) {
            this._checkAttributeOrder(exprDetailASTList);
        }
        JavaClass javaClass = null;
        try {
            javaClass = this._getJavaClass(detailAST, parentDetailAST);
        }
        catch (ParseException | IOException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return;
        }
        if (javaClass == null) {
            return;
        }
        this._checkSetCall(firstChildDetailAST, exprDetailASTList, javaClass);
        for (DetailAST literalIfDetailAST : this.getAllChildTokens(firstChildDetailAST, false, 83)) {
            this._checkIfStatement(literalIfDetailAST, javaClass);
        }
    }

    private void _checkAttributeOrder(List<DetailAST> exprDetailASTList) {
        String previousVariableName = null;
        String previousMethodName = null;
        for (DetailAST exprDetailAST : exprDetailASTList) {
            String methodName;
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 80) {
                String variableName = this.getName(firstChildDetailAST);
                if (Validator.isNotNull(this.getTypeName(this.getVariableTypeDetailAST(firstChildDetailAST, variableName, false), false))) continue;
                if (previousVariableName != null && previousVariableName.compareToIgnoreCase(variableName) > 0) {
                    this.log(exprDetailAST, _MSG_INCORRECT_ASSIGN_ORDER, new Object[]{variableName, previousVariableName, firstChildDetailAST.getLineNo()});
                } else if (Validator.isNotNull(previousMethodName)) {
                    this.log(exprDetailAST, _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL, new Object[]{variableName, previousMethodName, firstChildDetailAST.getLineNo()});
                }
                previousVariableName = variableName;
                continue;
            }
            if (firstChildDetailAST.getType() != 27 || Validator.isNull(methodName = this.getName(firstChildDetailAST)) || !methodName.matches("set[A-Z].+")) continue;
            if (previousMethodName != null && previousMethodName.compareToIgnoreCase(methodName) > 0) {
                this.log(exprDetailAST, _MSG_INCORRECT_METHOD_CALL_ORDER, new Object[]{methodName, previousMethodName, firstChildDetailAST.getLineNo()});
            }
            previousMethodName = methodName;
        }
    }

    private void _checkHasReplacableMethodSignature(DetailAST detailAST, String methodName, JavaClass javaClass) {
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            JavaParameter javaParameter;
            String parameterType;
            JavaSignature javaSignature;
            List<JavaParameter> javaParameters;
            JavaMethod javaMethod;
            if (!javaTerm.isJavaMethod() || javaTerm.isPrivate() || !StringUtil.equals(methodName, (javaMethod = (JavaMethod)javaTerm).getName()) || (javaParameters = (javaSignature = javaMethod.getSignature()).getParameters()).size() != 1 || !(parameterType = (javaParameter = javaParameters.get(0)).getParameterType()).startsWith("UnsafeSupplier")) continue;
            if (detailAST.getType() == 27) {
                this.log(detailAST, _MSG_INLINE_IF_STATEMENT, new Object[]{methodName});
            } else {
                this.log(detailAST, _MSG_USE_SET_METHOD_INSTEAD, new Object[]{methodName, parameterType});
            }
            return;
        }
    }

    private void _checkIfStatement(DetailAST literalIfDetailAST, JavaClass javaClass) {
        DetailAST slistDetailAST = literalIfDetailAST.findFirstToken(7);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(slistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            DetailAST dotDetailAST;
            String methodName;
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST == null) continue;
            if (firstChildDetailAST.getType() == 80) {
                if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58) continue;
                String variableName = firstChildDetailAST.getText();
                methodName = "set" + StringUtil.upperCaseFirstLetter(variableName);
                this._checkHasReplacableMethodSignature(firstChildDetailAST, methodName, javaClass);
                continue;
            }
            if (firstChildDetailAST.getType() != 27 || (dotDetailAST = firstChildDetailAST.findFirstToken(59)) != null || !(methodName = this.getMethodName(firstChildDetailAST)).startsWith("set")) continue;
            this._checkHasReplacableMethodSignature(firstChildDetailAST, methodName, javaClass);
        }
    }

    private void _checkSetCall(DetailAST detailAST, List<DetailAST> exprDetailASTList, JavaClass javaClass) {
        block0: for (DetailAST exprDetailAST : exprDetailASTList) {
            DetailAST elistDetailAST;
            DetailAST dotDetailAST;
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 27 || (dotDetailAST = firstChildDetailAST.findFirstToken(59)) != null) continue;
            int startLineNumber = this.getStartLineNumber(firstChildDetailAST);
            String methodName = this.getMethodName(firstChildDetailAST);
            if (!methodName.matches("set[A-Z]\\w*") || (firstChildDetailAST = (elistDetailAST = firstChildDetailAST.findFirstToken(34)).getFirstChild()) == null || firstChildDetailAST.getType() != 28) continue;
            String variableName = StringUtil.lowerCaseFirstLetter(methodName.substring(3));
            List<String> names = this.getNames(detailAST, true);
            if (names.contains(variableName)) continue;
            Pattern pattern = Pattern.compile("\\s(\\S+)\\s+(\\S+\\.)?" + variableName);
            for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
                Matcher matcher;
                if (!javaTerm.isJavaVariable() || javaTerm.isPrivate() || !(matcher = pattern.matcher(javaTerm.getContent())).find()) continue;
                this.log(startLineNumber, _MSG_USE_ASSIGN_INSTEAD, new Object[]{javaTerm.getName(), methodName});
                continue block0;
            }
        }
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        if (this._bundleSymbolicNamesMap == null) {
            this._bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        }
        return this._bundleSymbolicNamesMap;
    }

    private JavaClass _getJavaClass(DetailAST detailAST, DetailAST parentDetailAST) throws IOException, ParseException {
        String fullyQualifiedTypeName = null;
        DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            fullyQualifiedTypeName = this.getFullyQualifiedTypeName(firstChildDetailAST.getText(), detailAST, false);
        } else if (firstChildDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            fullyQualifiedTypeName = fullIdent.getText();
        }
        if (fullyQualifiedTypeName == null) {
            return null;
        }
        String absolutePath = this.getAbsolutePath();
        File javaFile = JavaSourceUtil.getJavaFile(fullyQualifiedTypeName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath));
        if (javaFile == null) {
            return null;
        }
        return JavaClassParser.parseJavaClass(SourceUtil.getAbsolutePath(javaFile), FileUtil.read(javaFile));
    }

    private synchronized String _getRootDirName(String absolutePath) {
        if (this._rootDirName != null) {
            return this._rootDirName;
        }
        this._rootDirName = SourceUtil.getRootDirName(absolutePath);
        return this._rootDirName;
    }
}

