/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaUpdateCommerceAddressCheck
extends BaseUpgradeCheck {
    private static final String[] _METHODS = new String[]{"getCommerceAddressId", "getName", "getDescription", "getStreet1", "getStreet2", "getStreet3", "getCity", "getZip", "getRegionId", "getCountryId", "getPhoneNumber", "getType"};
    private static final Pattern _pattern = Pattern.compile("\\t+\\w+\\.\\s*updateCommerceAddress(\\(\\s*(\\w+)\\s*\\));");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Matcher matcher = _pattern.matcher(javaMethodContent);
            while (matcher.find() && this._isCommerceAddress(javaMethodContent, content, matcher)) {
                String line = matcher.group();
                String newLine = StringUtil.replace(line, matcher.group(1), this._getNewUpdateCommerceAddressImplementation(SourceUtil.getIndent(line), matcher.group(2)));
                javaMethodContent = StringUtil.replace(javaMethodContent, line, newLine);
            }
            content = StringUtil.replace(content, javaMethod.getContent(), javaMethodContent);
        }
        return content;
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.portal.kernel.service.ServiceContextThreadLocal"};
    }

    private String _getNewUpdateCommerceAddressImplementation(String indent, String variable) {
        StringBundler sb = new StringBundler(7);
        sb.append("(");
        for (String method : _METHODS) {
            sb.append("\n");
            sb.append(indent);
            sb.append("\t");
            sb.append(variable);
            sb.append(".");
            sb.append(method);
            sb.append("(),");
        }
        sb.append("\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("ServiceContextThreadLocal.getServiceContext()");
        sb.append("\n");
        sb.append(indent);
        sb.append(")");
        return sb.toString();
    }

    private boolean _isCommerceAddress(String content, String fileContent, Matcher matcher) {
        return Objects.equals(this.getVariableTypeName(content, fileContent, matcher.group(2)), "CommerceAddress") && (this.hasClassOrVariableName("CommerceAddressService", content, fileContent, matcher.group()) || this.hasClassOrVariableName("CommerceAddressLocalService", content, fileContent, matcher.group()));
    }
}

