/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaAssetEntryAssetCategoriesCheck
extends BaseUpgradeCheck {
    private static final String _NEW_ADD_METHOD = "_assetEntryAssetCategoryRelLocalService.addAssetEntryAssetCategoryRel";
    private static final String _NEW_DELETE_METHOD = "_assetEntryAssetCategoryRelLocalService.deleteAssetEntryAssetCategoryRel";
    private static final Pattern _addOrDeleteAssetEntryAssetCategoriesPattern = Pattern.compile("(\\w*\\.(?:addAssetEntryAssetCategories|deleteAssetEntryAssetCategories))\\(\\s*\\w+,\\s*(\\w+)\\s*\\)");
    private static final Pattern _addOrDeleteAssetEntryAssetCategoryPattern = Pattern.compile("(\\w*\\.(?:addAssetEntryAssetCategory|deleteAssetEntryAssetCategory))\\(\\s*\\w+,\\s*(\\w+)\\s*\\)");

    @Override
    protected String afterFormat(String fileName, String absolutePath, String content, String newContent) {
        newContent = this.addNewImports(fileName, newContent);
        return StringUtil.replaceLast(newContent, '}', "\n\t@Reference\n\tprivate AssetEntryAssetCategoryRelLocalService\n\t\t_assetEntryAssetCategoryRelLocalService;\n\n}");
    }

    @Override
    protected String format(String fileName, String absolutePath, String content) {
        String newContent = this._replaceAddOrDeleteAssetCategories(content);
        return this._replaceAddOrDeleteAssetCategory(newContent);
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.asset.entry.rel.service.AssetEntryAssetCategoryRelLocalService", "org.osgi.service.component.annotations.Reference"};
    }

    private String _replaceAddOrDeleteAssetCategories(String content) {
        String newContent = content;
        Matcher matcher = _addOrDeleteAssetEntryAssetCategoriesPattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group();
            if (!this.hasClassOrVariableName("AssetCategoryLocalService", newContent, newContent, methodCall)) continue;
            String line = this.getLine(content, this.getLineNumber(content, matcher.start()));
            String indent = SourceUtil.getIndent(line);
            String newLine = null;
            String newMethodCall = null;
            String secondParameter = matcher.group(2);
            String variableTypeName = this.getVariableTypeName(newContent, newContent, secondParameter, true);
            if (variableTypeName.equals("List<AssetCategory>")) {
                newLine = StringBundler.concat(indent, "for (AssetCategory assetCategory : ", secondParameter, ") {\n\t", line);
                newMethodCall = StringUtil.replace(methodCall, secondParameter, "assetCategory.getCategoryId()");
            } else {
                newLine = StringBundler.concat(indent, "for (long assetCategoryId : ", secondParameter, ") {\n\t", line);
                newMethodCall = StringUtil.replace(methodCall, secondParameter, "assetCategoryId");
            }
            newContent = StringUtil.replaceFirst(newContent, line, newLine);
            newMethodCall = StringBundler.concat(newMethodCall, ";", "\n", indent, "}");
            newMethodCall = StringUtil.replace(newMethodCall, "(\n", "(\n\t");
            newMethodCall = StringUtil.replace(newMethodCall, ",\n", ",\n\t");
            String methodStart = matcher.group(1);
            newMethodCall = methodStart.contains("addAssetEntryAssetCategories") ? StringUtil.replace(newMethodCall, methodStart, _NEW_ADD_METHOD) : StringUtil.replace(newMethodCall, methodStart, _NEW_DELETE_METHOD);
            newContent = StringUtil.replaceFirst(newContent, methodCall + ";", newMethodCall);
        }
        return newContent;
    }

    private String _replaceAddOrDeleteAssetCategory(String content) {
        String newContent = content;
        Matcher matcher = _addOrDeleteAssetEntryAssetCategoryPattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group();
            if (!this.hasClassOrVariableName("AssetCategoryLocalService", newContent, newContent, methodCall)) continue;
            String newMethodCall = null;
            String methodStart = matcher.group(1);
            newMethodCall = methodStart.contains("addAssetEntryAssetCategory") ? StringUtil.replace(methodCall, methodStart, _NEW_ADD_METHOD) : StringUtil.replace(methodCall, methodStart, _NEW_DELETE_METHOD);
            String secondParameter = matcher.group(2);
            String variableTypeName = this.getVariableTypeName(newContent, newContent, secondParameter);
            if (variableTypeName != null && variableTypeName.equals("AssetCategory")) {
                newMethodCall = StringUtil.replace(newMethodCall, secondParameter, secondParameter + ".getCategoryId()");
            }
            newContent = StringUtil.replaceFirst(newContent, methodCall, newMethodCall);
        }
        return newContent;
    }
}

