/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class NewFileCheck
extends BaseFileCheck {
    private static final String _FORBIDDEN_DIR_NAMES_KEY = "forbiddenDirNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> forbiddenDirNames = this.getAttributeValues(_FORBIDDEN_DIR_NAMES_KEY, absolutePath);
        if (forbiddenDirNames.isEmpty()) {
            return content;
        }
        String portalBranchName = this.getAttributeValue("git.liferay.portal.branch", absolutePath);
        for (String forbiddenDirName : forbiddenDirNames) {
            int pos = absolutePath.indexOf(forbiddenDirName);
            if (pos == -1) continue;
            URL url = SourceFormatterUtil.getPortalGitURL(absolutePath.substring(pos), portalBranchName);
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setReadTimeout(5000);
                httpURLConnection.setRequestMethod("HEAD");
                if (httpURLConnection.getResponseCode() != 200) {
                    this.addMessage(fileName, "Do not add new files to '" + forbiddenDirName + "'");
                }
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                this.addMessage(fileName, exception.getMessage());
            }
        }
        return content;
    }
}

