/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesFeatureFlagsCheck
extends BaseFileCheck {
    private static final Pattern _deprecationFeatureFlagPattern = Pattern.compile("feature\\.flag\\.([A-Z]+-\\d+)\\.type=deprecation");
    private static final Pattern _featureFlagPattern1 = Pattern.compile("feature\\.flag[.=]([A-Z]+-\\d+)");
    private static final Pattern _featureFlagPattern2 = Pattern.compile("FeatureFlagManagerUtil\\.isEnabled\\(");
    private static final Pattern _featureFlagPattern3 = Pattern.compile("Liferay\\.FeatureFlags\\['(.+?)'\\]");
    private static final Pattern _featureFlagPattern4 = Pattern.compile("\"featureFlag\": \"(.+?)\"");
    private static final Pattern _featureFlagsPattern = Pattern.compile("(\n|\\A)##\n## Feature Flag\n##(\n\n[\\s\\S]*?)(?=(\n\n##|\\Z))");
    private List<String> _allFileNames;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/portal-impl/src/portal.properties")) {
            return content;
        }
        this._checkUnnecessaryFeatureFlags(fileName, content);
        return this._generateFeatureFlags(content);
    }

    private void _checkUnnecessaryFeatureFlags(String fileName, String content) throws IOException {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String value;
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("feature.flag.") || !key.endsWith(".type") || !StringUtil.equals(value = properties.getProperty(key), "dev")) continue;
            this.addMessage(fileName, "Remove unnecessary property '" + key + "', since 'dev' is the default value");
        }
    }

    private String _generateFeatureFlags(String content) throws IOException {
        ArrayList<String> featureFlagKeys = new ArrayList<String>();
        List<String> fileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[]{"**/test/**"}, new String[]{"**/bnd.bnd", "**/*.java", "**/*.js", "**/*.json", "**/*.jsp", "**/*.jspf", "**/*.jsx", "**/*.ts", "**/*.tsx"}, this.getSourceFormatterExcludes(), true);
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            String fileContent = FileUtil.read(new File(fileName));
            if (fileName.endsWith("bnd.bnd")) {
                String liferaySiteInitializerFeatureFlagKey = BNDSourceUtil.getDefinitionValue(fileContent, "Liferay-Site-Initializer-Feature-Flag");
                if (liferaySiteInitializerFeatureFlagKey == null) continue;
                featureFlagKeys.add(liferaySiteInitializerFeatureFlagKey);
                continue;
            }
            if (fileName.endsWith(".java")) {
                featureFlagKeys.addAll(this._getFeatureFlagKeys(fileContent, _featureFlagPattern1));
                featureFlagKeys.addAll(this._getFeatureFlagKeys(fileContent, true));
                continue;
            }
            if (fileName.endsWith(".json")) {
                featureFlagKeys.addAll(this._getFeatureFlagKeys(fileContent, _featureFlagPattern4));
                continue;
            }
            if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
                featureFlagKeys.addAll(this._getFeatureFlagKeys(fileContent, _featureFlagPattern3));
                featureFlagKeys.addAll(this._getFeatureFlagKeys(fileContent, false));
                continue;
            }
            featureFlagKeys.addAll(this._getFeatureFlagKeys(fileContent, _featureFlagPattern3));
        }
        ListUtil.distinct(featureFlagKeys, new NaturalOrderStringComparator());
        Matcher matcher = _featureFlagsPattern.matcher(content);
        if (matcher.find()) {
            String matchedFeatureFlags = matcher.group(2);
            if (featureFlagKeys.isEmpty()) {
                if (matchedFeatureFlags.contains("feature.flag.")) {
                    return StringUtil.replaceFirst(content, matchedFeatureFlags, "", matcher.start(2));
                }
                return content;
            }
            ArrayList<String> deprecationFeatureFlagKeys = new ArrayList<String>();
            Matcher deprecationFeatureFlagKeyMatcher = _deprecationFeatureFlagPattern.matcher(content);
            while (deprecationFeatureFlagKeyMatcher.find()) {
                deprecationFeatureFlagKeys.add(deprecationFeatureFlagKeyMatcher.group(1));
            }
            StringBundler sb = new StringBundler(featureFlagKeys.size() * 14);
            for (String featureFlagKey : featureFlagKeys) {
                String featureFlagPropertyKey = "feature.flag." + featureFlagKey;
                String environmentVariable = ToolsUtil.encodeEnvironmentProperty(featureFlagPropertyKey);
                sb.append("\n");
                sb.append("\n");
                sb.append("    ");
                sb.append("#");
                sb.append("\n");
                sb.append("    # Env: ");
                sb.append(environmentVariable);
                sb.append("\n");
                sb.append("    ");
                sb.append("#");
                sb.append("\n");
                sb.append("    ");
                sb.append(featureFlagPropertyKey);
                sb.append("=");
                if (deprecationFeatureFlagKeys.contains(featureFlagKey)) {
                    sb.append(true);
                    continue;
                }
                sb.append(false);
            }
            content = matchedFeatureFlags.contains("feature.flag.") ? StringUtil.replaceFirst(content, matchedFeatureFlags, sb.toString(), matcher.start(2)) : StringUtil.insert(content, sb.toString(), matcher.start(2));
        }
        return content;
    }

    private List<String> _getFeatureFlagKeys(String content, boolean javaSource) {
        ArrayList<String> featureFlagKeys = new ArrayList<String>();
        Matcher matcher = _featureFlagPattern2.matcher(content);
        while (matcher.find()) {
            String methodCall = null;
            methodCall = javaSource ? JavaSourceUtil.getMethodCall(content, matcher.start()) : JavaSourceUtil.getMethodCall(content.substring(matcher.start()), 0);
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            if (parameterList.isEmpty()) {
                return featureFlagKeys;
            }
            String parameter = null;
            parameter = parameterList.size() == 1 ? parameterList.get(0) : parameterList.get(1);
            if (parameter == null || !parameter.endsWith("\"") || !parameter.startsWith("\"")) continue;
            featureFlagKeys.add(StringUtil.unquote(parameter));
        }
        return featureFlagKeys;
    }

    private List<String> _getFeatureFlagKeys(String content, Pattern pattern) {
        ArrayList<String> featureFlagKeys = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            featureFlagKeys.add(matcher.group(1));
        }
        return featureFlagKeys;
    }
}

