/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeFetchCPDefinitionByCProductExternalReferenceCodeCheck
extends BaseJavaTermCheck {
    private static final Pattern _methodCallPattern = Pattern.compile("\\w+\\.\\s*fetchCPDefinitionByCProductExternalReferenceCode\\((\\s*.+,\\s*.+)\\s*\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        List<String> importNames = javaTerm.getImportNames();
        String content = javaTerm.getContent();
        if (!importNames.contains("com.liferay.commerce.product.service.CPDefinitionLocalService") && !importNames.contains("com.liferay.commerce.product.service.CPDefinitionService")) {
            return content;
        }
        Matcher matcher = _methodCallPattern.matcher(content);
        String newContent = content;
        while (matcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
            if (!this._checkMethodCall(content, fileContent, methodCall)) continue;
            newContent = StringUtil.replace(newContent, methodCall, this._reorderParameters(methodCall, matcher.group(1)));
        }
        return newContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private boolean _checkMethodCall(String content, String fileContent, String methodCall) {
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        String secondParameter = parameterList.get(1);
        if (!SourceUtil.isLiteralString(secondParameter) && !Objects.equals(this.getVariableTypeName(content, fileContent, secondParameter), "String")) {
            return false;
        }
        return this.hasClassOrVariableName("CPDefinitionService", content, fileContent, methodCall) || this.hasClassOrVariableName("CPDefinitionLocalService", content, fileContent, methodCall);
    }

    private String _reorderParameters(String methodCall, String parameters) {
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        return StringUtil.replace(methodCall, parameters, StringBundler.concat(parameterList.get(1), ", ", parameterList.get(0)));
    }
}

