/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseUpgradeCheck
extends BaseFileCheck {
    private static final Pattern _copyrightPattern = Pattern.compile("(<%--\\s*(\\/\\*)+(\\n|.)*(\\*\\/)+\\s*--%>)");
    private static final Pattern _includesPattern = Pattern.compile("(<%@\\s*include\\s*(.+)%>\\s*)+", 8);

    public boolean hasValidParameters(int expectedParametersSize, String fileName, String javaMethodContent, String message, List<String> parameterList, String[] parameterTypes) {
        if (parameterList.size() != expectedParametersSize) {
            return false;
        }
        if (!this.hasParameterTypes(javaMethodContent, javaMethodContent, ArrayUtil.toStringArray(parameterList), parameterTypes)) {
            this.addMessage(fileName, message);
            return false;
        }
        return true;
    }

    protected String addNewImports(String fileName, String newContent) {
        String[] newImports = this.getNewImports();
        if (newImports == null) {
            return newContent;
        }
        if (fileName.endsWith(".java")) {
            newContent = JavaSourceUtil.addImports(newContent, newImports);
        } else if (fileName.endsWith(".jsp")) {
            newContent = this.addNewImportsJSPHeader(newContent, newImports);
        }
        return newContent;
    }

    protected String addNewImportsJSPHeader(String newContent, String[] newImports) {
        Arrays.sort(newImports);
        Matcher includesMatcher = _includesPattern.matcher(newContent);
        if (includesMatcher.find()) {
            String jspHeader = includesMatcher.group();
            return StringUtil.replaceFirst(newContent, jspHeader, this.getNewImportsJSPHeader(StringUtil.splitLines(jspHeader), newImports));
        }
        Matcher copyrightMatcher = _copyrightPattern.matcher(newContent);
        if (copyrightMatcher.find()) {
            String jspHeader = copyrightMatcher.group(1);
            return StringUtil.replaceFirst(newContent, jspHeader, this.getNewImportsJSPHeader(new String[]{jspHeader}, newImports));
        }
        return this.getNewImportsJSPHeader(new String[0], newImports) + newContent;
    }

    protected String afterFormat(String fileName, String absolutePath, String content, String newContent) {
        return this.addNewImports(fileName, newContent);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this.isValidExtension(fileName)) {
            return content;
        }
        String newContent = this.format(fileName, absolutePath, content);
        if (!content.equals(newContent)) {
            newContent = this.afterFormat(fileName, absolutePath, content, newContent);
        }
        return newContent;
    }

    protected abstract String format(String var1, String var2, String var3) throws Exception;

    protected String[] getNewImports() {
        return null;
    }

    protected String getNewImportsJSPHeader(String[] jspHeaders, String[] newImports) {
        StringBundler sb = new StringBundler(4);
        for (String jspHeader : jspHeaders) {
            sb.append(jspHeader);
            sb.append("\n");
        }
        for (String newImport : newImports) {
            sb.append("<%@ page import=\"");
            sb.append(newImport);
            sb.append("\" %>");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String[] getValidExtensions() {
        return new String[]{"java"};
    }

    protected boolean isValidExtension(String fileName) {
        for (String extension : this.getValidExtensions()) {
            if (!fileName.endsWith('.' + extension)) continue;
            return true;
        }
        return false;
    }
}

