/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.JavaAnnotationsCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaMetaAnnotationsCheck
extends JavaAnnotationsCheck {
    private static final String _CHECK_CONFIGURATION_NAME_KEY = "checkConfigurationName";
    private static final Pattern _annotationMetaTypePattern = Pattern.compile("[\\s\\(](name|description) = \"%");
    private static final Pattern _annotationMetaValueKeyPattern = Pattern.compile("\\s(\\w+) = \"([\\w\\.\\-]+?)\"");
    private static final Pattern _annotationNameValueKeyPattern = Pattern.compile("\\sname = \"([\\w\\.\\-]+?)\"");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        return this.formatAnnotations(fileName, absolutePath, (JavaClass)javaTerm, fileContent);
    }

    @Override
    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) {
        if (!annotation.contains("@Meta.")) {
            return annotation;
        }
        this._checkDelimeters(fileName, fileContent, annotation);
        if (this.isAttributeValue(_CHECK_CONFIGURATION_NAME_KEY, absolutePath)) {
            this._checkConfigurationNameValue(fileName, fileContent, annotation);
        }
        annotation = this._fixOCDId(fileName, annotation, javaClass.getPackageName());
        annotation = this._fixTypeProperties(annotation);
        return annotation;
    }

    private void _checkConfigurationNameValue(String fileName, String content, String annotation) {
        String nameValue;
        if (!annotation.contains("@Meta.OCD")) {
            return;
        }
        Matcher matcher = _annotationNameValueKeyPattern.matcher(annotation);
        if (matcher.find() && !(nameValue = matcher.group(1)).endsWith("-configuration-name")) {
            this.addMessage(fileName, "Value for 'name' should end with '-configuration-name'", this.getLineNumber(content, content.indexOf(matcher.group())));
        }
    }

    private void _checkDelimeter(String fileName, String content, Matcher matcher, String key, String correctDelimeter, String incorrectDelimeter) {
        if (!key.equals(matcher.group(1))) {
            return;
        }
        String value = matcher.group(2);
        if (!value.contains(incorrectDelimeter)) {
            return;
        }
        StringBundler sb = new StringBundler(7);
        sb.append("Value '");
        sb.append(value);
        sb.append("' for key '");
        sb.append(key);
        sb.append("' should use '");
        sb.append(correctDelimeter);
        sb.append("' as delimeter");
        this.addMessage(fileName, sb.toString(), this.getLineNumber(content, content.indexOf(matcher.group())));
    }

    private void _checkDelimeters(String fileName, String content, String annotation) {
        Matcher matcher = _annotationMetaValueKeyPattern.matcher(annotation);
        while (matcher.find()) {
            this._checkDelimeter(fileName, content, matcher, "description", "-", ".");
            this._checkDelimeter(fileName, content, matcher, "id", ".", "-");
            this._checkDelimeter(fileName, content, matcher, "name", "-", ".");
        }
    }

    private String _fixOCDId(String fileName, String annotation, String packageName) {
        return annotation.replaceFirst("(@Meta\\.OCD\\([^\\{]+id = )\".+?\"", StringBundler.concat("$1\"", packageName, ".", JavaSourceUtil.getClassName(fileName), "\""));
    }

    private String _fixTypeProperties(String annotation) {
        if (!annotation.contains("@Meta.")) {
            return annotation;
        }
        Matcher matcher = _annotationMetaTypePattern.matcher(annotation);
        if (!matcher.find()) {
            return annotation;
        }
        return StringUtil.replaceFirst(annotation, "%", "", matcher.start());
    }
}

