/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseTagAttributesCheck
extends BaseFileCheck {
    private static final Pattern _attributeNamePattern = Pattern.compile("[a-zA-Z]+[-_:a-zA-Z0-9]*");
    private static final Pattern _incorrectLineBreakPattern = Pattern.compile("\n(\t*)(<\\w[-_:\\w]*) (.*)([\"']|%=)\n[\\s\\S]*?>\n");
    private static final Pattern _jspTaglibPattern = Pattern.compile("\t*<[-\\w]+:[-\\w]+ .");
    private static final Pattern _multilineTagPattern = Pattern.compile("(([ \t]*)<[-\\w:]+\n.*?([^%])(/?>))(\n|$)", 32);

    protected Tag doFormatLineBreaks(Tag tag, String absolutePath) {
        return tag;
    }

    protected String formatIncorrectLineBreak(String fileName, String content) {
        Matcher matcher = _incorrectLineBreakPattern.matcher(content);
        while (matcher.find()) {
            String s = this.stripQuotes(matcher.group(3));
            if (s.contains(">")) continue;
            if (this.getLevel(matcher.group(), "<", ">") != 0) {
                this.addMessage(fileName, "There should be a line break after '" + matcher.group(2) + "'", this.getLineNumber(content, matcher.start(2)));
                continue;
            }
            return StringUtil.replaceFirst(content, " ", "\n\t" + matcher.group(1), matcher.start());
        }
        return content;
    }

    protected Tag formatLineBreaks(Tag tag, String absolutePath, boolean forceSingleLine) {
        if (forceSingleLine) {
            tag.setMultiLine(false);
            return tag;
        }
        Map<String, String> attributesMap = tag.getAttributesMap();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String attributeValue = entry.getValue();
            if (!attributeValue.contains("\n")) continue;
            tag.setMultiLine(true);
            return tag;
        }
        return this.doFormatLineBreaks(tag, absolutePath);
    }

    protected String formatMultiLinesTagAttributes(String absolutePath, String content, boolean escapeQuotes) throws Exception {
        Matcher matcher = _multilineTagPattern.matcher(content);
        while (matcher.find()) {
            char c;
            if (matcher.start() != 0 && (c = content.charAt(matcher.start() - 1)) != '\n') continue;
            String tag = matcher.group(1);
            String lastLine = StringUtil.trim(this.getLine(content, this.getLineNumber(content, matcher.end(1))));
            if (lastLine.matches("></[-\\w:]+>")) {
                String newTag = StringUtil.replaceLast(tag, lastLine, "/>");
                return StringUtil.replace(content, tag, newTag);
            }
            if (this.getLevel(this._getStrippedTag(tag, "\"", "'"), "<", ">") != 0) continue;
            String beforeClosingTagChar = matcher.group(3);
            if (!beforeClosingTagChar.equals("\n") && !beforeClosingTagChar.equals("\t")) {
                String closingTag = matcher.group(4);
                String whitespace = matcher.group(2);
                String indent = StringUtil.removeChar(whitespace, ' ');
                return StringUtil.replaceFirst(content, closingTag, "\n" + indent + closingTag, matcher.start(3));
            }
            String newTag = this.formatTagAttributes(absolutePath, tag, escapeQuotes, false);
            if (tag.equals(newTag)) continue;
            return StringUtil.replace(content, tag, newTag);
        }
        return content;
    }

    protected String formatTagAttributes(String absolutePath, String s, boolean escapeQuotes, boolean forceSingleLine) throws Exception {
        Tag tag = this.parseTag(s, escapeQuotes);
        if (tag == null) {
            return s;
        }
        tag = this.formatTagAttributeType(absolutePath, tag);
        tag = this.sortHTMLTagAttributes(tag);
        if (this.isPortalSource() || this.isSubrepository()) {
            tag = this.formatLineBreaks(tag, absolutePath, forceSingleLine);
        }
        return tag.toString();
    }

    protected Tag formatTagAttributeType(String absolutePath, Tag tag) throws Exception {
        return tag;
    }

    protected List<String> getJSPTags(String line) {
        ArrayList<String> jspTags = new ArrayList<String>();
        Matcher matcher = _jspTaglibPattern.matcher(line);
        while (matcher.find()) {
            String tag = this.getTag(line, matcher.start());
            if (tag == null) {
                return jspTags;
            }
            jspTags.add(tag);
        }
        return jspTags;
    }

    protected String getTag(String s, int fromIndex) {
        String part;
        int x = fromIndex;
        do {
            if ((x = s.indexOf(">", x + 1)) != -1) continue;
            return null;
        } while (this.getLevel(part = s.substring(fromIndex, x + 1), "<", ">") != 0);
        return part;
    }

    protected Tag parseTag(String s, boolean escapeQuotes) {
        String indent = SourceUtil.getIndent(s);
        s = StringUtil.trim(s);
        boolean multiLine = false;
        int x = -1;
        if (s.contains("\n")) {
            multiLine = true;
            x = s.indexOf(10);
        } else {
            x = s.indexOf(32);
        }
        if (x == -1) {
            return null;
        }
        String tagName = s.substring(1, x);
        Tag tag = new Tag(tagName, indent, multiLine, escapeQuotes);
        if ((s = s.substring(x + 1)).equals(">") || s.equals("/>") || tagName.matches("[-\\w:]+") && s.matches(">\\s*</" + tagName + "\\s*>")) {
            tag.setClosingTag(StringUtil.removeChars(s, '\n', ' ', '\t'));
            return tag;
        }
        do {
            String attributeValue;
            if ((x = s.indexOf(61)) == -1) {
                return null;
            }
            String attributeName = StringUtil.trim(s.substring(0, x));
            if (!this._isValidAttributName(attributeName)) {
                return null;
            }
            char delimeter = (s = StringUtil.trimLeading(s.substring(x + 1))).charAt(0);
            if (delimeter != '\'' && delimeter != '\"') {
                return null;
            }
            s = s.substring(1);
            x = -1;
            do {
                if ((x = s.indexOf(delimeter, x + 1)) == -1) {
                    return null;
                }
                attributeValue = s.substring(0, x);
                if (!attributeName.equals("class")) continue;
                attributeValue = StringUtil.trim(attributeValue);
            } while ((!attributeValue.startsWith("<%") || this.getLevel(attributeValue, "<%", "%>") != 0) && (attributeValue.startsWith("<%") || this.getLevel(attributeValue, "<", ">") != 0));
            tag.putAttribute(attributeName, attributeValue);
        } while (!(s = StringUtil.trim(s.substring(x + 1))).equals(">") && !s.equals("/>") && (!tagName.matches("[-\\w:]+") || !s.matches(">\\s*</" + tagName + "\\s*>")));
        tag.setClosingTag(StringUtil.removeChars(s, '\n', ' ', '\t'));
        return tag;
    }

    protected Tag sortHTMLTagAttributes(Tag tag) {
        String tagFullName = tag.getFullName();
        if (tagFullName.equals("liferay-ui:tabs")) {
            return tag;
        }
        Map<String, String> attributesMap = tag.getAttributesMap();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            List<String> htmlAttributes;
            String attributeName = entry.getKey();
            if (tagFullName.equals("svg") && attributeName.equals("viewBox")) continue;
            String attributeValue = entry.getValue();
            if (attributeValue.matches("([-a-z0-9]+ )+[-a-z0-9]+")) {
                htmlAttributes = ListUtil.fromArray(StringUtil.split(attributeValue, " "));
                Collections.sort(htmlAttributes);
                tag.putAttribute(attributeName, StringUtil.merge(htmlAttributes, " "));
                continue;
            }
            if (!attributeValue.matches("([-a-z0-9]+,)+[-a-z0-9]+") || !tagFullName.equals("aui:script") || !attributeName.equals("use")) continue;
            htmlAttributes = ListUtil.fromArray(StringUtil.split(attributeValue, ","));
            Collections.sort(htmlAttributes);
            tag.putAttribute(attributeName, StringUtil.merge(htmlAttributes, ","));
        }
        return tag;
    }

    private String _getStrippedTag(String tag, String ... quotes) {
        for (String quote : quotes) {
            int x;
            while ((x = tag.indexOf(quote + "<%=")) != -1) {
                int y = tag.indexOf("%>" + quote, x);
                if (y == -1) {
                    return tag;
                }
                tag = tag.substring(0, x) + tag.substring(y + 3);
            }
        }
        return tag;
    }

    private boolean _isValidAttributName(String attributeName) {
        if (Validator.isNull(attributeName)) {
            return false;
        }
        Matcher matcher = _attributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    protected class Tag {
        private Map<String, String> _attributesMap = new TreeMap<String, String>(new NaturalOrderStringComparator());
        private String _closingTag;
        private final boolean _escapeQuotes;
        private final String _fullName;
        private final String _indent;
        private boolean _multiLine;
        private final String _name;
        private final String _taglibName;

        public Tag(String fullName, String indent, boolean multiLine, boolean escapeQuotes) {
            this._fullName = fullName;
            this._indent = indent;
            this._multiLine = multiLine;
            this._escapeQuotes = escapeQuotes;
            int x = this._fullName.indexOf(":");
            if (x != -1) {
                this._name = this._fullName.substring(x + 1);
                this._taglibName = this._fullName.substring(0, x);
            } else {
                this._name = this._fullName;
                this._taglibName = null;
            }
        }

        public Map<String, String> getAttributesMap() {
            return this._attributesMap;
        }

        public String getFullName() {
            return this._fullName;
        }

        public String getName() {
            return this._name;
        }

        public String getTaglibName() {
            return this._taglibName;
        }

        public void putAttribute(String attributeName, String attributeValue) {
            this._attributesMap.put(attributeName, attributeValue);
        }

        public void setClosingTag(String closingTag) {
            this._closingTag = closingTag;
        }

        public void setMultiLine(boolean multiLine) {
            this._multiLine = multiLine;
        }

        public String toString() {
            StringBundler sb = new StringBundler();
            sb.append(this._indent);
            sb.append("<");
            sb.append(this._fullName);
            for (Map.Entry<String, String> entry : this._attributesMap.entrySet()) {
                if (this._multiLine) {
                    sb.append("\n");
                    sb.append(this._indent);
                    sb.append("\t");
                } else {
                    sb.append(" ");
                }
                sb.append(entry.getKey());
                sb.append("=");
                String delimeter = null;
                String attributeValue = entry.getValue();
                delimeter = this._escapeQuotes || !attributeValue.contains("\"") || !this._fullName.contains(":") ? "\"" : "'";
                sb.append(delimeter);
                if (!this._escapeQuotes) {
                    sb.append(attributeValue);
                } else {
                    sb.append(StringUtil.replace(attributeValue, '\"', "&quot;"));
                }
                sb.append(delimeter);
            }
            if (this._multiLine) {
                sb.append("\n");
                sb.append(this._indent);
            } else if (this._closingTag.equals("/>")) {
                sb.append(" ");
            }
            sb.append(this._closingTag);
            return sb.toString();
        }
    }
}

