/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;

public class HashMapDictionaryBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> HashMapDictionaryWrapper<K, V> create(Map<K, V> map) {
        return new HashMapDictionaryWrapper<K, V>(map);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        HashMapDictionaryWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>();
        return hashMapDictionaryWrapper.put(inputCollection, unsafeFunction);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        HashMapDictionaryWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return hashMapDictionaryWrapper.put(key, valueUnsafeSupplier);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> put(K key, V value) {
        HashMapDictionaryWrapper<K, V> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<K, V>();
        return hashMapDictionaryWrapper.put(key, value);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        HashMapDictionaryWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return hashMapDictionaryWrapper.put(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        HashMapDictionaryWrapper<K, V> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<K, V>();
        return hashMapDictionaryWrapper.put(keyUnsafeSupplier, value);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> putAll(Dictionary<? extends K, ? extends V> dictionary) {
        HashMapDictionaryWrapper<? extends K, ? extends V> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<K, V>();
        return hashMapDictionaryWrapper.putAll(dictionary);
    }

    public static <K, V> HashMapDictionaryWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        HashMapDictionaryWrapper<? extends K, ? extends V> hashMapDictionaryWrapper = new HashMapDictionaryWrapper<K, V>();
        return hashMapDictionaryWrapper.putAll(inputMap);
    }

    public static final class HashMapDictionaryWrapper<K, V> {
        private final HashMapDictionary<K, V> _hashMapDictionary;

        public HashMapDictionaryWrapper() {
            this._hashMapDictionary = new HashMapDictionary();
        }

        public HashMapDictionaryWrapper(Map<K, V> map) {
            this._hashMapDictionary = new HashMapDictionary<K, V>(map);
        }

        public HashMapDictionary<K, V> build() {
            return this._hashMapDictionary;
        }

        public HashMapDictionaryWrapper<K, V> put(Collection<? extends K> keyCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            try {
                for (K key : keyCollection) {
                    V value = unsafeFunction.apply(key);
                    if (value == null) continue;
                    this._hashMapDictionary.put(key, value);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return this;
        }

        public HashMapDictionaryWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            if (valueUnsafeSupplier == null) {
                this._hashMapDictionary.put(key, null);
                return this;
            }
            try {
                V value = valueUnsafeSupplier.get();
                if (value != null) {
                    this._hashMapDictionary.put(key, value);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return this;
        }

        public HashMapDictionaryWrapper<K, V> put(K key, V value) {
            this._hashMapDictionary.put(key, value);
            return this;
        }

        public HashMapDictionaryWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            try {
                K key = keyUnsafeSupplier.get();
                if (key == null) {
                    return this;
                }
                if (valueUnsafeSupplier == null) {
                    this._hashMapDictionary.put(key, null);
                    return this;
                }
                V value = valueUnsafeSupplier.get();
                if (value != null) {
                    this._hashMapDictionary.put(key, value);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return this;
        }

        public HashMapDictionaryWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            try {
                K key = keyUnsafeSupplier.get();
                if (key != null) {
                    this._hashMapDictionary.put(key, value);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return this;
        }

        public HashMapDictionaryWrapper<K, V> putAll(Dictionary<? extends K, ? extends V> dictionary) {
            if (dictionary != null) {
                this._hashMapDictionary.putAll(dictionary);
            }
            return this;
        }

        public HashMapDictionaryWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            if (inputMap != null) {
                this._hashMapDictionary.putAll(inputMap);
            }
            return this;
        }

        protected HashMapDictionary<K, V> getDictionary() {
            return this._hashMapDictionary;
        }
    }
}

