/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLPomFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (!absolutePath.contains("/maven/") && fileName.endsWith("/pom.xml") && Validator.isNotNull(content)) {
            this._checkOrder(fileName, content);
        }
        return content;
    }

    private void _checkOrder(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List dependenciesElements = rootElement.elements("dependencies");
        PomDependencyElementComparator pomDependencyElementComparator = new PomDependencyElementComparator();
        for (Element dependenciesElement : dependenciesElements) {
            this.checkElementOrder(fileName, dependenciesElement, "dependency", null, pomDependencyElementComparator);
        }
    }

    private class PomDependencyElementComparator
    extends ElementComparator {
        private PomDependencyElementComparator() {
        }

        @Override
        public int compare(Element dependencyElement1, Element dependencyElement2) {
            String groupId2;
            String groupId1 = this.getTagValue(dependencyElement1, "groupId");
            if (!groupId1.equals(groupId2 = this.getTagValue(dependencyElement2, "groupId"))) {
                return groupId1.compareTo(groupId2);
            }
            String artifactId1 = this.getTagValue(dependencyElement1, "artifactId");
            String artifactId2 = this.getTagValue(dependencyElement2, "artifactId");
            return artifactId1.compareTo(artifactId2);
        }

        @Override
        public String getElementName(Element element) {
            return StringBundler.concat("{groupId=", this.getTagValue(element, "groupId"), ",artifactId=", this.getTagValue(element, "artifactId"), "}");
        }
    }
}

